/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.MapUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantizationError
implements MapDataVisualization {
    private final DistanceMeasure distance;

    public QuantizationError(DistanceMeasure distanceMeasure) {
        this.distance = distanceMeasure;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> object) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        int[][] nArray = new int[n][n2];
        double[][] dArray = new double[n][n2];
        object = object.iterator();
        while (object.hasNext()) {
            double[] dArray2 = (double[])object.next();
            Neuron neuron = MapUtils.findBest(dArray2, neuronSquareMesh2D, this.distance);
            LocationFinder$Location locationFinder$Location = locationFinder.getLocation(neuron);
            int n3 = locationFinder$Location.getRow();
            int n4 = locationFinder$Location.getColumn();
            int[] nArray2 = nArray[n3];
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
            double[] dArray3 = dArray[n3];
            int n6 = n4;
            dArray3[n6] = dArray3[n6] + this.distance.compute(dArray2, neuron.getFeatures());
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = nArray[i2][i3];
                if (n7 == 0) continue;
                double[] dArray4 = dArray[i2];
                int n8 = i3;
                dArray4[n8] = dArray4[n8] / (double)n7;
            }
        }
        return dArray;
    }
}

