/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.SquareNeighbourhood;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$HorizontalDirection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$SerializationProxy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$VerticalDirection;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuronSquareMesh2D
implements Serializable,
Iterable<Neuron> {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private final int numberOfRows;
    private final int numberOfColumns;
    private final boolean wrapRows;
    private final boolean wrapColumns;
    private final SquareNeighbourhood neighbourhood;
    private final long[][] identifiers;

    NeuronSquareMesh2D(boolean n, boolean n2, SquareNeighbourhood squareNeighbourhood, double[][][] dArray) {
        this.numberOfRows = dArray.length;
        this.numberOfColumns = dArray[0].length;
        if (this.numberOfRows < 2) {
            throw new NumberIsTooSmallException(this.numberOfRows, (Number)2, true);
        }
        if (this.numberOfColumns < 2) {
            throw new NumberIsTooSmallException(this.numberOfColumns, (Number)2, true);
        }
        this.wrapRows = n;
        this.wrapColumns = n2;
        this.neighbourhood = squareNeighbourhood;
        n = dArray[0][0].length;
        this.network = new Network(0L, n);
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        for (n = 0; n < this.numberOfRows; ++n) {
            for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
                this.identifiers[n][n2] = this.network.createNeuron(dArray[n][n2]);
            }
        }
        this.createLinks();
    }

    public NeuronSquareMesh2D(int n, boolean n2, int n3, boolean n4, SquareNeighbourhood squareNeighbourhood, FeatureInitializer[] featureInitializerArray) {
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        if (n3 < 2) {
            throw new NumberIsTooSmallException(n3, (Number)2, true);
        }
        this.numberOfRows = n;
        this.wrapRows = n2;
        this.numberOfColumns = n3;
        this.wrapColumns = n4;
        this.neighbourhood = squareNeighbourhood;
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        n2 = featureInitializerArray.length;
        this.network = new Network(0L, n2);
        for (n4 = 0; n4 < n; ++n4) {
            for (int i2 = 0; i2 < n3; ++i2) {
                double[] dArray = new double[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    dArray[i3] = featureInitializerArray[i3].value();
                }
                this.identifiers[n4][i2] = this.network.createNeuron(dArray);
            }
        }
        this.createLinks();
    }

    private NeuronSquareMesh2D(boolean bl, boolean bl2, SquareNeighbourhood squareNeighbourhood, Network network, long[][] lArray) {
        this.numberOfRows = lArray.length;
        this.numberOfColumns = lArray[0].length;
        this.wrapRows = bl;
        this.wrapColumns = bl2;
        this.neighbourhood = squareNeighbourhood;
        this.network = network;
        this.identifiers = lArray;
    }

    public synchronized NeuronSquareMesh2D copy() {
        long[][] lArray = new long[this.numberOfRows][this.numberOfColumns];
        for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
            for (int i3 = 0; i3 < this.numberOfColumns; ++i3) {
                lArray[i2][i3] = this.identifiers[i2][i3];
            }
        }
        return new NeuronSquareMesh2D(this.wrapRows, this.wrapColumns, this.neighbourhood, this.network.copy(), lArray);
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.network.iterator();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public Neuron getNeuron(int n, int n2) {
        if (n < 0 || n >= this.numberOfRows) {
            throw new OutOfRangeException(n, (Number)0, this.numberOfRows - 1);
        }
        if (n2 < 0 || n2 >= this.numberOfColumns) {
            throw new OutOfRangeException(n2, (Number)0, this.numberOfColumns - 1);
        }
        return this.network.getNeuron(this.identifiers[n][n2]);
    }

    public Neuron getNeuron(int n, int n2, NeuronSquareMesh2D$HorizontalDirection neuronSquareMesh2D$HorizontalDirection, NeuronSquareMesh2D$VerticalDirection neuronSquareMesh2D$VerticalDirection) {
        int[] nArray = this.getLocation(n, n2, neuronSquareMesh2D$HorizontalDirection, neuronSquareMesh2D$VerticalDirection);
        if (nArray == null) {
            return null;
        }
        return this.getNeuron(nArray[0], nArray[1]);
    }

    private int[] getLocation(int n, int n2, NeuronSquareMesh2D$HorizontalDirection neuronSquareMesh2D$HorizontalDirection, NeuronSquareMesh2D$VerticalDirection neuronSquareMesh2D$VerticalDirection) {
        int n3;
        switch (neuronSquareMesh2D$HorizontalDirection) {
            case LEFT: {
                n3 = -1;
                break;
            }
            case RIGHT: {
                n3 = 1;
                break;
            }
            case CENTER: {
                n3 = 0;
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
        n2 += n3;
        if (this.wrapColumns) {
            n2 = n2 < 0 ? (n2 += this.numberOfColumns) : (n2 %= this.numberOfColumns);
        }
        switch (neuronSquareMesh2D$VerticalDirection) {
            case UP: {
                n3 = -1;
                break;
            }
            case DOWN: {
                n3 = 1;
                break;
            }
            case CENTER: {
                n3 = 0;
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
        n += n3;
        if (this.wrapRows) {
            n = n < 0 ? (n += this.numberOfRows) : (n %= this.numberOfRows);
        }
        if (n < 0 || n >= this.numberOfRows || n2 < 0 || n2 >= this.numberOfColumns) {
            return null;
        }
        return new int[]{n, n2};
    }

    /*
     * Unable to fully structure code
     */
    private void createLinks() {
        var1_1 = new ArrayList<Long>();
        var2_2 = this.numberOfRows - 1;
        var3_3 = this.numberOfColumns - 1;
        for (var4_4 = 0; var4_4 < this.numberOfRows; ++var4_4) {
            for (var5_5 = 0; var5_5 < this.numberOfColumns; ++var5_5) {
                var1_1.clear();
                switch (NeuronSquareMesh2D$1.$SwitchMap$org$apache$commons$math3$ml$neuralnet$SquareNeighbourhood[this.neighbourhood.ordinal()]) {
                    case 1: {
                        if (var4_4 > 0) {
                            if (var5_5 > 0) {
                                var1_1.add(this.identifiers[var4_4 - 1][var5_5 - 1]);
                            }
                            if (var5_5 < var3_3) {
                                var1_1.add(this.identifiers[var4_4 - 1][var5_5 + 1]);
                            }
                        }
                        if (var4_4 < var2_2) {
                            if (var5_5 > 0) {
                                var1_1.add(this.identifiers[var4_4 + 1][var5_5 - 1]);
                            }
                            if (var5_5 < var3_3) {
                                var1_1.add(this.identifiers[var4_4 + 1][var5_5 + 1]);
                            }
                        }
                        if (this.wrapRows) {
                            if (var4_4 == 0) {
                                if (var5_5 > 0) {
                                    var1_1.add(this.identifiers[var2_2][var5_5 - 1]);
                                }
                                if (var5_5 < var3_3) {
                                    var1_1.add(this.identifiers[var2_2][var5_5 + 1]);
                                }
                            } else if (var4_4 == var2_2) {
                                if (var5_5 > 0) {
                                    var1_1.add(this.identifiers[0][var5_5 - 1]);
                                }
                                if (var5_5 < var3_3) {
                                    var1_1.add(this.identifiers[0][var5_5 + 1]);
                                }
                            }
                        }
                        if (this.wrapColumns) {
                            if (var5_5 == 0) {
                                if (var4_4 > 0) {
                                    var1_1.add(this.identifiers[var4_4 - 1][var3_3]);
                                }
                                if (var4_4 < var2_2) {
                                    var1_1.add(this.identifiers[var4_4 + 1][var3_3]);
                                }
                            } else if (var5_5 == var3_3) {
                                if (var4_4 > 0) {
                                    var1_1.add(this.identifiers[var4_4 - 1][0]);
                                }
                                if (var4_4 < var2_2) {
                                    var1_1.add(this.identifiers[var4_4 + 1][0]);
                                }
                            }
                        }
                        if (!this.wrapRows || !this.wrapColumns) ** GOTO lbl71
                        if (var4_4 != 0 || var5_5 != 0) ** GOTO lbl60
                        var1_1.add(this.identifiers[var2_2][var3_3]);
                        ** GOTO lbl71
lbl60:
                        // 1 sources

                        if (var4_4 != 0 || var5_5 != var3_3) ** GOTO lbl64
                        var1_1.add(this.identifiers[var2_2][0]);
                        ** GOTO lbl71
lbl64:
                        // 1 sources

                        if (var4_4 != var2_2 || var5_5 != 0) ** GOTO lbl68
                        var1_1.add(this.identifiers[0][var3_3]);
                        ** GOTO lbl71
lbl68:
                        // 1 sources

                        if (var4_4 == var2_2 && var5_5 == var3_3) {
                            var1_1.add(this.identifiers[0][0]);
                        }
                    }
lbl71:
                    // 8 sources

                    case 2: {
                        if (var4_4 > 0) {
                            var1_1.add(this.identifiers[var4_4 - 1][var5_5]);
                        }
                        if (var4_4 < var2_2) {
                            var1_1.add(this.identifiers[var4_4 + 1][var5_5]);
                        }
                        if (this.wrapRows) {
                            if (var4_4 == 0) {
                                var1_1.add(this.identifiers[var2_2][var5_5]);
                            } else if (var4_4 == var2_2) {
                                var1_1.add(this.identifiers[0][var5_5]);
                            }
                        }
                        if (var5_5 > 0) {
                            var1_1.add(this.identifiers[var4_4][var5_5 - 1]);
                        }
                        if (var5_5 < var3_3) {
                            var1_1.add(this.identifiers[var4_4][var5_5 + 1]);
                        }
                        if (!this.wrapColumns) break;
                        if (var5_5 == 0) {
                            var1_1.add(this.identifiers[var4_4][var3_3]);
                            break;
                        }
                        if (var5_5 != var3_3) break;
                        var1_1.add(this.identifiers[var4_4][0]);
                        break;
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
                var6_6 = this.network.getNeuron(this.identifiers[var4_4][var5_5]);
                var7_7 = var1_1.iterator();
                while (var7_7.hasNext()) {
                    var8_9 = (Long)var7_7.next();
                    var8_8 = this.network.getNeuron(var8_9);
                    this.network.addLink(var6_6, var8_8);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        double[][][] dArray = new double[this.numberOfRows][this.numberOfColumns][];
        for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
            for (int i3 = 0; i3 < this.numberOfColumns; ++i3) {
                dArray[i2][i3] = this.getNeuron(i2, i3).getFeatures();
            }
        }
        return new NeuronSquareMesh2D$SerializationProxy(this.wrapRows, this.wrapColumns, this.neighbourhood, dArray);
    }
}

