/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.sofm.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Logistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;

public class QuasiSigmoidDecayFunction {
    private final Logistic sigmoid;
    private final double scale;

    public QuasiSigmoidDecayFunction(double d2, double d3, long l) {
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        if (d3 >= 0.0) {
            throw new NumberIsTooLargeException(d3, (Number)0, false);
        }
        if (l <= 1L) {
            throw new NotStrictlyPositiveException(l);
        }
        double d4 = d2;
        double d5 = l;
        double d6 = d3 * 4.0 / d2;
        this.sigmoid = new Logistic(d4, d5, d6, 1.0, 0.0, 1.0);
        double d7 = this.sigmoid.value(0.0);
        this.scale = d4 / d7;
    }

    public double value(long l) {
        return this.scale * this.sigmoid.value(l);
    }
}

