/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.sofm.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class ExponentialDecayFunction {
    private final double a;
    private final double oneOverB;

    public ExponentialDecayFunction(double d2, double d3, long l) {
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException(d3);
        }
        if (d3 >= d2) {
            throw new NumberIsTooLargeException(d3, (Number)d2, false);
        }
        if (l <= 0L) {
            throw new NotStrictlyPositiveException(l);
        }
        this.a = d2;
        this.oneOverB = -FastMath.log(d3 / d2) / (double)l;
    }

    public double value(long l) {
        return this.a * FastMath.exp((double)(-l) * this.oneOverB);
    }
}

