/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.sofm;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Gaussian;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.MapUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.UpdateAction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;

public class KohonenUpdateAction
implements UpdateAction {
    private final DistanceMeasure distance;
    private final LearningFactorFunction learningFactor;
    private final NeighbourhoodSizeFunction neighbourhoodSize;
    private final AtomicLong numberOfCalls = new AtomicLong(0L);

    public KohonenUpdateAction(DistanceMeasure distanceMeasure, LearningFactorFunction learningFactorFunction, NeighbourhoodSizeFunction neighbourhoodSizeFunction) {
        this.distance = distanceMeasure;
        this.learningFactor = learningFactorFunction;
        this.neighbourhoodSize = neighbourhoodSizeFunction;
    }

    public void update(Network network, double[] dArray) {
        long l = this.numberOfCalls.incrementAndGet() - 1L;
        double d2 = this.learningFactor.value(l);
        Neuron neuron = this.findAndUpdateBestNeuron(network, dArray, d2);
        int n = this.neighbourhoodSize.value(l);
        Gaussian gaussian = new Gaussian(d2, 0.0, n);
        if (n > 0) {
            Collection<Neuron> collection = new HashSet<Neuron>();
            collection.add(neuron);
            HashSet<Neuron> hashSet = new HashSet<Neuron>();
            hashSet.add(neuron);
            int n2 = 1;
            do {
                collection = network.getNeighbours(collection, hashSet);
                for (Neuron neuron2 : collection) {
                    this.updateNeighbouringNeuron(neuron2, dArray, gaussian.value(n2));
                }
                hashSet.addAll(collection);
            } while (++n2 <= n);
        }
    }

    public long getNumberOfCalls() {
        return this.numberOfCalls.get();
    }

    private boolean attemptNeuronUpdate(Neuron neuron, double[] dArray, double d2) {
        double[] dArray2 = neuron.getFeatures();
        dArray = this.computeFeatures(dArray2, dArray, d2);
        return neuron.compareAndSetFeatures(dArray2, dArray);
    }

    private void updateNeighbouringNeuron(Neuron neuron, double[] dArray, double d2) {
        while (!this.attemptNeuronUpdate(neuron, dArray, d2)) {
        }
    }

    private Neuron findAndUpdateBestNeuron(Network network, double[] dArray, double d2) {
        Neuron neuron;
        while (!this.attemptNeuronUpdate(neuron = MapUtils.findBest(dArray, network, this.distance), dArray, d2)) {
        }
        return neuron;
    }

    private double[] computeFeatures(double[] object, double[] object2, double d2) {
        object = new ArrayRealVector((double[])object, false);
        ArrayRealVector arrayRealVector = new ArrayRealVector((double[])object2, false);
        object2 = arrayRealVector;
        return ((RealVector)arrayRealVector.subtract((RealVector)object)).mapMultiplyToSelf(d2).add((RealVector)object).toArray();
    }
}

