/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network$SerializationProxy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements Serializable,
Iterable<Neuron> {
    private static final long serialVersionUID = 20130207L;
    private final ConcurrentHashMap<Long, Neuron> neuronMap = new ConcurrentHashMap();
    private final AtomicLong nextId;
    private final int featureSize;
    private final ConcurrentHashMap<Long, Set<Long>> linkMap = new ConcurrentHashMap();

    Network(long l, int n, Neuron[] neuronArray, long[][] lArray) {
        Object object;
        int n2;
        int n3 = neuronArray.length;
        if (n3 != lArray.length) {
            throw new MathIllegalStateException();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = neuronArray[n2];
            long l2 = ((Neuron)object).getIdentifier();
            if (l2 >= l) {
                throw new MathIllegalStateException();
            }
            this.neuronMap.put(l2, (Neuron)object);
            this.linkMap.put(l2, new HashSet());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            long l3 = neuronArray[n2].getIdentifier();
            Set<Long> set = this.linkMap.get(l3);
            long[] lArray2 = lArray[n2];
            object = lArray2;
            int n4 = lArray2.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Long l4 = (long)object[i2];
                if (this.neuronMap.get(l4) == null) {
                    throw new MathIllegalStateException();
                }
                this.addLinkToLinkSet(set, l4);
            }
        }
        this.nextId = new AtomicLong(l);
        this.featureSize = n;
    }

    public Network(long l, int n) {
        this.nextId = new AtomicLong(l);
        this.featureSize = n;
    }

    public synchronized Network copy() {
        Network network = new Network(this.nextId.get(), this.featureSize);
        for (Map.Entry<Long, Neuron> entry : this.neuronMap.entrySet()) {
            network.neuronMap.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<Long, Object> entry : this.linkMap.entrySet()) {
            network.linkMap.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return network;
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.neuronMap.values().iterator();
    }

    public Collection<Neuron> getNeurons(Comparator<Neuron> comparator) {
        ArrayList<Neuron> arrayList = new ArrayList<Neuron>();
        arrayList.addAll(this.neuronMap.values());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public long createNeuron(double[] dArray) {
        if (dArray.length != this.featureSize) {
            throw new DimensionMismatchException(dArray.length, this.featureSize);
        }
        long l = this.createNextId();
        this.neuronMap.put(l, new Neuron(l, dArray));
        this.linkMap.put(l, new HashSet());
        return l;
    }

    public void deleteNeuron(Neuron neuron) {
        Object object = this.getNeighbours(neuron);
        object = object.iterator();
        while (object.hasNext()) {
            Neuron neuron2 = (Neuron)object.next();
            this.deleteLink(neuron2, neuron);
        }
        this.neuronMap.remove(neuron.getIdentifier());
    }

    public int getFeaturesSize() {
        return this.featureSize;
    }

    public void addLink(Neuron neuron, Neuron neuron2) {
        long l = neuron.getIdentifier();
        long l2 = neuron2.getIdentifier();
        if (neuron != this.getNeuron(l)) {
            throw new NoSuchElementException(Long.toString(l));
        }
        if (neuron2 != this.getNeuron(l2)) {
            throw new NoSuchElementException(Long.toString(l2));
        }
        Network network = this;
        network.addLinkToLinkSet(network.linkMap.get(l), l2);
    }

    private void addLinkToLinkSet(Set<Long> set, long l) {
        set.add(l);
    }

    public void deleteLink(Neuron neuron, Neuron neuron2) {
        long l = neuron.getIdentifier();
        long l2 = neuron2.getIdentifier();
        if (neuron != this.getNeuron(l)) {
            throw new NoSuchElementException(Long.toString(l));
        }
        if (neuron2 != this.getNeuron(l2)) {
            throw new NoSuchElementException(Long.toString(l2));
        }
        Network network = this;
        network.deleteLinkFromLinkSet(network.linkMap.get(l), l2);
    }

    private void deleteLinkFromLinkSet(Set<Long> set, long l) {
        set.remove(l);
    }

    public Neuron getNeuron(long l) {
        Neuron neuron = this.neuronMap.get(l);
        if (neuron == null) {
            throw new NoSuchElementException(Long.toString(l));
        }
        return neuron;
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> iterable) {
        return this.getNeighbours(iterable, null);
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> object, Iterable<Neuron> object22) {
        Object object3;
        HashSet hashSet = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            object3 = (Neuron)object.next();
            hashSet.addAll(this.linkMap.get(((Neuron)object3).getIdentifier()));
        }
        if (object22 != null) {
            object = object22.iterator();
            while (object.hasNext()) {
                object3 = (Neuron)object.next();
                hashSet.remove(((Neuron)object3).getIdentifier());
            }
        }
        object = new ArrayList();
        for (Object object22 : hashSet) {
            object.add(this.getNeuron((Long)object22));
        }
        return object;
    }

    public Collection<Neuron> getNeighbours(Neuron neuron) {
        return this.getNeighbours(neuron, null);
    }

    public Collection<Neuron> getNeighbours(Neuron object, Iterable<Neuron> arrayList) {
        object = this.linkMap.get(((Neuron)object).getIdentifier());
        if (arrayList != null) {
            for (Neuron object22 : arrayList) {
                object.remove(object22.getIdentifier());
            }
        }
        arrayList = new ArrayList<Neuron>();
        Iterator<Long> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList.add(this.getNeuron((Long)object));
        }
        return arrayList;
    }

    private Long createNextId() {
        return this.nextId.getAndIncrement();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        Neuron[] neuronArray = this.neuronMap.values().toArray(new Neuron[0]);
        long[][] lArrayArray = new long[neuronArray.length][];
        for (int i2 = 0; i2 < neuronArray.length; ++i2) {
            Object object = this.getNeighbours(neuronArray[i2]);
            long[] lArray = new long[object.size()];
            int n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Neuron neuron = (Neuron)object.next();
                lArray[n] = neuron.getIdentifier();
                ++n;
            }
            lArrayArray[i2] = lArray;
        }
        return new Network$SerializationProxy(this.nextId.get(), this.featureSize, neuronArray, lArrayArray);
    }
}

