/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.MapUtils$PairNeuronDouble;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    private MapUtils() {
    }

    public static Neuron findBest(double[] dArray, Iterable<Neuron> object, DistanceMeasure distanceMeasure) {
        Neuron neuron = null;
        double d2 = Double.POSITIVE_INFINITY;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            Neuron neuron2 = (Neuron)object.next();
            double d4 = distanceMeasure.compute(neuron2.getFeatures(), dArray);
            if (!(d3 < d2)) continue;
            d2 = d4;
            neuron = neuron2;
        }
        return neuron;
    }

    public static Pair<Neuron, Neuron> findBestAndSecondBest(double[] dArray, Iterable<Neuron> object, DistanceMeasure distanceMeasure) {
        Neuron[] neuronArray = new Neuron[]{null, null};
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        object = object.iterator();
        while (object.hasNext()) {
            double d2;
            Neuron neuron = (Neuron)object.next();
            double d3 = distanceMeasure.compute(neuron.getFeatures(), dArray);
            if (d2 < dArray2[0]) {
                dArray2[1] = dArray2[0];
                neuronArray[1] = neuronArray[0];
                dArray2[0] = d3;
                neuronArray[0] = neuron;
                continue;
            }
            if (!(d3 < dArray2[1])) continue;
            dArray2[1] = d3;
            neuronArray[1] = neuron;
        }
        return new Pair<Neuron, Neuron>(neuronArray[0], neuronArray[1]);
    }

    public static Neuron[] sort(double[] dArray, Iterable<Neuron> object, DistanceMeasure distanceMeasure) {
        Neuron[] neuronArray;
        ArrayList<MapUtils$PairNeuronDouble> arrayList = new ArrayList<MapUtils$PairNeuronDouble>();
        object = object.iterator();
        while (object.hasNext()) {
            neuronArray = (Neuron[])object.next();
            double d2 = distanceMeasure.compute(neuronArray.getFeatures(), dArray);
            arrayList.add(new MapUtils$PairNeuronDouble((Neuron)neuronArray, d2));
        }
        Collections.sort(arrayList, MapUtils$PairNeuronDouble.COMPARATOR);
        int n = arrayList.size();
        neuronArray = new Neuron[n];
        for (int i2 = 0; i2 < n; ++i2) {
            neuronArray[i2] = ((MapUtils$PairNeuronDouble)arrayList.get(i2)).getNeuron();
        }
        return neuronArray;
    }

    public static double[][] computeU(NeuronSquareMesh2D neuronSquareMesh2D, DistanceMeasure distanceMeasure) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[n][n2];
        Network network = neuronSquareMesh2D.getNetwork();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = neuronSquareMesh2D.getNeuron(i2, i3);
                Object object2 = network.getNeighbours((Neuron)object);
                object = ((Neuron)object).getFeatures();
                double d2 = 0.0;
                int n3 = 0;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Neuron neuron = (Neuron)object2.next();
                    ++n3;
                    d2 += distanceMeasure.compute((double[])object, neuron.getFeatures());
                }
                dArray[i2][i3] = d2 / (double)n3;
            }
        }
        return dArray;
    }

    public static int[][] computeHitHistogram(Iterable<double[]> object, NeuronSquareMesh2D neuronSquareMesh2D, DistanceMeasure distanceMeasure) {
        Object object2;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Serializable serializable = neuronSquareMesh2D.getNetwork();
        object = object.iterator();
        while (object.hasNext()) {
            double[] dArray = (double[])object.next();
            object2 = MapUtils.findBest(dArray, (Iterable<Neuron>)((Object)serializable), distanceMeasure);
            Integer n = (Integer)hashMap.get(object2);
            if (n == null) {
                hashMap.put(object2, 1);
                continue;
            }
            hashMap.put(object2, n + 1);
        }
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        object2 = new int[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                serializable = neuronSquareMesh2D.getNeuron(i2, i3);
                object2[i2][i3] = (serializable = (Integer)hashMap.get(serializable)) == null ? (Object)false : (Object)((Integer)serializable);
            }
        }
        return object2;
    }

    public static double computeQuantizationError(Iterable<double[]> object, Iterable<Neuron> iterable, DistanceMeasure distanceMeasure) {
        double d2 = 0.0;
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            double[] dArray = (double[])object.next();
            ++n;
            d2 += distanceMeasure.compute(dArray, MapUtils.findBest(dArray, iterable, distanceMeasure).getFeatures());
        }
        if (n == 0) {
            throw new NoDataException();
        }
        return d2 / (double)n;
    }

    public static double computeTopographicError(Iterable<double[]> object, Network network, DistanceMeasure distanceMeasure) {
        int n = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (double[])object.next();
            ++n2;
            if (network.getNeighbours((Neuron)((Pair)(object2 = (Object)MapUtils.findBestAndSecondBest((double[])object2, network, distanceMeasure))).getFirst()).contains(((Pair)object2).getSecond())) continue;
            ++n;
        }
        if (n2 == 0) {
            throw new NoDataException();
        }
        return (double)n / (double)n2;
    }
}

