/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.evaluation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.CentroidCluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Cluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.DoublePoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.EuclideanDistance;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusterEvaluator<T extends Clusterable> {
    private final DistanceMeasure measure;

    public ClusterEvaluator() {
        this(new EuclideanDistance());
    }

    public ClusterEvaluator(DistanceMeasure distanceMeasure) {
        this.measure = distanceMeasure;
    }

    public abstract double score(List<? extends Cluster<T>> var1);

    public boolean isBetterScore(double d2, double d3) {
        return d2 < d3;
    }

    protected double distance(Clusterable clusterable, Clusterable clusterable2) {
        return this.measure.compute(clusterable.getPoint(), clusterable2.getPoint());
    }

    protected Clusterable centroidOf(Cluster<T> cluster) {
        List<T> list = cluster.getPoints();
        if (list.isEmpty()) {
            return null;
        }
        if (cluster instanceof CentroidCluster) {
            return ((CentroidCluster)cluster).getCenter();
        }
        int n = ((Clusterable)list.get(0)).getPoint().length;
        double[] dArray = new double[n];
        for (Object object : list) {
            object = object.getPoint();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                int n2 = i2;
                dArray[n2] = dArray[n2] + object[i2];
            }
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / (double)list.size();
        }
        return new DoublePoint(dArray);
    }
}

