/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.CentroidCluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Cluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.evaluation.SumOfClusterVariances;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKMeansPlusPlusClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final KMeansPlusPlusClusterer<T> clusterer;
    private final int numTrials;
    private final ClusterEvaluator<T> evaluator;

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> kMeansPlusPlusClusterer, int n) {
        this(kMeansPlusPlusClusterer, n, new SumOfClusterVariances(kMeansPlusPlusClusterer.getDistanceMeasure()));
    }

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> kMeansPlusPlusClusterer, int n, ClusterEvaluator<T> clusterEvaluator) {
        super(kMeansPlusPlusClusterer.getDistanceMeasure());
        this.clusterer = kMeansPlusPlusClusterer;
        this.numTrials = n;
        this.evaluator = clusterEvaluator;
    }

    public KMeansPlusPlusClusterer<T> getClusterer() {
        return this.clusterer;
    }

    public int getNumTrials() {
        return this.numTrials;
    }

    public ClusterEvaluator<T> getClusterEvaluator() {
        return this.evaluator;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> collection) {
        List<Cluster<T>> list = null;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < this.numTrials; ++i2) {
            List<Cluster<T>> list2 = ((Clusterer)this.clusterer).cluster(collection);
            double d3 = this.evaluator.score(list2);
            if (!this.evaluator.isBetterScore(d3, d2)) continue;
            list = list2;
            d2 = d3;
        }
        return list;
    }
}

