/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.CentroidCluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Cluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.DoublePoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer$EmptyClusterStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.EuclideanDistance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.JDKRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansPlusPlusClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final int k;
    private final int maxIterations;
    private final RandomGenerator random;
    private final KMeansPlusPlusClusterer$EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(int n) {
        this(n, -1);
    }

    public KMeansPlusPlusClusterer(int n, int n2) {
        this(n, n2, new EuclideanDistance());
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure) {
        this(n, n2, distanceMeasure, new JDKRandomGenerator());
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure, RandomGenerator randomGenerator) {
        this(n, n2, distanceMeasure, randomGenerator, KMeansPlusPlusClusterer$EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure, RandomGenerator randomGenerator, KMeansPlusPlusClusterer$EmptyClusterStrategy kMeansPlusPlusClusterer$EmptyClusterStrategy) {
        super(distanceMeasure);
        this.k = n;
        this.maxIterations = n2;
        this.random = randomGenerator;
        this.emptyStrategy = kMeansPlusPlusClusterer$EmptyClusterStrategy;
    }

    public int getK() {
        return this.k;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public RandomGenerator getRandomGenerator() {
        return this.random;
    }

    public KMeansPlusPlusClusterer$EmptyClusterStrategy getEmptyClusterStrategy() {
        return this.emptyStrategy;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> collection) {
        MathUtils.checkNotNull(collection);
        if (collection.size() < this.k) {
            throw new NumberIsTooSmallException(collection.size(), (Number)this.k, false);
        }
        List<CentroidCluster<T>> list = this.chooseInitialCenters(collection);
        int[] nArray = new int[collection.size()];
        this.assignPointsToClusters(list, collection, nArray);
        int n = this.maxIterations < 0 ? Integer.MAX_VALUE : this.maxIterations;
        for (int i2 = 0; i2 < n; ++i2) {
            boolean bl = false;
            ArrayList<CentroidCluster<T>> arrayList = new ArrayList<CentroidCluster<T>>();
            for (CentroidCluster<T> centroidCluster : list) {
                if (centroidCluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            centroidCluster = this.getPointFromLargestVarianceCluster(list);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            centroidCluster = this.getPointFromLargestNumberCluster(list);
                            break;
                        }
                        case FARTHEST_POINT: {
                            centroidCluster = this.getFarthestPoint(list);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
                        }
                    }
                    bl = true;
                } else {
                    centroidCluster = this.centroidOf(centroidCluster.getPoints(), centroidCluster.getCenter().getPoint().length);
                }
                arrayList.add(new CentroidCluster((Clusterable)((Object)centroidCluster)));
            }
            int n2 = this.assignPointsToClusters(arrayList, collection, nArray);
            list = arrayList;
            if (n2 != 0 || bl) continue;
            return list;
        }
        return list;
    }

    private int assignPointsToClusters(List<CentroidCluster<T>> list, Collection<T> object, int[] nArray) {
        int n = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Clusterable clusterable = (Clusterable)object.next();
            int n3 = this.getNearestCluster(list, clusterable);
            if (n3 != nArray[n2]) {
                ++n;
            }
            CentroidCluster<Clusterable> centroidCluster = list.get(n3);
            centroidCluster.addPoint(clusterable);
            nArray[n2++] = n3;
        }
        return n;
    }

    private List<CentroidCluster<T>> chooseInitialCenters(Collection<T> collection) {
        collection = Collections.unmodifiableList(new ArrayList<T>(collection));
        int n = collection.size();
        boolean[] blArray = new boolean[n];
        ArrayList<CentroidCluster<T>> arrayList = new ArrayList<CentroidCluster<T>>();
        int n2 = this.random.nextInt(n);
        Clusterable clusterable = (Clusterable)collection.get(n2);
        arrayList.add(new CentroidCluster(clusterable));
        blArray[n2] = true;
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            double d2;
            if (i2 == n2) continue;
            double d3 = d2 = this.distance(clusterable, (Clusterable)collection.get(i2));
            dArray[i2] = d3 * d3;
        }
        while (arrayList.size() < this.k) {
            int n3;
            double d4 = 0.0;
            for (int i3 = 0; i3 < n; ++i3) {
                if (blArray[i3]) continue;
                d4 += dArray[i3];
            }
            double d5 = this.random.nextDouble() * d4;
            n2 = -1;
            double d6 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                double d7;
                if (blArray[n3]) continue;
                d6 += dArray[n3];
                if (!(d7 >= d5)) continue;
                n2 = n3;
                break;
            }
            if (n2 == -1) {
                for (n3 = n - 1; n3 >= 0; --n3) {
                    if (blArray[n3]) continue;
                    n2 = n3;
                    break;
                }
            }
            if (n2 < 0) break;
            clusterable = (Clusterable)collection.get(n2);
            arrayList.add(new CentroidCluster(clusterable));
            blArray[n2] = true;
            if (arrayList.size() >= this.k) continue;
            for (n2 = 0; n2 < n; ++n2) {
                double d8;
                if (blArray[n2]) continue;
                double d9 = this.distance(clusterable, (Clusterable)collection.get(n2));
                double d10 = d9 * d9;
                if (!(d8 < dArray[n2])) continue;
                dArray[n2] = d10;
            }
        }
        return arrayList;
    }

    private T getPointFromLargestVarianceCluster(Collection<CentroidCluster<T>> list) {
        double d2 = Double.NEGATIVE_INFINITY;
        Cluster cluster = null;
        for (CentroidCluster centroidCluster : list) {
            double d3;
            if (centroidCluster.getPoints().isEmpty()) continue;
            Clusterable clusterable = centroidCluster.getCenter();
            Variance variance = new Variance();
            for (Clusterable clusterable2 : centroidCluster.getPoints()) {
                ((AbstractStorelessUnivariateStatistic)variance).increment(this.distance(clusterable2, clusterable));
            }
            double d4 = ((AbstractStorelessUnivariateStatistic)variance).getResult();
            if (!(d3 > d2)) continue;
            d2 = d4;
            cluster = centroidCluster;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<? extends Cluster<T>> list) {
        int n = 0;
        Cluster cluster = null;
        for (Cluster cluster2 : list) {
            int n2 = cluster2.getPoints().size();
            if (n2 <= n) continue;
            n = n2;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getFarthestPoint(Collection<CentroidCluster<T>> object) {
        double d2 = Double.NEGATIVE_INFINITY;
        Cluster cluster = null;
        int n = -1;
        object = object.iterator();
        while (object.hasNext()) {
            CentroidCluster centroidCluster = (CentroidCluster)object.next();
            Clusterable clusterable = centroidCluster.getCenter();
            List list = centroidCluster.getPoints();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                double d3;
                double d4 = this.distance((Clusterable)list.get(i2), clusterable);
                if (!(d3 > d2)) continue;
                d2 = d4;
                cluster = centroidCluster;
                n = i2;
            }
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        return (T)((Clusterable)cluster.getPoints().remove(n));
    }

    private int getNearestCluster(Collection<CentroidCluster<T>> object, T t) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            CentroidCluster centroidCluster = (CentroidCluster)object.next();
            double d4 = this.distance((Clusterable)t, centroidCluster.getCenter());
            if (d3 < d2) {
                d2 = d4;
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    private Clusterable centroidOf(Collection<T> collection, int n) {
        double[] dArray = new double[n];
        for (Object object : collection) {
            object = object.getPoint();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                int n2 = i2;
                dArray[n2] = dArray[n2] + object[i2];
            }
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / (double)collection.size();
        }
        return new DoublePoint(dArray);
    }
}

