/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.CentroidCluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.DoublePoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.EuclideanDistance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.JDKRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyKMeansClusterer<T extends Clusterable>
extends Clusterer<T> {
    private static final double DEFAULT_EPSILON = 0.001;
    private final int k;
    private final int maxIterations;
    private final double fuzziness;
    private final double epsilon;
    private final RandomGenerator random;
    private double[][] membershipMatrix;
    private List<T> points;
    private List<CentroidCluster<T>> clusters;

    public FuzzyKMeansClusterer(int n, double d2) {
        this(n, d2, -1, new EuclideanDistance());
    }

    public FuzzyKMeansClusterer(int n, double d2, int n2, DistanceMeasure distanceMeasure) {
        this(n, d2, n2, distanceMeasure, 0.001, new JDKRandomGenerator());
    }

    public FuzzyKMeansClusterer(int n, double d2, int n2, DistanceMeasure distanceMeasure, double d3, RandomGenerator randomGenerator) {
        super(distanceMeasure);
        if (d2 <= 1.0) {
            throw new NumberIsTooSmallException(d2, (Number)1.0, false);
        }
        this.k = n;
        this.fuzziness = d2;
        this.maxIterations = n2;
        this.epsilon = d3;
        this.random = randomGenerator;
        this.membershipMatrix = null;
        this.points = null;
        this.clusters = null;
    }

    public int getK() {
        return this.k;
    }

    public double getFuzziness() {
        return this.fuzziness;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public RandomGenerator getRandomGenerator() {
        return this.random;
    }

    public RealMatrix getMembershipMatrix() {
        if (this.membershipMatrix == null) {
            throw new MathIllegalStateException();
        }
        return MatrixUtils.createRealMatrix(this.membershipMatrix);
    }

    public List<T> getDataPoints() {
        return this.points;
    }

    public List<CentroidCluster<T>> getClusters() {
        return this.clusters;
    }

    public double getObjectiveFunctionValue() {
        if (this.points == null || this.clusters == null) {
            throw new MathIllegalStateException();
        }
        int n = 0;
        double d2 = 0.0;
        for (Clusterable clusterable : this.points) {
            int n2 = 0;
            for (CentroidCluster<T> centroidCluster : this.clusters) {
                double d3;
                double d4 = d3 = this.distance(clusterable, centroidCluster.getCenter());
                d2 += d4 * d4 * FastMath.pow(this.membershipMatrix[n][n2], this.fuzziness);
                ++n2;
            }
            ++n;
        }
        return d2;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> object) {
        double d2;
        int n;
        MathUtils.checkNotNull(object);
        int n2 = object.size();
        if (n2 < this.k) {
            throw new NumberIsTooSmallException(n2, (Number)this.k, false);
        }
        this.points = Collections.unmodifiableList(new ArrayList<T>(object));
        this.clusters = new ArrayList<CentroidCluster<T>>();
        this.membershipMatrix = new double[n2][this.k];
        object = new double[n2][this.k];
        if (n2 == 0) {
            return this.clusters;
        }
        this.initializeMembershipMatrix();
        n2 = ((Clusterable)this.points.get(0)).getPoint().length;
        for (n = 0; n < this.k; ++n) {
            this.clusters.add(new CentroidCluster(new DoublePoint(new double[n2])));
        }
        n = 0;
        n2 = this.maxIterations < 0 ? Integer.MAX_VALUE : this.maxIterations;
        do {
            this.saveMembershipMatrix((double[][])object);
            this.updateClusterCenters();
            this.updateMembershipMatrix();
            double d3 = this.calculateMaxMembershipChange((double[][])object);
        } while (d2 > this.epsilon && ++n < n2);
        return this.clusters;
    }

    private void updateClusterCenters() {
        int n = 0;
        ArrayList<CentroidCluster<T>> arrayList = new ArrayList<CentroidCluster<T>>(this.k);
        for (CentroidCluster<T> centroidCluster : this.clusters) {
            Clusterable clusterable = centroidCluster.getCenter();
            int n2 = 0;
            double[] object = new double[clusterable.getPoint().length];
            double d2 = 0.0;
            for (Object object2 : this.points) {
                double d3 = FastMath.pow(this.membershipMatrix[n2][n], this.fuzziness);
                object2 = object2.getPoint();
                for (int i2 = 0; i2 < object.length; ++i2) {
                    int n3 = i2;
                    object[n3] = object[n3] + d3 * object2[i2];
                }
                d2 += d3;
                ++n2;
            }
            MathArrays.scaleInPlace(1.0 / d2, object);
            arrayList.add(new CentroidCluster(new DoublePoint(object)));
            ++n;
        }
        this.clusters.clear();
        this.clusters = arrayList;
    }

    private void updateMembershipMatrix() {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            Clusterable clusterable = (Clusterable)this.points.get(i2);
            double d2 = Double.MIN_VALUE;
            int n = -1;
            for (int i3 = 0; i3 < this.clusters.size(); ++i3) {
                double d3 = 0.0;
                double d4 = FastMath.abs(this.distance(clusterable, this.clusters.get(i3).getCenter()));
                if (d4 != 0.0) {
                    for (CentroidCluster<T> centroidCluster : this.clusters) {
                        double d5 = FastMath.abs(this.distance(clusterable, centroidCluster.getCenter()));
                        if (d5 == 0.0) {
                            d3 = Double.POSITIVE_INFINITY;
                            break;
                        }
                        d3 += FastMath.pow(d4 / d5, 2.0 / (this.fuzziness - 1.0));
                    }
                }
                double d6 = d3 == 0.0 ? 1.0 : (d3 == Double.POSITIVE_INFINITY ? 0.0 : 1.0 / d3);
                this.membershipMatrix[i2][i3] = d6;
                if (!(this.membershipMatrix[i2][i3] > d2)) continue;
                d2 = this.membershipMatrix[i2][i3];
                n = i3;
            }
            this.clusters.get(n).addPoint(clusterable);
        }
    }

    private void initializeMembershipMatrix() {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            for (int i3 = 0; i3 < this.k; ++i3) {
                this.membershipMatrix[i2][i3] = this.random.nextDouble();
            }
            this.membershipMatrix[i2] = MathArrays.normalizeArray(this.membershipMatrix[i2], 1.0);
        }
    }

    private double calculateMaxMembershipChange(double[][] dArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            for (int i3 = 0; i3 < this.clusters.size(); ++i3) {
                double d3 = FastMath.abs(this.membershipMatrix[i2][i3] - dArray[i2][i3]);
                d2 = FastMath.max(d3, d2);
            }
        }
        return d2;
    }

    private void saveMembershipMatrix(double[][] dArray) {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            System.arraycopy(this.membershipMatrix[i2], 0, dArray[i2], 0, this.clusters.size());
        }
    }
}

