/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Cluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.Clusterer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.clustering.DBSCANClusterer$PointStatus;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.EuclideanDistance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSCANClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final double eps;
    private final int minPts;

    public DBSCANClusterer(double d2, int n) {
        this(d2, n, new EuclideanDistance());
    }

    public DBSCANClusterer(double d2, int n, DistanceMeasure distanceMeasure) {
        super(distanceMeasure);
        if (d2 < 0.0) {
            throw new NotPositiveException(d2);
        }
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        this.eps = d2;
        this.minPts = n;
    }

    public double getEps() {
        return this.eps;
    }

    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public List<Cluster<T>> cluster(Collection<T> collection) {
        MathUtils.checkNotNull(collection);
        ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
        HashMap<Clusterable, DBSCANClusterer$PointStatus> hashMap = new HashMap<Clusterable, DBSCANClusterer$PointStatus>();
        for (Clusterable clusterable : collection) {
            if (hashMap.get(clusterable) != null) continue;
            List<Clusterable> list = this.getNeighbors(clusterable, collection);
            if (list.size() >= this.minPts) {
                Cluster cluster = new Cluster();
                arrayList.add(this.expandCluster(cluster, clusterable, list, collection, hashMap));
                continue;
            }
            hashMap.put(clusterable, DBSCANClusterer$PointStatus.NOISE);
        }
        return arrayList;
    }

    private Cluster<T> expandCluster(Cluster<T> cluster, T object, List<T> list, Collection<T> collection, Map<Clusterable, DBSCANClusterer$PointStatus> map) {
        cluster.addPoint((Clusterable)object);
        map.put((Clusterable)object, DBSCANClusterer$PointStatus.PART_OF_CLUSTER);
        object = new ArrayList<T>(list);
        for (int i2 = 0; i2 < object.size(); ++i2) {
            List<Clusterable> list2;
            Clusterable clusterable = (Clusterable)object.get(i2);
            DBSCANClusterer$PointStatus dBSCANClusterer$PointStatus = map.get(clusterable);
            if (dBSCANClusterer$PointStatus == null && (list2 = this.getNeighbors(clusterable, collection)).size() >= this.minPts) {
                object = this.merge((List<T>)object, (List<T>)list2);
            }
            if (dBSCANClusterer$PointStatus == DBSCANClusterer$PointStatus.PART_OF_CLUSTER) continue;
            map.put(clusterable, DBSCANClusterer$PointStatus.PART_OF_CLUSTER);
            cluster.addPoint(clusterable);
        }
        return cluster;
    }

    private List<T> getNeighbors(T t, Collection<T> object) {
        ArrayList<Clusterable> arrayList = new ArrayList<Clusterable>();
        object = object.iterator();
        while (object.hasNext()) {
            Clusterable clusterable = (Clusterable)object.next();
            if (t == clusterable || !(this.distance(clusterable, (Clusterable)t) <= this.eps)) continue;
            arrayList.add(clusterable);
        }
        return arrayList;
    }

    private List<T> merge(List<T> list, List<T> object) {
        HashSet<T> hashSet = new HashSet<T>(list);
        object = object.iterator();
        while (object.hasNext()) {
            Clusterable clusterable = (Clusterable)object.next();
            if (hashSet.contains(clusterable)) continue;
            list.add(clusterable);
        }
        return list;
    }
}

