/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

class TriDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedQ;
    private RealMatrix cachedQt;
    private RealMatrix cachedT;

    TriDiagonalTransformer(RealMatrix realMatrix) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        this.householderVectors = realMatrix.getData();
        this.main = new double[n];
        this.secondary = new double[n - 1];
        this.cachedQ = null;
        this.cachedQt = null;
        this.cachedT = null;
        this.transform();
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQt == null) {
            int n = this.householderVectors.length;
            double[][] dArray = new double[n][n];
            for (int i2 = n - 1; i2 > 0; --i2) {
                int n2;
                double[] dArray2 = this.householderVectors[i2 - 1];
                dArray[i2][i2] = 1.0;
                if (dArray2[i2] == 0.0) continue;
                double d2 = 1.0 / (this.secondary[i2 - 1] * dArray2[i2]);
                double d3 = 1.0 / this.secondary[i2 - 1];
                dArray[i2][i2] = 1.0 + d3 * dArray2[i2];
                for (n2 = i2 + 1; n2 < n; ++n2) {
                    dArray[i2][n2] = d3 * dArray2[n2];
                }
                for (n2 = i2 + 1; n2 < n; ++n2) {
                    int n3;
                    d3 = 0.0;
                    for (n3 = i2 + 1; n3 < n; ++n3) {
                        d3 += dArray[n2][n3] * dArray2[n3];
                    }
                    dArray[n2][i2] = (d3 *= d2) * dArray2[i2];
                    for (n3 = i2 + 1; n3 < n; ++n3) {
                        double[] dArray3 = dArray[n2];
                        int n4 = n3;
                        dArray3[n4] = dArray3[n4] + d3 * dArray2[n3];
                    }
                }
            }
            dArray[0][0] = 1.0;
            this.cachedQt = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedQt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            int n = this.main.length;
            double[][] dArray = new double[n][n];
            for (int i2 = 0; i2 < n; ++i2) {
                dArray[i2][i2] = this.main[i2];
                if (i2 > 0) {
                    dArray[i2][i2 - 1] = this.secondary[i2 - 1];
                }
                if (i2 >= this.main.length - 1) continue;
                dArray[i2][i2 + 1] = this.secondary[i2];
            }
            this.cachedT = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedT;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    private void transform() {
        int n = this.householderVectors.length;
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            int n2;
            double d2;
            double[] dArray2 = this.householderVectors[i2];
            this.main[i2] = dArray2[i2];
            double d3 = 0.0;
            for (int i3 = i2 + 1; i3 < n; ++i3) {
                double d4;
                double d5 = d4 = dArray2[i3];
                d3 += d5 * d5;
            }
            this.secondary[i2] = d2 = dArray2[i2 + 1] > 0.0 ? -FastMath.sqrt(d3) : FastMath.sqrt(d3);
            if (d2 == 0.0) continue;
            int n3 = i2 + 1;
            dArray2[n3] = dArray2[n3] - d2;
            double d6 = -1.0 / (d2 * dArray2[i2 + 1]);
            Arrays.fill(dArray, i2 + 1, n, 0.0);
            for (int i4 = i2 + 1; i4 < n; ++i4) {
                double[] dArray3 = this.householderVectors[i4];
                double d7 = dArray2[i4];
                double d8 = dArray3[i4] * d7;
                int n4 = i4 + 1;
                while (n4 < n) {
                    double d9 = dArray3[n4];
                    d8 += d9 * dArray2[n4];
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d9 * d7;
                }
                dArray[i4] = d6 * (dArray[i4] + d8);
            }
            double d10 = 0.0;
            for (n2 = i2 + 1; n2 < n; ++n2) {
                d10 += dArray[n2] * dArray2[n2];
            }
            d10 *= d6 / 2.0;
            for (n2 = i2 + 1; n2 < n; ++n2) {
                int n6 = n2;
                dArray[n6] = dArray[n6] - d10 * dArray2[n2];
            }
            for (n2 = i2 + 1; n2 < n; ++n2) {
                double[] dArray4 = this.householderVectors[n2];
                for (int i5 = n2; i5 < n; ++i5) {
                    int n7 = i5;
                    dArray4[n7] = dArray4[n7] - (dArray2[n2] * dArray[i5] + dArray[n2] * dArray2[i5]);
                }
            }
        }
        this.main[n - 1] = this.householderVectors[n - 1][n - 1];
    }
}

