/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DefaultIterativeLinearSolverEvent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SymmLQ$State;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationEvent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationManager;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class SymmLQ
extends PreconditionedIterativeLinearSolver {
    private static final String OPERATOR = "operator";
    private static final String THRESHOLD = "threshold";
    private static final String VECTOR = "vector";
    private static final String VECTOR1 = "vector1";
    private static final String VECTOR2 = "vector2";
    private final boolean check;
    private final double delta;

    public SymmLQ(int n, double d2, boolean bl) {
        super(n);
        this.delta = d2;
        this.check = bl;
    }

    public SymmLQ(IterationManager iterationManager, double d2, boolean bl) {
        super(iterationManager);
        this.delta = d2;
        this.check = bl;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector, false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, boolean bl, double d2) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector, bl, d2);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2.copy(), false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        ((RealVector)arrayRealVector).set(0.0);
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector, false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, boolean bl, double d2) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector, bl, d2);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2.copy(), false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2, false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator object, RealLinearOperator object2, RealVector realVector, RealVector realVector2, boolean bl, double d2) {
        SymmLQ.checkParameters((RealLinearOperator)object, (RealLinearOperator)object2, realVector, realVector2);
        IterationManager iterationManager = this.getIterationManager();
        iterationManager.resetIterationCount();
        iterationManager.incrementIterationCount();
        object = new SymmLQ$State((RealLinearOperator)object, (RealLinearOperator)object2, realVector, bl, d2, this.delta, this.check);
        ((SymmLQ$State)object).init();
        ((SymmLQ$State)object).refineSolution(realVector2);
        object2 = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, ((SymmLQ$State)object).getNormOfResidual());
        if (((SymmLQ$State)object).bEqualsNullVector()) {
            iterationManager.fireTerminationEvent((IterationEvent)object2);
            return realVector2;
        }
        bl = ((SymmLQ$State)object).betaEqualsZero() || ((SymmLQ$State)object).hasConverged();
        iterationManager.fireInitializationEvent((IterationEvent)object2);
        if (!bl) {
            do {
                iterationManager.incrementIterationCount();
                object2 = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, ((SymmLQ$State)object).getNormOfResidual());
                iterationManager.fireIterationStartedEvent((IterationEvent)object2);
                ((SymmLQ$State)object).update();
                ((SymmLQ$State)object).refineSolution(realVector2);
                object2 = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, ((SymmLQ$State)object).getNormOfResidual());
                iterationManager.fireIterationPerformedEvent((IterationEvent)object2);
            } while (!((SymmLQ$State)object).hasConverged());
        }
        object2 = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, ((SymmLQ$State)object).getNormOfResidual());
        iterationManager.fireTerminationEvent((IterationEvent)object2);
        return realVector2;
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2, false, 0.0);
    }
}

