/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.ExceptionContext;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.IllConditionedOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSelfAdjointOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

class SymmLQ$State {
    static final double CBRT_MACH_PREC;
    static final double MACH_PREC;
    private final RealLinearOperator a;
    private final RealVector b;
    private final boolean check;
    private final double delta;
    private double beta;
    private double beta1;
    private double bstep;
    private double cgnorm;
    private double dbar;
    private double gammaZeta;
    private double gbar;
    private double gmax;
    private double gmin;
    private final boolean goodb;
    private boolean hasConverged;
    private double lqnorm;
    private final RealLinearOperator m;
    private double minusEpsZeta;
    private final RealVector mb;
    private double oldb;
    private RealVector r1;
    private RealVector r2;
    private double rnorm;
    private final double shift;
    private double snprod;
    private double tnorm;
    private RealVector wbar;
    private final RealVector xL;
    private RealVector y;
    private double ynorm2;
    private boolean bIsNull;

    SymmLQ$State(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, boolean bl, double d2, double d3, boolean bl2) {
        this.a = realLinearOperator;
        this.m = realLinearOperator2;
        this.b = realVector;
        this.xL = new ArrayRealVector(realVector.getDimension());
        this.goodb = bl;
        this.shift = d2;
        this.mb = realLinearOperator2 == null ? realVector : realLinearOperator2.operate(realVector);
        this.hasConverged = false;
        this.check = bl2;
        this.delta = d3;
    }

    private static void checkSymmetry(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2, RealVector object) {
        RealVector realVector3 = realVector2;
        double d2 = realVector3.dotProduct(realVector3);
        double d3 = realVector.dotProduct((RealVector)object);
        double d4 = (d2 + MACH_PREC) * CBRT_MACH_PREC;
        if (FastMath.abs(d2 - d3) > d4) {
            object = new NonSelfAdjointOperatorException();
            ExceptionContext exceptionContext = ((MathIllegalArgumentException)object).getContext();
            exceptionContext.setValue("operator", realLinearOperator);
            exceptionContext.setValue("vector1", realVector);
            exceptionContext.setValue("vector2", realVector2);
            exceptionContext.setValue("threshold", d4);
            throw object;
        }
    }

    private static void throwNPDLOException(RealLinearOperator realLinearOperator, RealVector realVector) {
        NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
        ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
        exceptionContext.setValue("operator", realLinearOperator);
        exceptionContext.setValue("vector", realVector);
        throw nonPositiveDefiniteOperatorException;
    }

    private static void daxpy(double d2, RealVector realVector, RealVector realVector2) {
        int n = realVector.getDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            realVector2.setEntry(i2, d2 * realVector.getEntry(i2) + realVector2.getEntry(i2));
        }
    }

    private static void daxpbypz(double d2, RealVector realVector, double d3, RealVector realVector2, RealVector realVector3) {
        int n = realVector3.getDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            double d4 = d2 * realVector.getEntry(i2) + d3 * realVector2.getEntry(i2) + realVector3.getEntry(i2);
            realVector3.setEntry(i2, d4);
        }
    }

    void refineSolution(RealVector realVector) {
        int n = this.xL.getDimension();
        if (this.lqnorm < this.cgnorm) {
            if (!this.goodb) {
                realVector.setSubVector(0, this.xL);
                return;
            }
            double d2 = this.bstep / this.beta1;
            for (int i2 = 0; i2 < n; ++i2) {
                double d3 = this.mb.getEntry(i2);
                double d4 = this.xL.getEntry(i2);
                realVector.setEntry(i2, d4 + d2 * d3);
            }
            return;
        }
        double d5 = FastMath.sqrt(this.tnorm);
        double d6 = this.gbar == 0.0 ? d5 * MACH_PREC : this.gbar;
        double d7 = this.gammaZeta / d6;
        double d8 = (this.bstep + this.snprod * d7) / this.beta1;
        if (!this.goodb) {
            for (int i3 = 0; i3 < n; ++i3) {
                double d9 = this.xL.getEntry(i3);
                double d10 = this.wbar.getEntry(i3);
                realVector.setEntry(i3, d9 + d7 * d10);
            }
            return;
        }
        for (int i4 = 0; i4 < n; ++i4) {
            double d11 = this.xL.getEntry(i4);
            double d12 = this.wbar.getEntry(i4);
            double d13 = this.mb.getEntry(i4);
            realVector.setEntry(i4, d11 + d7 * d12 + d8 * d13);
        }
    }

    void init() {
        this.xL.set(0.0);
        this.r1 = this.b.copy();
        RealVector realVector = this.y = this.m == null ? this.b.copy() : this.m.operate(this.r1);
        if (this.m != null && this.check) {
            SymmLQ$State.checkSymmetry(this.m, this.r1, this.y, this.m.operate(this.y));
        }
        this.beta1 = this.r1.dotProduct(this.y);
        if (this.beta1 < 0.0) {
            SymmLQ$State.throwNPDLOException(this.m, this.y);
        }
        if (this.beta1 == 0.0) {
            this.bIsNull = true;
            return;
        }
        this.bIsNull = false;
        this.beta1 = FastMath.sqrt(this.beta1);
        RealVector realVector2 = this.y.mapMultiply(1.0 / this.beta1);
        this.y = this.a.operate(realVector2);
        if (this.check) {
            SymmLQ$State.checkSymmetry(this.a, realVector2, this.y, this.a.operate(this.y));
        }
        SymmLQ$State.daxpy(-this.shift, realVector2, this.y);
        double d2 = realVector2.dotProduct(this.y);
        SymmLQ$State.daxpy(-d2 / this.beta1, this.r1, this.y);
        double d3 = realVector2.dotProduct(this.y);
        RealVector realVector3 = realVector2;
        double d4 = realVector3.dotProduct(realVector3);
        SymmLQ$State.daxpy(-d3 / d4, realVector2, this.y);
        this.r2 = this.y.copy();
        if (this.m != null) {
            this.y = this.m.operate(this.r2);
        }
        this.oldb = this.beta1;
        this.beta = this.r2.dotProduct(this.y);
        if (this.beta < 0.0) {
            SymmLQ$State.throwNPDLOException(this.m, this.y);
        }
        this.beta = FastMath.sqrt(this.beta);
        this.cgnorm = this.beta1;
        this.gbar = d2;
        this.dbar = this.beta;
        this.gammaZeta = this.beta1;
        this.minusEpsZeta = 0.0;
        this.bstep = 0.0;
        this.snprod = 1.0;
        double d5 = d2;
        this.tnorm = d5 * d5 + this.beta * this.beta;
        this.ynorm2 = 0.0;
        this.gmin = this.gmax = FastMath.abs(d2) + MACH_PREC;
        if (this.goodb) {
            this.wbar = new ArrayRealVector(this.a.getRowDimension());
            this.wbar.set(0.0);
        } else {
            this.wbar = realVector2;
        }
        this.updateNorms();
    }

    void update() {
        RealVector realVector = this.y.mapMultiply(1.0 / this.beta);
        this.y = this.a.operate(realVector);
        SymmLQ$State.daxpbypz(-this.shift, realVector, -this.beta / this.oldb, this.r1, this.y);
        double d2 = realVector.dotProduct(this.y);
        SymmLQ$State.daxpy(-d2 / this.beta, this.r2, this.y);
        this.r1 = this.r2;
        this.r2 = this.y;
        if (this.m != null) {
            this.y = this.m.operate(this.r2);
        }
        this.oldb = this.beta;
        this.beta = this.r2.dotProduct(this.y);
        if (this.beta < 0.0) {
            SymmLQ$State.throwNPDLOException(this.m, this.y);
        }
        this.beta = FastMath.sqrt(this.beta);
        double d3 = d2;
        this.tnorm += d3 * d3 + this.oldb * this.oldb + this.beta * this.beta;
        double d4 = FastMath.sqrt(this.gbar * this.gbar + this.oldb * this.oldb);
        double d5 = this.gbar / d4;
        double d6 = this.oldb / d4;
        double d7 = d5 * this.dbar + d6 * d2;
        this.gbar = d6 * this.dbar - d5 * d2;
        double d8 = d6 * this.beta;
        this.dbar = -d5 * this.beta;
        double d9 = this.gammaZeta / d4;
        double d10 = d9 * d5;
        double d11 = d9 * d6;
        int n = this.xL.getDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            double d12 = this.xL.getEntry(i2);
            double d13 = realVector.getEntry(i2);
            double d14 = this.wbar.getEntry(i2);
            this.xL.setEntry(i2, d12 + d14 * d10 + d13 * d11);
            this.wbar.setEntry(i2, d14 * d6 - d13 * d5);
        }
        this.bstep += this.snprod * d5 * d9;
        this.snprod *= d6;
        this.gmax = FastMath.max(this.gmax, d4);
        this.gmin = FastMath.min(this.gmin, d4);
        double d15 = d9;
        this.ynorm2 += d15 * d15;
        this.gammaZeta = this.minusEpsZeta - d7 * d9;
        this.minusEpsZeta = -d8 * d9;
        this.updateNorms();
    }

    private void updateNorms() {
        double d2 = FastMath.sqrt(this.tnorm);
        double d3 = FastMath.sqrt(this.ynorm2);
        double d4 = d2 * MACH_PREC;
        double d5 = d2 * d3 * MACH_PREC;
        double d6 = d2 * d3 * this.delta;
        double d7 = this.gbar == 0.0 ? d4 : this.gbar;
        this.lqnorm = FastMath.sqrt(this.gammaZeta * this.gammaZeta + this.minusEpsZeta * this.minusEpsZeta);
        double d8 = this.snprod * this.beta1;
        this.cgnorm = d8 * this.beta / FastMath.abs(d7);
        double d9 = this.lqnorm <= this.cgnorm ? this.gmax / this.gmin : this.gmax / FastMath.min(this.gmin, FastMath.abs(d7));
        if (d9 * MACH_PREC >= 0.1) {
            throw new IllConditionedOperatorException(d9);
        }
        if (this.beta1 <= d5) {
            throw new SingularOperatorException();
        }
        this.rnorm = FastMath.min(this.cgnorm, this.lqnorm);
        this.hasConverged = this.cgnorm <= d5 || this.cgnorm <= d6;
    }

    boolean hasConverged() {
        return this.hasConverged;
    }

    boolean bEqualsNullVector() {
        return this.bIsNull;
    }

    boolean betaEqualsZero() {
        return this.beta < MACH_PREC;
    }

    double getNormOfResidual() {
        return this.rnorm;
    }

    static {
        MACH_PREC = FastMath.ulp(1.0);
        CBRT_MACH_PREC = FastMath.cbrt(MACH_PREC);
    }
}

