/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVectorChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVectorPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SparseFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToFieldHashMap;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToFieldHashMap$Iterator;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7841233292190413362L;
    private final Field<T> field;
    private final OpenIntToFieldHashMap<T> entries;
    private final int virtualSize;

    public SparseFieldVector(Field<T> field) {
        this(field, 0);
    }

    public SparseFieldVector(Field<T> field, int n) {
        this.field = field;
        this.virtualSize = n;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    protected SparseFieldVector(SparseFieldVector<T> sparseFieldVector, int n) {
        this.field = sparseFieldVector.field;
        this.virtualSize = sparseFieldVector.getDimension() + n;
        this.entries = new OpenIntToFieldHashMap<T>(sparseFieldVector.entries);
    }

    public SparseFieldVector(Field<T> field, int n, int n2) {
        this.field = field;
        this.virtualSize = n;
        this.entries = new OpenIntToFieldHashMap<T>(field, n2);
    }

    public SparseFieldVector(Field<T> field, T[] TArray) {
        MathUtils.checkNotNull(TArray);
        this.field = field;
        this.virtualSize = TArray.length;
        this.entries = new OpenIntToFieldHashMap<T>(field);
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            T t = TArray[i2];
            this.entries.put(i2, t);
        }
    }

    public SparseFieldVector(SparseFieldVector<T> sparseFieldVector) {
        this.field = sparseFieldVector.field;
        this.virtualSize = sparseFieldVector.getDimension();
        this.entries = new OpenIntToFieldHashMap<T>(super.getEntries());
    }

    private OpenIntToFieldHashMap<T> getEntries() {
        return this.entries;
    }

    @Override
    public FieldVector<T> add(SparseFieldVector<T> object) {
        this.checkVectorDimensions(((SparseFieldVector)object).getDimension());
        SparseFieldVector sparseFieldVector = (SparseFieldVector)this.copy();
        object = super.getEntries().iterator();
        while (((OpenIntToFieldHashMap$Iterator)object).hasNext()) {
            ((OpenIntToFieldHashMap$Iterator)object).advance();
            int n = ((OpenIntToFieldHashMap$Iterator)object).key();
            Object t = ((OpenIntToFieldHashMap$Iterator)object).value();
            if (this.entries.containsKey(n)) {
                sparseFieldVector.setEntry(n, (FieldElement)this.entries.get(n).add(t));
                continue;
            }
            sparseFieldVector.setEntry(n, t);
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> append(SparseFieldVector<T> object) {
        SparseFieldVector sparseFieldVector = new SparseFieldVector(this, ((SparseFieldVector)object).getDimension());
        object = ((SparseFieldVector)object).entries.iterator();
        while (((OpenIntToFieldHashMap$Iterator)object).hasNext()) {
            ((OpenIntToFieldHashMap$Iterator)object).advance();
            sparseFieldVector.setEntry(((OpenIntToFieldHashMap$Iterator)object).key() + this.virtualSize, ((OpenIntToFieldHashMap$Iterator)object).value());
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.append((T)((SparseFieldVector)fieldVector));
        }
        int n = fieldVector.getDimension();
        SparseFieldVector<T> sparseFieldVector = new SparseFieldVector<T>(this, n);
        for (int i2 = 0; i2 < n; ++i2) {
            sparseFieldVector.setEntry(i2 + this.virtualSize, fieldVector.getEntry(i2));
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> append(T t) {
        MathUtils.checkNotNull(t);
        SparseFieldVector<T> sparseFieldVector = new SparseFieldVector<T>(this, 1);
        sparseFieldVector.setEntry(this.virtualSize, t);
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> copy() {
        return new SparseFieldVector<T>(this);
    }

    @Override
    public T dotProduct(FieldVector<T> fieldVector) {
        this.checkVectorDimensions(fieldVector.getDimension());
        FieldElement fieldElement = (FieldElement)this.field.getZero();
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            fieldElement = (FieldElement)fieldElement.add(fieldVector.getEntry(openIntToFieldHashMap$Iterator.key()).multiply(openIntToFieldHashMap$Iterator.value()));
        }
        return (T)fieldElement;
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> fieldVector) {
        this.checkVectorDimensions(fieldVector.getDimension());
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = sparseFieldVector.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            sparseFieldVector.setEntry(openIntToFieldHashMap$Iterator.key(), (FieldElement)openIntToFieldHashMap$Iterator.value().divide(fieldVector.getEntry(openIntToFieldHashMap$Iterator.key())));
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> fieldVector) {
        this.checkVectorDimensions(fieldVector.getDimension());
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = sparseFieldVector.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            sparseFieldVector.setEntry(openIntToFieldHashMap$Iterator.key(), (FieldElement)openIntToFieldHashMap$Iterator.value().multiply(fieldVector.getEntry(openIntToFieldHashMap$Iterator.key())));
        }
        return sparseFieldVector;
    }

    @Override
    @Deprecated
    public T[] getData() {
        return this.toArray();
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    @Override
    public T getEntry(int n) {
        this.checkIndex(n);
        return this.entries.get(n);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> getSubVector(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(n);
        this.checkIndex(n + n2 - 1);
        SparseFieldVector sparseFieldVector = new SparseFieldVector(this.field, n2);
        n2 = n + n2;
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            int n3 = openIntToFieldHashMap$Iterator.key();
            if (n3 < n || n3 >= n2) continue;
            sparseFieldVector.setEntry(n3 - n, openIntToFieldHashMap$Iterator.value());
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> mapAdd(T t) {
        return this.copy().mapAddToSelf(t);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T t) {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, (FieldElement)this.getEntry(i2).add(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T t) {
        return this.copy().mapDivideToSelf(t);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T t) {
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            this.entries.put(openIntToFieldHashMap$Iterator.key(), (FieldElement)openIntToFieldHashMap$Iterator.value().divide(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() {
        return this.copy().mapInvToSelf();
    }

    @Override
    public FieldVector<T> mapInvToSelf() {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, (FieldElement)((FieldElement)this.field.getOne()).divide(this.getEntry(i2)));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T t) {
        return this.copy().mapMultiplyToSelf(t);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T t) {
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            this.entries.put(openIntToFieldHashMap$Iterator.key(), (FieldElement)openIntToFieldHashMap$Iterator.value().multiply(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T t) {
        return this.copy().mapSubtractToSelf(t);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T t) {
        SparseFieldVector sparseFieldVector = this;
        return sparseFieldVector.mapAddToSelf((FieldElement)((FieldElement)sparseFieldVector.field.getZero()).subtract(t));
    }

    @Override
    public FieldMatrix<T> outerProduct(SparseFieldVector<T> sparseFieldVector) {
        int n = sparseFieldVector.getDimension();
        SparseFieldMatrix<FieldElement> sparseFieldMatrix = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n);
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator2 = sparseFieldVector.entries.iterator();
            while (openIntToFieldHashMap$Iterator2.hasNext()) {
                openIntToFieldHashMap$Iterator2.advance();
                ((AbstractFieldMatrix)sparseFieldMatrix).setEntry(openIntToFieldHashMap$Iterator.key(), openIntToFieldHashMap$Iterator2.key(), (FieldElement)openIntToFieldHashMap$Iterator.value().multiply(openIntToFieldHashMap$Iterator2.value()));
            }
        }
        return sparseFieldMatrix;
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.outerProduct((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        SparseFieldMatrix<FieldElement> sparseFieldMatrix = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n);
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            int n2 = openIntToFieldHashMap$Iterator.key();
            T t = openIntToFieldHashMap$Iterator.value();
            for (int i2 = 0; i2 < n; ++i2) {
                sparseFieldMatrix.setEntry(n2, i2, (FieldElement)t.multiply(fieldVector.getEntry(i2)));
            }
        }
        return sparseFieldMatrix;
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> fieldVector) {
        this.checkVectorDimensions(fieldVector.getDimension());
        FieldVector<FieldElement> fieldVector2 = fieldVector;
        return fieldVector.mapMultiply((FieldElement)this.dotProduct(fieldVector).divide(fieldVector2.dotProduct(fieldVector2)));
    }

    @Override
    public void set(T t) {
        MathUtils.checkNotNull(t);
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, t);
        }
    }

    @Override
    public void setEntry(int n, T t) {
        MathUtils.checkNotNull(t);
        this.checkIndex(n);
        this.entries.put(n, t);
    }

    @Override
    public void setSubVector(int n, FieldVector<T> fieldVector) {
        this.checkIndex(n);
        this.checkIndex(n + fieldVector.getDimension() - 1);
        int n2 = fieldVector.getDimension();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2 + n, fieldVector.getEntry(i2));
        }
    }

    @Override
    public SparseFieldVector<T> subtract(SparseFieldVector<T> object) {
        this.checkVectorDimensions(((SparseFieldVector)object).getDimension());
        SparseFieldVector sparseFieldVector = (SparseFieldVector)this.copy();
        object = super.getEntries().iterator();
        while (((OpenIntToFieldHashMap$Iterator)object).hasNext()) {
            ((OpenIntToFieldHashMap$Iterator)object).advance();
            int n = ((OpenIntToFieldHashMap$Iterator)object).key();
            if (this.entries.containsKey(n)) {
                sparseFieldVector.setEntry(n, (FieldElement)this.entries.get(n).subtract(((OpenIntToFieldHashMap$Iterator)object).value()));
                continue;
            }
            sparseFieldVector.setEntry(n, (FieldElement)((FieldElement)this.field.getZero()).subtract(((OpenIntToFieldHashMap$Iterator)object).value()));
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.subtract((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        this.checkVectorDimensions(n);
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.entries.containsKey(i2)) {
                sparseFieldVector.setEntry(i2, (FieldElement)this.entries.get(i2).subtract(fieldVector.getEntry(i2)));
                continue;
            }
            sparseFieldVector.setEntry(i2, (FieldElement)((FieldElement)this.field.getZero()).subtract(fieldVector.getEntry(i2)));
        }
        return sparseFieldVector;
    }

    @Override
    public T[] toArray() {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.virtualSize);
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            fieldElementArray[openIntToFieldHashMap$Iterator.key()] = openIntToFieldHashMap$Iterator.value();
        }
        return fieldElementArray;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getDimension()) {
            throw new OutOfRangeException(n, (Number)0, this.getDimension() - 1);
        }
    }

    private void checkIndices(int n, int n2) {
        int n3 = this.getDimension();
        if (n < 0 || n >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, n3 - 1);
        }
        if (n2 < 0 || n2 >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n2, 0, n3 - 1);
        }
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
    }

    protected void checkVectorDimensions(int n) {
        if (this.getDimension() != n) {
            throw new DimensionMismatchException(this.getDimension(), n);
        }
    }

    @Override
    public FieldVector<T> add(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.add((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        this.checkVectorDimensions(n);
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this.field, this.getDimension());
        for (int i2 = 0; i2 < n; ++i2) {
            sparseFieldVector.setEntry(i2, (FieldElement)fieldVector.getEntry(i2).add(this.getEntry(i2)));
        }
        return sparseFieldVector;
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        int n = this.getDimension();
        fieldVectorPreservingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            fieldVectorPreservingVisitor.visit(i2, this.getEntry(i2));
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        fieldVectorPreservingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            fieldVectorPreservingVisitor.visit(n, this.getEntry(n));
            ++n;
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor, n, n2);
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        int n = this.getDimension();
        fieldVectorChangingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            this.setEntry(i2, fieldVectorChangingVisitor.visit(i2, this.getEntry(i2)));
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        fieldVectorChangingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            this.setEntry(n, fieldVectorChangingVisitor.visit(n, this.getEntry(n)));
            ++n;
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor, n, n2);
    }

    public int hashCode() {
        int n = 31 + (this.field == null ? 0 : this.field.hashCode());
        n = n * 31 + this.virtualSize;
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            int n2 = openIntToFieldHashMap$Iterator.value().hashCode();
            n = n * 31 + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        T t;
        if (this == object) {
            return true;
        }
        if (!(object instanceof SparseFieldVector)) {
            return false;
        }
        object = (SparseFieldVector)object;
        if (this.field == null ? ((SparseFieldVector)object).field != null : !this.field.equals(((SparseFieldVector)object).field)) {
            return false;
        }
        if (this.virtualSize != ((SparseFieldVector)object).virtualSize) {
            return false;
        }
        OpenIntToFieldHashMap$Iterator openIntToFieldHashMap$Iterator = this.entries.iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            t = ((SparseFieldVector)object).getEntry(openIntToFieldHashMap$Iterator.key());
            if (t.equals(openIntToFieldHashMap$Iterator.value())) continue;
            return false;
        }
        openIntToFieldHashMap$Iterator = super.getEntries().iterator();
        while (openIntToFieldHashMap$Iterator.hasNext()) {
            openIntToFieldHashMap$Iterator.advance();
            t = openIntToFieldHashMap$Iterator.value();
            if (t.equals(this.getEntry(openIntToFieldHashMap$Iterator.key()))) continue;
            return false;
        }
        return true;
    }
}

