/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToFieldHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T> {
    private final OpenIntToFieldHashMap<T> entries;
    private final int rows;
    private final int columns;

    public SparseFieldMatrix(Field<T> field) {
        super(field);
        this.rows = 0;
        this.columns = 0;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    public SparseFieldMatrix(Field<T> field, int n, int n2) {
        super(field, n, n2);
        this.rows = n;
        this.columns = n2;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    public SparseFieldMatrix(SparseFieldMatrix<T> sparseFieldMatrix) {
        super(sparseFieldMatrix.getField(), ((AbstractFieldMatrix)sparseFieldMatrix).getRowDimension(), ((AbstractFieldMatrix)sparseFieldMatrix).getColumnDimension());
        this.rows = ((AbstractFieldMatrix)sparseFieldMatrix).getRowDimension();
        this.columns = ((AbstractFieldMatrix)sparseFieldMatrix).getColumnDimension();
        this.entries = new OpenIntToFieldHashMap<T>(sparseFieldMatrix.entries);
    }

    public SparseFieldMatrix(FieldMatrix<T> fieldMatrix) {
        super(fieldMatrix.getField(), fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension());
        this.rows = fieldMatrix.getRowDimension();
        this.columns = fieldMatrix.getColumnDimension();
        this.entries = new OpenIntToFieldHashMap(this.getField());
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int i3 = 0; i3 < this.columns; ++i3) {
                ((AbstractFieldMatrix)this).setEntry(i2, i3, fieldMatrix.getEntry(i2, i3));
            }
        }
    }

    @Override
    public void addToEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        n = this.computeKey(n, n2);
        FieldElement fieldElement = (FieldElement)this.entries.get(n).add(t);
        if (((FieldElement)this.getField().getZero()).equals(fieldElement)) {
            this.entries.remove(n);
            return;
        }
        this.entries.put(n, fieldElement);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new SparseFieldMatrix<T>(this);
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) {
        return new SparseFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public T getEntry(int n, int n2) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        return this.entries.get(this.computeKey(n, n2));
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        n = this.computeKey(n, n2);
        FieldElement fieldElement = (FieldElement)this.entries.get(n).multiply(t);
        if (((FieldElement)this.getField().getZero()).equals(fieldElement)) {
            this.entries.remove(n);
            return;
        }
        this.entries.put(n, fieldElement);
    }

    @Override
    public void setEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        if (((FieldElement)this.getField().getZero()).equals(t)) {
            this.entries.remove(this.computeKey(n, n2));
            return;
        }
        this.entries.put(this.computeKey(n, n2), t);
    }

    private int computeKey(int n, int n2) {
        return n * this.columns + n2;
    }
}

