/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularValueDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularValueDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class SingularValueDecomposition {
    private static final double EPS = 2.220446049250313E-16;
    private static final double TINY = 1.6033346880071782E-291;
    private final double[] singularValues;
    private final int m;
    private final int n;
    private final boolean transposed;
    private final RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private final RealMatrix cachedV;
    private RealMatrix cachedVt;
    private final double tol;

    public SingularValueDecomposition(RealMatrix object) {
        int n;
        double d2;
        int n2;
        int n3;
        double[][] dArray;
        if (object.getRowDimension() < object.getColumnDimension()) {
            this.transposed = true;
            dArray = object.transpose().getData();
            this.m = object.getColumnDimension();
            this.n = object.getRowDimension();
        } else {
            this.transposed = false;
            dArray = object.getData();
            this.m = object.getRowDimension();
            this.n = object.getColumnDimension();
        }
        this.singularValues = new double[this.n];
        object = new double[this.m][this.n];
        double[][] dArray2 = new double[this.n][this.n];
        double[] dArray3 = new double[this.n];
        double[] dArray4 = new double[this.m];
        int n4 = FastMath.min(this.m - 1, this.n);
        int n5 = FastMath.max(0, this.n - 2);
        for (n3 = 0; n3 < FastMath.max(n4, n5); ++n3) {
            int n6;
            if (n3 < n4) {
                this.singularValues[n3] = 0.0;
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.singularValues[n3] = FastMath.hypot(this.singularValues[n3], dArray[n2][n3]);
                }
                if (this.singularValues[n3] != 0.0) {
                    if (dArray[n3][n3] < 0.0) {
                        this.singularValues[n3] = -this.singularValues[n3];
                    }
                    for (n2 = n3; n2 < this.m; ++n2) {
                        double[] dArray5 = dArray[n2];
                        int n7 = n3;
                        dArray5[n7] = dArray5[n7] / this.singularValues[n3];
                    }
                    double[] dArray6 = dArray[n3];
                    int n8 = n3;
                    dArray6[n8] = dArray6[n8] + 1.0;
                }
                this.singularValues[n3] = -this.singularValues[n3];
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                if (n3 < n4 && this.singularValues[n3] != 0.0) {
                    double d3 = 0.0;
                    for (n6 = n3; n6 < this.m; ++n6) {
                        d3 += dArray[n6][n3] * dArray[n6][n2];
                    }
                    d3 = -d3 / dArray[n3][n3];
                    for (n6 = n3; n6 < this.m; ++n6) {
                        double[] dArray7 = dArray[n6];
                        int n9 = n2;
                        dArray7[n9] = dArray7[n9] + d3 * dArray[n6][n3];
                    }
                }
                dArray3[n2] = dArray[n3][n2];
            }
            if (n3 < n4) {
                for (n2 = n3; n2 < this.m; ++n2) {
                    object[n2][n3] = dArray[n2][n3];
                }
            }
            if (n3 >= n5) continue;
            dArray3[n3] = 0.0;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                dArray3[n3] = FastMath.hypot(dArray3[n3], dArray3[n2]);
            }
            if (dArray3[n3] != 0.0) {
                if (dArray3[n3 + 1] < 0.0) {
                    dArray3[n3] = -dArray3[n3];
                }
                n2 = n3 + 1;
                while (n2 < this.n) {
                    int n10 = n2++;
                    dArray3[n10] = dArray3[n10] / dArray3[n3];
                }
                int n11 = n3 + 1;
                dArray3[n11] = dArray3[n11] + 1.0;
            }
            dArray3[n3] = -dArray3[n3];
            if (n3 + 1 < this.m && dArray3[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < this.m; ++n2) {
                    dArray4[n2] = 0.0;
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    for (int i2 = n3 + 1; i2 < this.m; ++i2) {
                        int n12 = i2;
                        dArray4[n12] = dArray4[n12] + dArray3[n2] * dArray[i2][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    double d4 = -dArray3[n2] / dArray3[n3 + 1];
                    for (n6 = n3 + 1; n6 < this.m; ++n6) {
                        double[] dArray8 = dArray[n6];
                        int n13 = n2;
                        dArray8[n13] = dArray8[n13] + d4 * dArray4[n6];
                    }
                }
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                dArray2[n2][n3] = dArray3[n2];
            }
        }
        n3 = this.n;
        if (n4 < this.n) {
            this.singularValues[n4] = dArray[n4][n4];
        }
        if (this.m < n3) {
            this.singularValues[n3 - 1] = 0.0;
        }
        if (n5 + 1 < n3) {
            dArray3[n5] = dArray[n5][n3 - 1];
        }
        dArray3[n3 - 1] = 0.0;
        for (n2 = n4; n2 < this.n; ++n2) {
            for (int i3 = 0; i3 < this.m; ++i3) {
                object[i3][n2] = 0.0;
            }
            object[n2][n2] = 1.0;
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n14;
            if (this.singularValues[n2] != 0.0) {
                for (n14 = n2 + 1; n14 < this.n; ++n14) {
                    d2 = 0.0;
                    for (n = n2; n < this.m; ++n) {
                        d2 += object[n][n2] * object[n][n14];
                    }
                    d2 = -d2 / object[n2][n2];
                    for (n = n2; n < this.m; ++n) {
                        Object object2 = object[n];
                        int n15 = n14;
                        object2[n15] = object2[n15] + d2 * object[n][n2];
                    }
                }
                for (n14 = n2; n14 < this.m; ++n14) {
                    object[n14][n2] = -object[n14][n2];
                }
                object[n2][n2] = 1.0 + object[n2][n2];
                for (n14 = 0; n14 < n2 - 1; ++n14) {
                    object[n14][n2] = 0.0;
                }
                continue;
            }
            for (n14 = 0; n14 < this.m; ++n14) {
                object[n14][n2] = 0.0;
            }
            object[n2][n2] = 1.0;
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            int n16;
            if (n2 < n5 && dArray3[n2] != 0.0) {
                for (n16 = n2 + 1; n16 < this.n; ++n16) {
                    d2 = 0.0;
                    for (n = n2 + 1; n < this.n; ++n) {
                        d2 += dArray2[n][n2] * dArray2[n][n16];
                    }
                    d2 = -d2 / dArray2[n2 + 1][n2];
                    for (n = n2 + 1; n < this.n; ++n) {
                        double[] dArray9 = dArray2[n];
                        int n17 = n16;
                        dArray9[n17] = dArray9[n17] + d2 * dArray2[n][n2];
                    }
                }
            }
            for (n16 = 0; n16 < this.n; ++n16) {
                dArray2[n16][n2] = 0.0;
            }
            dArray2[n2][n2] = 1.0;
        }
        n2 = n3 - 1;
        block34: while (n3 > 0) {
            int n18;
            int n19;
            for (n19 = n3 - 2; n19 >= 0; --n19) {
                double d5 = 1.6033346880071782E-291 + 2.220446049250313E-16 * (FastMath.abs(this.singularValues[n19]) + FastMath.abs(this.singularValues[n19 + 1]));
                if (FastMath.abs(dArray3[n19]) > d5) continue;
                dArray3[n19] = 0.0;
                break;
            }
            if (n19 == n3 - 2) {
                n18 = 4;
            } else {
                int n20;
                for (n20 = n3 - 1; n20 >= n19 && n20 != n19; --n20) {
                    double d6 = (n20 != n3 ? FastMath.abs(dArray3[n20]) : 0.0) + (n20 != n19 + 1 ? FastMath.abs(dArray3[n20 - 1]) : 0.0);
                    if (!(FastMath.abs(this.singularValues[n20]) <= 1.6033346880071782E-291 + d6 * 2.220446049250313E-16)) continue;
                    this.singularValues[n20] = 0.0;
                    break;
                }
                if (n20 == n19) {
                    n18 = 3;
                } else if (n20 == n3 - 1) {
                    n18 = 1;
                } else {
                    n18 = 2;
                    n19 = n20;
                }
            }
            ++n19;
            switch (n18) {
                case 1: {
                    int n21;
                    double d7;
                    double d8;
                    double d9;
                    double d10 = dArray3[n3 - 2];
                    dArray3[n3 - 2] = 0.0;
                    for (int i4 = n3 - 2; i4 >= n19; --i4) {
                        d9 = FastMath.hypot(this.singularValues[i4], d10);
                        d8 = this.singularValues[i4] / d9;
                        d7 = d10 / d9;
                        this.singularValues[i4] = d9;
                        if (i4 != n19) {
                            d10 = -d7 * dArray3[i4 - 1];
                            dArray3[i4 - 1] = d8 * dArray3[i4 - 1];
                        }
                        for (n21 = 0; n21 < this.n; ++n21) {
                            d9 = d8 * dArray2[n21][i4] + d7 * dArray2[n21][n3 - 1];
                            dArray2[n21][n3 - 1] = -d7 * dArray2[n21][i4] + d8 * dArray2[n21][n3 - 1];
                            dArray2[n21][i4] = d9;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int n21;
                    double d7;
                    double d8;
                    double d9;
                    double d11 = dArray3[n19 - 1];
                    dArray3[n19 - 1] = 0.0;
                    for (int i5 = n19; i5 < n3; ++i5) {
                        d9 = FastMath.hypot(this.singularValues[i5], d11);
                        d8 = this.singularValues[i5] / d9;
                        d7 = d11 / d9;
                        this.singularValues[i5] = d9;
                        d11 = -d7 * dArray3[i5];
                        dArray3[i5] = d8 * dArray3[i5];
                        for (n21 = 0; n21 < this.m; ++n21) {
                            d9 = d8 * object[n21][i5] + d7 * object[n21][n19 - 1];
                            object[n21][n19 - 1] = -d7 * object[n21][i5] + d8 * object[n21][n19 - 1];
                            object[n21][i5] = d9;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double d12 = FastMath.max(FastMath.abs(this.singularValues[n3 - 1]), FastMath.abs(this.singularValues[n3 - 2]));
                    double d13 = FastMath.max(FastMath.max(FastMath.max(d12, FastMath.abs(dArray3[n3 - 2])), FastMath.abs(this.singularValues[n19])), FastMath.abs(dArray3[n19]));
                    double d14 = this.singularValues[n3 - 1] / d13;
                    double d15 = this.singularValues[n3 - 2] / d13;
                    double d16 = dArray3[n3 - 2] / d13;
                    double d17 = this.singularValues[n19] / d13;
                    double d18 = dArray3[n19] / d13;
                    double d19 = d16;
                    double d20 = ((d15 + d14) * (d15 - d14) + d19 * d19) / 2.0;
                    double d21 = d14 * d16 * (d14 * d16);
                    double d22 = 0.0;
                    if (d20 != 0.0 || d21 != 0.0) {
                        double d23 = d20;
                        d22 = FastMath.sqrt(d23 * d23 + d21);
                        if (d20 < 0.0) {
                            d22 = -d22;
                        }
                        d22 = d21 / (d20 + d22);
                    }
                    double d24 = (d17 + d14) * (d17 - d14) + d22;
                    double d25 = d17 * d18;
                    for (int i6 = n19; i6 < n3 - 1; ++i6) {
                        int n22;
                        double d26 = FastMath.hypot(d24, d25);
                        double d27 = d24 / d26;
                        double d28 = d25 / d26;
                        if (i6 != n19) {
                            dArray3[i6 - 1] = d26;
                        }
                        d24 = d27 * this.singularValues[i6] + d28 * dArray3[i6];
                        dArray3[i6] = d27 * dArray3[i6] - d28 * this.singularValues[i6];
                        d25 = d28 * this.singularValues[i6 + 1];
                        this.singularValues[i6 + 1] = d27 * this.singularValues[i6 + 1];
                        for (n22 = 0; n22 < this.n; ++n22) {
                            d26 = d27 * dArray2[n22][i6] + d28 * dArray2[n22][i6 + 1];
                            dArray2[n22][i6 + 1] = -d28 * dArray2[n22][i6] + d27 * dArray2[n22][i6 + 1];
                            dArray2[n22][i6] = d26;
                        }
                        d26 = FastMath.hypot(d24, d25);
                        d27 = d24 / d26;
                        d28 = d25 / d26;
                        this.singularValues[i6] = d26;
                        d24 = d27 * dArray3[i6] + d28 * this.singularValues[i6 + 1];
                        this.singularValues[i6 + 1] = -d28 * dArray3[i6] + d27 * this.singularValues[i6 + 1];
                        d25 = d28 * dArray3[i6 + 1];
                        dArray3[i6 + 1] = d27 * dArray3[i6 + 1];
                        if (i6 >= this.m - 1) continue;
                        for (n22 = 0; n22 < this.m; ++n22) {
                            d26 = d27 * object[n22][i6] + d28 * object[n22][i6 + 1];
                            object[n22][i6 + 1] = -d28 * object[n22][i6] + d27 * object[n22][i6 + 1];
                            object[n22][i6] = d26;
                        }
                    }
                    dArray3[n3 - 2] = d24;
                    continue block34;
                }
            }
            if (this.singularValues[n19] <= 0.0) {
                this.singularValues[n19] = this.singularValues[n19] < 0.0 ? -this.singularValues[n19] : 0.0;
                for (int i7 = 0; i7 <= n2; ++i7) {
                    dArray2[i7][n19] = -dArray2[i7][n19];
                }
            }
            while (n19 < n2 && !(this.singularValues[n19] >= this.singularValues[n19 + 1])) {
                int n23;
                Object object3 = this.singularValues[n19];
                this.singularValues[n19] = this.singularValues[n19 + 1];
                this.singularValues[n19 + 1] = object3;
                if (n19 < this.n - 1) {
                    for (n23 = 0; n23 < this.n; ++n23) {
                        object3 = dArray2[n23][n19 + 1];
                        dArray2[n23][n19 + 1] = dArray2[n23][n19];
                        dArray2[n23][n19] = object3;
                    }
                }
                if (n19 < this.m - 1) {
                    for (n23 = 0; n23 < this.m; ++n23) {
                        object3 = object[n23][n19 + 1];
                        object[n23][n19 + 1] = object[n23][n19];
                        object[n23][n19] = object3;
                    }
                }
                ++n19;
            }
            --n3;
        }
        this.tol = FastMath.max((double)this.m * this.singularValues[0] * 2.220446049250313E-16, FastMath.sqrt(Precision.SAFE_MIN));
        if (!this.transposed) {
            this.cachedU = MatrixUtils.createRealMatrix((double[][])object);
            this.cachedV = MatrixUtils.createRealMatrix(dArray2);
            return;
        }
        this.cachedU = MatrixUtils.createRealMatrix(dArray2);
        this.cachedV = MatrixUtils.createRealMatrix((double[][])object);
    }

    public RealMatrix getU() {
        return this.cachedU;
    }

    public RealMatrix getUT() {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() {
        return this.cachedV;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double d2) {
        int n;
        int n2 = this.singularValues.length;
        for (n = 0; n < n2 && this.singularValues[n] >= d2; ++n) {
        }
        if (n == 0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, (Number)d2, this.singularValues[0], true);
        }
        Object object = new double[n][n2];
        this.getVT().walkInOptimizedOrder(new SingularValueDecomposition$1(this, (double[][])object), 0, n - 1, 0, n2 - 1);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])object, false);
        object = array2DRowRealMatrix;
        return array2DRowRealMatrix.transpose().multiply((RealMatrix)object);
    }

    public double getNorm() {
        return this.singularValues[0];
    }

    public double getConditionNumber() {
        return this.singularValues[0] / this.singularValues[this.n - 1];
    }

    public double getInverseConditionNumber() {
        return this.singularValues[this.n - 1] / this.singularValues[0];
    }

    public int getRank() {
        int n = 0;
        for (int i2 = 0; i2 < this.singularValues.length; ++i2) {
            if (!(this.singularValues[i2] > this.tol)) continue;
            ++n;
        }
        return n;
    }

    public DecompositionSolver getSolver() {
        return new SingularValueDecomposition$Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == this.m, this.tol, null);
    }

    static /* synthetic */ double[] access$000(SingularValueDecomposition singularValueDecomposition) {
        return singularValueDecomposition.singularValues;
    }
}

