/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.HessenbergTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SchurTransformer$ShiftInfo;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

class SchurTransformer {
    private static final int MAX_ITERATIONS = 100;
    private final double[][] matrixP;
    private final double[][] matrixT;
    private RealMatrix cachedP;
    private RealMatrix cachedT;
    private RealMatrix cachedPt;
    private final double epsilon = Precision.EPSILON;

    SchurTransformer(RealMatrix object) {
        if (!object.isSquare()) {
            throw new NonSquareMatrixException(object.getRowDimension(), object.getColumnDimension());
        }
        object = new HessenbergTransformer((RealMatrix)object);
        this.matrixT = ((HessenbergTransformer)object).getH().getData();
        this.matrixP = ((HessenbergTransformer)object).getP().getData();
        this.cachedT = null;
        this.cachedP = null;
        this.cachedPt = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            this.cachedP = MatrixUtils.createRealMatrix(this.matrixP);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            this.cachedT = MatrixUtils.createRealMatrix(this.matrixT);
        }
        return this.cachedT;
    }

    private void transform() {
        int n = this.matrixT.length;
        double d2 = this.getNorm();
        SchurTransformer$ShiftInfo schurTransformer$ShiftInfo = new SchurTransformer$ShiftInfo(null);
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = this.findSmallSubDiagonalElement(n3, d2);
            if (n4 == n3) {
                double[] dArray = this.matrixT[n3];
                int n5 = n3--;
                dArray[n5] = dArray[n5] + schurTransformer$ShiftInfo.exShift;
                n2 = 0;
                continue;
            }
            if (n4 == n3 - 1) {
                double d3 = (this.matrixT[n3 - 1][n3 - 1] - this.matrixT[n3][n3]) / 2.0;
                double d4 = d3 * d3 + this.matrixT[n3][n3 - 1] * this.matrixT[n3 - 1][n3];
                double[] dArray = this.matrixT[n3];
                int n6 = n3;
                dArray[n6] = dArray[n6] + schurTransformer$ShiftInfo.exShift;
                double[] dArray2 = this.matrixT[n3 - 1];
                int n7 = n3 - 1;
                dArray2[n7] = dArray2[n7] + schurTransformer$ShiftInfo.exShift;
                if (d4 >= 0.0) {
                    double d5 = FastMath.sqrt(FastMath.abs(d4));
                    d5 = d3 >= 0.0 ? d3 + d5 : d3 - d5;
                    double d6 = this.matrixT[n3][n3 - 1];
                    double d7 = FastMath.abs(d6) + FastMath.abs(d5);
                    d3 = d6 / d7;
                    d4 = d5 / d7;
                    double d8 = d3;
                    double d9 = d4;
                    double d10 = FastMath.sqrt(d8 * d8 + d9 * d9);
                    d3 /= d10;
                    d4 /= d10;
                    for (n2 = n3 - 1; n2 < n; ++n2) {
                        d5 = this.matrixT[n3 - 1][n2];
                        this.matrixT[n3 - 1][n2] = d4 * d5 + d3 * this.matrixT[n3][n2];
                        this.matrixT[n3][n2] = d4 * this.matrixT[n3][n2] - d3 * d5;
                    }
                    for (n2 = 0; n2 <= n3; ++n2) {
                        d5 = this.matrixT[n2][n3 - 1];
                        this.matrixT[n2][n3 - 1] = d4 * d5 + d3 * this.matrixT[n2][n3];
                        this.matrixT[n2][n3] = d4 * this.matrixT[n2][n3] - d3 * d5;
                    }
                    for (n2 = 0; n2 <= n - 1; ++n2) {
                        d5 = this.matrixP[n2][n3 - 1];
                        this.matrixP[n2][n3 - 1] = d4 * d5 + d3 * this.matrixP[n2][n3];
                        this.matrixP[n2][n3] = d4 * this.matrixP[n2][n3] - d3 * d5;
                    }
                }
                n3 -= 2;
                n2 = 0;
                continue;
            }
            this.computeShift(n4, n3, n2, schurTransformer$ShiftInfo);
            if (++n2 > 100) {
                throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, 100, new Object[0]);
            }
            double[] dArray = new double[3];
            int n8 = this.initQRStep(n4, n3, schurTransformer$ShiftInfo, dArray);
            this.performDoubleQRStep(n4, n8, n3, schurTransformer$ShiftInfo, dArray);
        }
    }

    private double getNorm() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.matrixT.length; ++i2) {
            for (int i3 = FastMath.max(i2 - 1, 0); i3 < this.matrixT.length; ++i3) {
                d2 += FastMath.abs(this.matrixT[i2][i3]);
            }
        }
        return d2;
    }

    private int findSmallSubDiagonalElement(int n, double d2) {
        while (n > 0) {
            double d3 = FastMath.abs(this.matrixT[n - 1][n - 1]) + FastMath.abs(this.matrixT[n][n]);
            if (d3 == 0.0) {
                d3 = d2;
            }
            if (FastMath.abs(this.matrixT[n][n - 1]) < this.epsilon * d3) break;
            --n;
        }
        return n;
    }

    private void computeShift(int n, int n2, int n3, SchurTransformer$ShiftInfo schurTransformer$ShiftInfo) {
        double d2;
        schurTransformer$ShiftInfo.x = this.matrixT[n2][n2];
        SchurTransformer$ShiftInfo schurTransformer$ShiftInfo2 = schurTransformer$ShiftInfo;
        schurTransformer$ShiftInfo2.w = 0.0;
        schurTransformer$ShiftInfo2.y = 0.0;
        if (n < n2) {
            schurTransformer$ShiftInfo.y = this.matrixT[n2 - 1][n2 - 1];
            schurTransformer$ShiftInfo.w = this.matrixT[n2][n2 - 1] * this.matrixT[n2 - 1][n2];
        }
        if (n3 == 10) {
            schurTransformer$ShiftInfo.exShift += schurTransformer$ShiftInfo.x;
            int n4 = 0;
            while (n4 <= n2) {
                double[] dArray = this.matrixT[n4];
                int n5 = n4++;
                dArray[n5] = dArray[n5] - schurTransformer$ShiftInfo.x;
            }
            d2 = FastMath.abs(this.matrixT[n2][n2 - 1]) + FastMath.abs(this.matrixT[n2 - 1][n2 - 2]);
            schurTransformer$ShiftInfo.x = d2 * 0.75;
            schurTransformer$ShiftInfo.y = d2 * 0.75;
            schurTransformer$ShiftInfo.w = d2 * -0.4375 * d2;
        }
        if (n3 == 30) {
            double d3;
            d2 = (schurTransformer$ShiftInfo.y - schurTransformer$ShiftInfo.x) / 2.0;
            d2 = d2 * d2 + schurTransformer$ShiftInfo.w;
            if (d3 > 0.0) {
                d2 = FastMath.sqrt(d2);
                if (schurTransformer$ShiftInfo.y < schurTransformer$ShiftInfo.x) {
                    d2 = -d2;
                }
                d2 = schurTransformer$ShiftInfo.x - schurTransformer$ShiftInfo.w / ((schurTransformer$ShiftInfo.y - schurTransformer$ShiftInfo.x) / 2.0 + d2);
                n = 0;
                while (n <= n2) {
                    double[] dArray = this.matrixT[n];
                    int n6 = n++;
                    dArray[n6] = dArray[n6] - d2;
                }
                schurTransformer$ShiftInfo.exShift += d2;
                SchurTransformer$ShiftInfo schurTransformer$ShiftInfo3 = schurTransformer$ShiftInfo;
                schurTransformer$ShiftInfo.w = 0.964;
                schurTransformer$ShiftInfo3.y = 0.964;
                schurTransformer$ShiftInfo3.x = 0.964;
            }
        }
    }

    private int initQRStep(int n, int n2, SchurTransformer$ShiftInfo schurTransformer$ShiftInfo, double[] dArray) {
        n2 -= 2;
        while (n2 >= n) {
            double d2;
            double d3;
            double d4 = this.matrixT[n2][n2];
            double d5 = schurTransformer$ShiftInfo.x - d4;
            double d6 = schurTransformer$ShiftInfo.y - d4;
            dArray[0] = (d5 * d6 - schurTransformer$ShiftInfo.w) / this.matrixT[n2 + 1][n2] + this.matrixT[n2][n2 + 1];
            dArray[1] = this.matrixT[n2 + 1][n2 + 1] - d4 - d5 - d6;
            dArray[2] = this.matrixT[n2 + 2][n2 + 1];
            if (n2 == n || (d3 = FastMath.abs(this.matrixT[n2][n2 - 1]) * (FastMath.abs(dArray[1]) + FastMath.abs(dArray[2]))) < this.epsilon * (d2 = FastMath.abs(dArray[0]) * (FastMath.abs(this.matrixT[n2 - 1][n2 - 1]) + FastMath.abs(d4) + FastMath.abs(this.matrixT[n2 + 1][n2 + 1])))) break;
            --n2;
        }
        return n2;
    }

    private void performDoubleQRStep(int n, int n2, int n3, SchurTransformer$ShiftInfo schurTransformer$ShiftInfo, double[] dArray) {
        int n4;
        int n5 = this.matrixT.length;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        for (n4 = n2; n4 <= n3 - 1; ++n4) {
            boolean bl;
            boolean bl2 = bl = n4 != n3 - 1;
            if (n4 != n2) {
                d2 = this.matrixT[n4][n4 - 1];
                d3 = this.matrixT[n4 + 1][n4 - 1];
                d4 = bl ? this.matrixT[n4 + 2][n4 - 1] : 0.0;
                schurTransformer$ShiftInfo.x = FastMath.abs(d2) + FastMath.abs(d3) + FastMath.abs(d4);
                if (Precision.equals(schurTransformer$ShiftInfo.x, 0.0, this.epsilon)) continue;
                d2 /= schurTransformer$ShiftInfo.x;
                d3 /= schurTransformer$ShiftInfo.x;
                d4 /= schurTransformer$ShiftInfo.x;
            }
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            double d8 = FastMath.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
            if (d2 < 0.0) {
                d8 = -d8;
            }
            if (d8 == 0.0) continue;
            if (n4 != n2) {
                this.matrixT[n4][n4 - 1] = -d8 * schurTransformer$ShiftInfo.x;
            } else if (n != n2) {
                this.matrixT[n4][n4 - 1] = -this.matrixT[n4][n4 - 1];
            }
            schurTransformer$ShiftInfo.x = (d2 += d8) / d8;
            schurTransformer$ShiftInfo.y = d3 / d8;
            double d9 = d4 / d8;
            d3 /= d2;
            d4 /= d2;
            int n6 = n4;
            while (n6 < n5) {
                d2 = this.matrixT[n4][n6] + d3 * this.matrixT[n4 + 1][n6];
                if (bl) {
                    double[] dArray2 = this.matrixT[n4 + 2];
                    int n7 = n6;
                    dArray2[n7] = dArray2[n7] - (d2 += d4 * this.matrixT[n4 + 2][n6]) * d9;
                }
                double[] dArray3 = this.matrixT[n4];
                int n8 = n6;
                dArray3[n8] = dArray3[n8] - d2 * schurTransformer$ShiftInfo.x;
                double[] dArray4 = this.matrixT[n4 + 1];
                int n9 = n6++;
                dArray4[n9] = dArray4[n9] - d2 * schurTransformer$ShiftInfo.y;
            }
            for (n6 = 0; n6 <= FastMath.min(n3, n4 + 3); ++n6) {
                d2 = schurTransformer$ShiftInfo.x * this.matrixT[n6][n4] + schurTransformer$ShiftInfo.y * this.matrixT[n6][n4 + 1];
                if (bl) {
                    double[] dArray5 = this.matrixT[n6];
                    int n10 = n4 + 2;
                    dArray5[n10] = dArray5[n10] - (d2 += d9 * this.matrixT[n6][n4 + 2]) * d4;
                }
                double[] dArray6 = this.matrixT[n6];
                int n11 = n4;
                dArray6[n11] = dArray6[n11] - d2;
                double[] dArray7 = this.matrixT[n6];
                int n12 = n4 + 1;
                dArray7[n12] = dArray7[n12] - d2 * d3;
            }
            n6 = this.matrixT.length - 1;
            for (int i2 = 0; i2 <= n6; ++i2) {
                d2 = schurTransformer$ShiftInfo.x * this.matrixP[i2][n4] + schurTransformer$ShiftInfo.y * this.matrixP[i2][n4 + 1];
                if (bl) {
                    double[] dArray8 = this.matrixP[i2];
                    int n13 = n4 + 2;
                    dArray8[n13] = dArray8[n13] - (d2 += d9 * this.matrixP[i2][n4 + 2]) * d4;
                }
                double[] dArray9 = this.matrixP[i2];
                int n14 = n4;
                dArray9[n14] = dArray9[n14] - d2;
                double[] dArray10 = this.matrixP[i2];
                int n15 = n4 + 1;
                dArray10[n15] = dArray10[n15] - d2 * d3;
            }
        }
        for (n4 = n2 + 2; n4 <= n3; ++n4) {
            this.matrixT[n4][n4 - 2] = 0.0;
            if (n4 <= n2 + 2) continue;
            this.matrixT[n4][n4 - 3] = 0.0;
        }
    }
}

