/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class RectangularCholeskyDecomposition {
    private final RealMatrix root;
    private int rank;

    public RectangularCholeskyDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public RectangularCholeskyDecomposition(RealMatrix object, double d2) {
        int n;
        int n2 = object.getRowDimension();
        object = object.getData();
        int n3 = n2;
        double[][] dArray = new double[n3][n3];
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4++;
            nArray[n5] = n5;
        }
        n4 = 0;
        int n6 = 1;
        while (n6 != 0) {
            int n7;
            n = n4;
            for (n6 = n4 + 1; n6 < n2; ++n6) {
                int n8 = nArray[n6];
                int n9 = nArray[n];
                if (!(object[n8][n8] > object[n9][n9])) continue;
                n = n6;
            }
            if (n != n4) {
                n6 = nArray[n4];
                nArray[n4] = nArray[n];
                nArray[n] = n6;
                double[] dArray2 = dArray[n4];
                dArray[n4] = dArray[n];
                dArray[n] = dArray2;
            }
            if (object[n6 = nArray[n4]][n6] <= d2) {
                if (n4 == 0) {
                    throw new NonPositiveDefiniteMatrixException((double)object[n6][n6], n6, d2);
                }
                for (int i2 = n4; i2 < n2; ++i2) {
                    if (!(object[nArray[i2]][nArray[i2]] < -d2)) continue;
                    throw new NonPositiveDefiniteMatrixException((double)object[nArray[i2]][nArray[i2]], i2, d2);
                }
                n7 = 0;
            } else {
                double d3;
                dArray[n4][n4] = d3 = FastMath.sqrt((double)object[n6][n6]);
                double d4 = 1.0 / d3;
                double d5 = 1.0 / object[n6][n6];
                for (n = n4 + 1; n < n2; ++n) {
                    double d6;
                    int n10 = nArray[n];
                    dArray[n][n4] = d6 = d4 * object[n10][n6];
                    Object object2 = object[n10];
                    int n8 = n10;
                    object2[n8] = object2[n8] - object[n10][n6] * object[n10][n6] * d5;
                    for (int i3 = n4 + 1; i3 < n; ++i3) {
                        reference var24_20;
                        int n12 = nArray[i3];
                        object[n10][n12] = var24_20 = object[n10][n12] - d6 * dArray[i3][n4];
                        object[n12][n10] = var24_20;
                    }
                }
                n7 = ++n4 < n2 ? 1 : 0;
            }
            n6 = n7;
        }
        this.rank = n4;
        this.root = MatrixUtils.createRealMatrix(n2, n4);
        for (n6 = 0; n6 < n2; ++n6) {
            for (n = 0; n < n4; ++n) {
                this.root.setEntry(nArray[n6], n, dArray[n6][n]);
            }
        }
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }
}

