/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CompositeFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;

public class RealVectorFormat {
    private static final String DEFAULT_PREFIX = "{";
    private static final String DEFAULT_SUFFIX = "}";
    private static final String DEFAULT_SEPARATOR = "; ";
    private final String prefix;
    private final String suffix;
    private final String separator;
    private final String trimmedPrefix;
    private final String trimmedSuffix;
    private final String trimmedSeparator;
    private final NumberFormat format;

    public RealVectorFormat() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, CompositeFormat.getDefaultNumberFormat());
    }

    public RealVectorFormat(NumberFormat numberFormat) {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, numberFormat);
    }

    public RealVectorFormat(String string, String string2, String string3) {
        this(string, string2, string3, CompositeFormat.getDefaultNumberFormat());
    }

    public RealVectorFormat(String string, String string2, String string3, NumberFormat numberFormat) {
        this.prefix = string;
        this.suffix = string2;
        this.separator = string3;
        this.trimmedPrefix = string.trim();
        this.trimmedSuffix = string2.trim();
        this.trimmedSeparator = string3.trim();
        this.format = numberFormat;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public static RealVectorFormat getInstance() {
        return RealVectorFormat.getInstance(Locale.getDefault());
    }

    public static RealVectorFormat getInstance(Locale locale) {
        return new RealVectorFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    public String format(RealVector realVector) {
        return this.format(realVector, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(RealVector realVector, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        stringBuffer.append(this.prefix);
        for (int i2 = 0; i2 < realVector.getDimension(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.separator);
            }
            CompositeFormat.formatDouble(realVector.getEntry(i2), this.format, stringBuffer, fieldPosition);
        }
        stringBuffer.append(this.suffix);
        return stringBuffer;
    }

    public ArrayRealVector parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        ArrayRealVector arrayRealVector = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), ArrayRealVector.class);
        }
        return arrayRealVector;
    }

    public ArrayRealVector parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, this.trimmedPrefix, parsePosition)) {
            return null;
        }
        ArrayList<Number> arrayList = new ArrayList<Number>();
        boolean bl = true;
        while (bl) {
            if (!arrayList.isEmpty()) {
                CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
                if (!CompositeFormat.parseFixedstring(string, this.trimmedSeparator, parsePosition)) {
                    bl = false;
                }
            }
            if (!bl) continue;
            CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
            Number number = CompositeFormat.parseNumber(string, this.format, parsePosition);
            if (number != null) {
                arrayList.add(number);
                continue;
            }
            parsePosition.setIndex(n);
            return null;
        }
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, this.trimmedSuffix, parsePosition)) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = ((Number)arrayList.get(i2)).doubleValue();
        }
        return new ArrayRealVector(dArray, false);
    }
}

