/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Add;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Divide;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Multiply;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.OpenMapRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$Entry;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$SparseEntryIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVectorChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVectorPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SparseRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealVector {
    public abstract int getDimension();

    public abstract double getEntry(int var1);

    public abstract void setEntry(int var1, double var2);

    public void addToEntry(int n, double d2) {
        this.setEntry(n, this.getEntry(n) + d2);
    }

    public abstract RealVector append(RealVector var1);

    public abstract RealVector append(double var1);

    public abstract RealVector getSubVector(int var1, int var2);

    public abstract void setSubVector(int var1, RealVector var2);

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    protected void checkVectorDimensions(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
    }

    protected void checkVectorDimensions(int n) {
        int n2 = this.getDimension();
        if (n2 != n) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    protected void checkIndex(int n) {
        if (n < 0 || n >= this.getDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.getDimension() - 1);
        }
    }

    protected void checkIndices(int n, int n2) {
        int n3 = this.getDimension();
        if (n < 0 || n >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, n3 - 1);
        }
        if (n2 < 0 || n2 >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n2, 0, n3 - 1);
        }
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
    }

    public RealVector add(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        realVector = realVector.copy();
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            int n = realVector$Entry.getIndex();
            realVector.setEntry(n, realVector$Entry.getValue() + realVector.getEntry(n));
        }
        return realVector;
    }

    public RealVector subtract(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        realVector = realVector.mapMultiply(-1.0);
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            int n = realVector$Entry.getIndex();
            realVector.setEntry(n, realVector$Entry.getValue() + realVector.getEntry(n));
        }
        return realVector;
    }

    public RealVector mapAdd(double d2) {
        return this.copy().mapAddToSelf(d2);
    }

    public RealVector mapAddToSelf(double d2) {
        if (d2 != 0.0) {
            return this.mapToSelf(FunctionUtils.fix2ndArgument(new Add(), d2));
        }
        return this;
    }

    public abstract RealVector copy();

    public double dotProduct(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        double d2 = 0.0;
        int n = this.getDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            d2 += this.getEntry(i2) * realVector.getEntry(i2);
        }
        return d2;
    }

    public double cosine(RealVector realVector) {
        double d2 = this.getNorm();
        double d3 = realVector.getNorm();
        if (d2 == 0.0 || d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.dotProduct(realVector) / (d2 * d3);
    }

    public abstract RealVector ebeDivide(RealVector var1);

    public abstract RealVector ebeMultiply(RealVector var1);

    public double getDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            double d3;
            RealVector$Entry realVector$Entry = iterator.next();
            double d4 = d3 = realVector$Entry.getValue() - realVector.getEntry(realVector$Entry.getIndex());
            d2 += d4 * d4;
        }
        return FastMath.sqrt(d2);
    }

    public double getNorm() {
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            double d3;
            RealVector$Entry realVector$Entry = iterator.next();
            double d4 = d3 = realVector$Entry.getValue();
            d2 += d4 * d4;
        }
        return FastMath.sqrt(d2);
    }

    public double getL1Norm() {
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            d2 += FastMath.abs(realVector$Entry.getValue());
        }
        return d2;
    }

    public double getLInfNorm() {
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            d2 = FastMath.max(d2, FastMath.abs(realVector$Entry.getValue()));
        }
        return d2;
    }

    public double getL1Distance(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            d2 += FastMath.abs(realVector$Entry.getValue() - realVector.getEntry(realVector$Entry.getIndex()));
        }
        return d2;
    }

    public double getLInfDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector);
        double d2 = 0.0;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            d2 = FastMath.max(FastMath.abs(realVector$Entry.getValue() - realVector.getEntry(realVector$Entry.getIndex())), d2);
        }
        return d2;
    }

    public int getMinIndex() {
        int n = -1;
        double d2 = Double.POSITIVE_INFINITY;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry;
            RealVector$Entry realVector$Entry2 = iterator.next();
            if (!(realVector$Entry.getValue() <= d2)) continue;
            n = realVector$Entry2.getIndex();
            d2 = realVector$Entry2.getValue();
        }
        return n;
    }

    public double getMinValue() {
        int n = this.getMinIndex();
        if (n < 0) {
            return Double.NaN;
        }
        return this.getEntry(n);
    }

    public int getMaxIndex() {
        int n = -1;
        double d2 = Double.NEGATIVE_INFINITY;
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry;
            RealVector$Entry realVector$Entry2 = iterator.next();
            if (!(realVector$Entry.getValue() >= d2)) continue;
            n = realVector$Entry2.getIndex();
            d2 = realVector$Entry2.getValue();
        }
        return n;
    }

    public double getMaxValue() {
        int n = this.getMaxIndex();
        if (n < 0) {
            return Double.NaN;
        }
        return this.getEntry(n);
    }

    public RealVector mapMultiply(double d2) {
        return this.copy().mapMultiplyToSelf(d2);
    }

    public RealVector mapMultiplyToSelf(double d2) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Multiply(), d2));
    }

    public RealVector mapSubtract(double d2) {
        return this.copy().mapSubtractToSelf(d2);
    }

    public RealVector mapSubtractToSelf(double d2) {
        return this.mapAddToSelf(-d2);
    }

    public RealVector mapDivide(double d2) {
        return this.copy().mapDivideToSelf(d2);
    }

    public RealVector mapDivideToSelf(double d2) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Divide(), d2));
    }

    public RealMatrix outerProduct(RealVector realVector) {
        int n = this.getDimension();
        int n2 = realVector.getDimension();
        AbstractRealMatrix abstractRealMatrix = realVector instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(n, n2) : new Array2DRowRealMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                abstractRealMatrix.setEntry(i2, i3, this.getEntry(i2) * realVector.getEntry(i3));
            }
        }
        return abstractRealMatrix;
    }

    public RealVector projection(RealVector realVector) {
        RealVector realVector2 = realVector;
        double d2 = realVector2.dotProduct(realVector2);
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        RealVector realVector3 = realVector;
        return realVector.mapMultiply(this.dotProduct(realVector) / realVector3.dotProduct(realVector3));
    }

    public void set(double d2) {
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            realVector$Entry.setValue(d2);
        }
    }

    public double[] toArray() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.getEntry(i2);
        }
        return dArray;
    }

    public RealVector unitVector() {
        double d2 = this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.mapDivide(d2);
    }

    public void unitize() {
        double d2 = this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        RealVector realVector = this;
        realVector.mapDivideToSelf(realVector.getNorm());
    }

    public Iterator<RealVector$Entry> sparseIterator() {
        return new RealVector$SparseEntryIterator(this);
    }

    public Iterator<RealVector$Entry> iterator() {
        int n = this.getDimension();
        return new RealVector$1(this, n);
    }

    public RealVector map(UnivariateFunction univariateFunction) {
        return this.copy().mapToSelf(univariateFunction);
    }

    public RealVector mapToSelf(UnivariateFunction univariateFunction) {
        Iterator<RealVector$Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            RealVector$Entry realVector$Entry = iterator.next();
            realVector$Entry.setValue(univariateFunction.value(realVector$Entry.getValue()));
        }
        return this;
    }

    public RealVector combine(double d2, double d3, RealVector realVector) {
        return this.copy().combineToSelf(d2, d3, realVector);
    }

    public RealVector combineToSelf(double d2, double d3, RealVector realVector) {
        this.checkVectorDimensions(realVector);
        for (int i2 = 0; i2 < this.getDimension(); ++i2) {
            double d4 = this.getEntry(i2);
            double d5 = realVector.getEntry(i2);
            this.setEntry(i2, d2 * d4 + d3 * d5);
        }
        return this;
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        int n = this.getDimension();
        realVectorPreservingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            realVectorPreservingVisitor.visit(i2, this.getEntry(i2));
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        realVectorPreservingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            realVectorPreservingVisitor.visit(n, this.getEntry(n));
            ++n;
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        return this.walkInDefaultOrder(realVectorPreservingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(realVectorPreservingVisitor, n, n2);
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        int n = this.getDimension();
        realVectorChangingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            this.setEntry(i2, realVectorChangingVisitor.visit(i2, this.getEntry(i2)));
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        realVectorChangingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            this.setEntry(n, realVectorChangingVisitor.visit(n, this.getEntry(n)));
            ++n;
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        return this.walkInDefaultOrder(realVectorChangingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(realVectorChangingVisitor, n, n2);
    }

    public boolean equals(Object object) {
        throw new MathUnsupportedOperationException();
    }

    public int hashCode() {
        throw new MathUnsupportedOperationException();
    }

    public static RealVector unmodifiableRealVector(RealVector realVector) {
        return new RealVector$2(realVector);
    }
}

