/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CompositeFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RealMatrixFormat {
    private static final String DEFAULT_PREFIX = "{";
    private static final String DEFAULT_SUFFIX = "}";
    private static final String DEFAULT_ROW_PREFIX = "{";
    private static final String DEFAULT_ROW_SUFFIX = "}";
    private static final String DEFAULT_ROW_SEPARATOR = ",";
    private static final String DEFAULT_COLUMN_SEPARATOR = ",";
    private final String prefix;
    private final String suffix;
    private final String rowPrefix;
    private final String rowSuffix;
    private final String rowSeparator;
    private final String columnSeparator;
    private final NumberFormat format;

    public RealMatrixFormat() {
        this("{", "}", "{", "}", ",", ",", CompositeFormat.getDefaultNumberFormat());
    }

    public RealMatrixFormat(NumberFormat numberFormat) {
        this("{", "}", "{", "}", ",", ",", numberFormat);
    }

    public RealMatrixFormat(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, CompositeFormat.getDefaultNumberFormat());
    }

    public RealMatrixFormat(String string, String string2, String string3, String string4, String string5, String string6, NumberFormat numberFormat) {
        this.prefix = string;
        this.suffix = string2;
        this.rowPrefix = string3;
        this.rowSuffix = string4;
        this.rowSeparator = string5;
        this.columnSeparator = string6;
        this.format = numberFormat;
        this.format.setGroupingUsed(false);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRowPrefix() {
        return this.rowPrefix;
    }

    public String getRowSuffix() {
        return this.rowSuffix;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public static RealMatrixFormat getInstance() {
        return RealMatrixFormat.getInstance(Locale.getDefault());
    }

    public static RealMatrixFormat getInstance(Locale locale) {
        return new RealMatrixFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    public String format(RealMatrix realMatrix) {
        return this.format(realMatrix, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(RealMatrix realMatrix, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        stringBuffer.append(this.prefix);
        int n = realMatrix.getRowDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(this.rowPrefix);
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                if (i3 > 0) {
                    stringBuffer.append(this.columnSeparator);
                }
                CompositeFormat.formatDouble(realMatrix.getEntry(i2, i3), this.format, stringBuffer, fieldPosition);
            }
            stringBuffer.append(this.rowSuffix);
            if (i2 >= n - 1) continue;
            stringBuffer.append(this.rowSeparator);
        }
        stringBuffer.append(this.suffix);
        return stringBuffer;
    }

    public RealMatrix parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        RealMatrix realMatrix = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Array2DRowRealMatrix.class);
        }
        return realMatrix;
    }

    public RealMatrix parse(String object, ParsePosition object2) {
        int n = ((ParsePosition)object2).getIndex();
        Object object3 = this.prefix.trim();
        String string = this.suffix.trim();
        String string2 = this.rowPrefix.trim();
        String string3 = this.rowSuffix.trim();
        String string4 = this.columnSeparator.trim();
        String string5 = this.rowSeparator.trim();
        CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
        if (!CompositeFormat.parseFixedstring((String)object, (String)object3, (ParsePosition)object2)) {
            return null;
        }
        object3 = new ArrayList();
        ArrayList<Number> arrayList = new ArrayList<Number>();
        boolean bl = true;
        while (bl) {
            if (!arrayList.isEmpty()) {
                CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
                if (!CompositeFormat.parseFixedstring((String)object, string4, (ParsePosition)object2)) {
                    if (string3.length() != 0 && !CompositeFormat.parseFixedstring((String)object, string3, (ParsePosition)object2)) {
                        return null;
                    }
                    CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
                    if (CompositeFormat.parseFixedstring((String)object, string5, (ParsePosition)object2)) {
                        object3.add(arrayList);
                        arrayList = new ArrayList();
                        continue;
                    }
                    bl = false;
                }
            } else {
                CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
                if (string2.length() != 0 && !CompositeFormat.parseFixedstring((String)object, string2, (ParsePosition)object2)) {
                    return null;
                }
            }
            if (!bl) continue;
            CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
            Number number = CompositeFormat.parseNumber((String)object, this.format, (ParsePosition)object2);
            if (number != null) {
                arrayList.add(number);
                continue;
            }
            if (arrayList.isEmpty()) {
                bl = false;
                continue;
            }
            ((ParsePosition)object2).setIndex(n);
            return null;
        }
        if (!arrayList.isEmpty()) {
            object3.add(arrayList);
        }
        CompositeFormat.parseAndIgnoreWhitespace((String)object, (ParsePosition)object2);
        if (!CompositeFormat.parseFixedstring((String)object, string, (ParsePosition)object2)) {
            return null;
        }
        if (object3.isEmpty()) {
            ((ParsePosition)object2).setIndex(n);
            return null;
        }
        double[][] dArrayArray = new double[object3.size()][];
        int n2 = 0;
        object = object3.iterator();
        while (object.hasNext()) {
            object2 = (List)object.next();
            dArrayArray[n2] = new double[object2.size()];
            for (n = 0; n < object2.size(); ++n) {
                dArrayArray[n2][n] = ((Number)object2.get(n)).doubleValue();
            }
            ++n2;
        }
        return MatrixUtils.createRealMatrix(dArrayArray);
    }
}

