/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RRQRDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class RRQRDecomposition
extends QRDecomposition {
    private int[] p;
    private RealMatrix cachedP;

    public RRQRDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public RRQRDecomposition(RealMatrix realMatrix, double d2) {
        super(realMatrix, d2);
    }

    protected void decompose(double[][] dArray) {
        this.p = new int[dArray.length];
        int n = 0;
        while (n < this.p.length) {
            int n2 = n++;
            this.p[n2] = n2;
        }
        super.decompose(dArray);
    }

    protected void performHouseholderReflection(int n, double[][] dArray) {
        double d2 = 0.0;
        int n2 = n;
        for (int i2 = n; i2 < dArray.length; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < dArray[i2].length; ++i3) {
                d3 += dArray[i2][i3] * dArray[i2][i3];
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
            n2 = i2;
        }
        if (n2 != n) {
            double[] dArray2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = dArray2;
            int n3 = this.p[n];
            this.p[n] = this.p[n2];
            this.p[n2] = n3;
        }
        super.performHouseholderReflection(n, dArray);
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int n;
            int n2 = n = this.p.length;
            this.cachedP = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                this.cachedP.setEntry(this.p[i2], i2, 1.0);
            }
        }
        return this.cachedP;
    }

    public int getRank(double d2) {
        double d3;
        int n;
        double d4;
        RealMatrix realMatrix = this.getR();
        int n2 = realMatrix.getRowDimension();
        int n3 = realMatrix.getColumnDimension();
        double d5 = d4 = realMatrix.getFrobeniusNorm();
        for (n = 1; n < FastMath.min(n2, n3) && (d3 = realMatrix.getSubMatrix(n, n2 - 1, n, n3 - 1).getFrobeniusNorm()) != 0.0 && !(d3 / d4 * d5 < d2); ++n) {
            d4 = d3;
        }
        return n;
    }

    public DecompositionSolver getSolver() {
        return new RRQRDecomposition$Solver(super.getSolver(), this.getP(), null);
    }
}

