/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class QRDecomposition {
    private double[][] qrt;
    private double[] rDiag;
    private RealMatrix cachedQ;
    private RealMatrix cachedQT;
    private RealMatrix cachedR;
    private RealMatrix cachedH;
    private final double threshold;

    public QRDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public QRDecomposition(RealMatrix realMatrix, double d2) {
        this.threshold = d2;
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        this.qrt = realMatrix.transpose().getData();
        this.rDiag = new double[FastMath.min(n, n2)];
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        QRDecomposition qRDecomposition = this;
        qRDecomposition.decompose(qRDecomposition.qrt);
    }

    protected void decompose(double[][] dArray) {
        for (int i2 = 0; i2 < FastMath.min(dArray.length, dArray[0].length); ++i2) {
            this.performHouseholderReflection(i2, dArray);
        }
    }

    protected void performHouseholderReflection(int n, double[][] dArray) {
        double d2;
        double[] dArray2 = dArray[n];
        double d3 = 0.0;
        for (int i2 = n; i2 < dArray2.length; ++i2) {
            double d4;
            double d5 = d4 = dArray2[i2];
            d3 += d5 * d5;
        }
        this.rDiag[n] = d2 = dArray2[n] > 0.0 ? -FastMath.sqrt(d3) : FastMath.sqrt(d3);
        if (d2 != 0.0) {
            int n2 = n;
            dArray2[n2] = dArray2[n2] - d2;
            for (int i3 = n + 1; i3 < dArray.length; ++i3) {
                int n3;
                double[] dArray3 = dArray[i3];
                double d6 = 0.0;
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    d6 -= dArray3[n3] * dArray2[n3];
                }
                d6 /= d2 * dArray2[n];
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - d6 * dArray2[n3];
                }
            }
        }
    }

    public RealMatrix getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (n2 = FastMath.min(n2, n) - 1; n2 >= 0; --n2) {
                dArray[n2][n2] = this.rDiag[n2];
                for (int i2 = n2 + 1; i2 < n; ++i2) {
                    dArray[n2][i2] = this.qrt[i2][n2];
                }
            }
            this.cachedR = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedR;
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQT == null) {
            int n;
            int n2 = this.qrt.length;
            int n3 = this.qrt[0].length;
            double[][] dArray = new double[n3][n3];
            for (n = n3 - 1; n >= FastMath.min(n3, n2); --n) {
                dArray[n][n] = 1.0;
            }
            for (n = FastMath.min(n3, n2) - 1; n >= 0; --n) {
                double[] dArray2 = this.qrt[n];
                dArray[n][n] = 1.0;
                if (dArray2[n] == 0.0) continue;
                for (int i2 = n; i2 < n3; ++i2) {
                    int n4;
                    double d2 = 0.0;
                    for (n4 = n; n4 < n3; ++n4) {
                        d2 -= dArray[i2][n4] * dArray2[n4];
                    }
                    d2 /= this.rDiag[n] * dArray2[n];
                    for (n4 = n; n4 < n3; ++n4) {
                        double[] dArray3 = dArray[i2];
                        int n5 = n4;
                        dArray3[n5] = dArray3[n5] + -d2 * dArray2[n4];
                    }
                }
            }
            this.cachedQT = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedQT;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < FastMath.min(i2 + 1, n); ++i3) {
                    dArray[i2][i3] = this.qrt[i3][i2] / -this.rDiag[i3];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedH;
    }

    public DecompositionSolver getSolver() {
        return new QRDecomposition$Solver(this.qrt, this.rDiag, this.threshold, null);
    }
}

