/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

class QRDecomposition$Solver
implements DecompositionSolver {
    private final double[][] qrt;
    private final double[] rDiag;
    private final double threshold;

    private QRDecomposition$Solver(double[][] dArray, double[] dArray2, double d2) {
        this.qrt = dArray;
        this.rDiag = dArray2;
        this.threshold = d2;
    }

    public boolean isNonSingular() {
        double[] dArray = this.rDiag;
        int n = this.rDiag.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d2;
            double d3 = dArray[i2];
            if (!(FastMath.abs(d2) <= this.threshold)) continue;
            return false;
        }
        return true;
    }

    public RealVector solve(RealVector object) {
        int n;
        int n2;
        int n3 = this.qrt.length;
        int n4 = this.qrt[0].length;
        if (((RealVector)object).getDimension() != n4) {
            throw new DimensionMismatchException(((RealVector)object).getDimension(), n4);
        }
        if (!this.isNonSingular()) {
            throw new SingularMatrixException();
        }
        double[] dArray = new double[n3];
        object = ((RealVector)object).toArray();
        for (n2 = 0; n2 < FastMath.min(n4, n3); ++n2) {
            double[] dArray2 = this.qrt[n2];
            double d2 = 0.0;
            for (n = n2; n < n4; ++n) {
                d2 += object[n] * dArray2[n];
            }
            d2 /= this.rDiag[n2] * dArray2[n2];
            for (n = n2; n < n4; ++n) {
                Object object2 = object;
                int n5 = n;
                object2[n5] = object2[n5] + d2 * dArray2[n];
            }
        }
        for (n2 = this.rDiag.length - 1; n2 >= 0; --n2) {
            Object object3 = object;
            int n6 = n2;
            object3[n6] = object3[n6] / this.rDiag[n2];
            Object object4 = object[n2];
            double[] dArray3 = this.qrt[n2];
            dArray[n2] = (double)object4;
            for (n = 0; n < n2; ++n) {
                Object object5 = object;
                int n7 = n;
                object5[n7] = object5[n7] - object4 * dArray3[n];
            }
        }
        return new ArrayRealVector(dArray, false);
    }

    public RealMatrix solve(RealMatrix realMatrix) {
        int n = this.qrt.length;
        int n2 = this.qrt[0].length;
        if (realMatrix.getRowDimension() != n2) {
            throw new DimensionMismatchException(realMatrix.getRowDimension(), n2);
        }
        if (!this.isNonSingular()) {
            throw new SingularMatrixException();
        }
        int n3 = realMatrix.getColumnDimension();
        int n4 = (n3 + 52 - 1) / 52;
        double[][] dArray = BlockRealMatrix.createBlocksLayout(n, n3);
        double[][] dArray2 = new double[realMatrix.getRowDimension()][52];
        double[] dArray3 = new double[52];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * 52;
            int n6 = FastMath.min(n5 + 52, n3);
            int n7 = n6 - n5;
            realMatrix.copySubMatrix(0, n2 - 1, n5, n6 - 1, dArray2);
            for (n5 = 0; n5 < FastMath.min(n2, n); ++n5) {
                int n8;
                double[] dArray4;
                double d2;
                int n9;
                double[] dArray5 = this.qrt[n5];
                double d3 = 1.0 / (this.rDiag[n5] * dArray5[n5]);
                Arrays.fill(dArray3, 0, n7, 0.0);
                for (n9 = n5; n9 < n2; ++n9) {
                    d2 = dArray5[n9];
                    dArray4 = dArray2[n9];
                    for (n8 = 0; n8 < n7; ++n8) {
                        int n10 = n8;
                        dArray3[n10] = dArray3[n10] + d2 * dArray4[n8];
                    }
                }
                n9 = 0;
                while (n9 < n7) {
                    int n11 = n9++;
                    dArray3[n11] = dArray3[n11] * d3;
                }
                for (n9 = n5; n9 < n2; ++n9) {
                    d2 = dArray5[n9];
                    dArray4 = dArray2[n9];
                    for (n8 = 0; n8 < n7; ++n8) {
                        int n12 = n8;
                        dArray4[n12] = dArray4[n12] + dArray3[n8] * d2;
                    }
                }
            }
            for (n5 = this.rDiag.length - 1; n5 >= 0; --n5) {
                n6 = n5 / 52;
                int n13 = n6 * 52;
                double d4 = 1.0 / this.rDiag[n5];
                double[] dArray6 = dArray2[n5];
                double[] dArray7 = dArray[n6 * n4 + i2];
                int n14 = (n5 - n13) * n7;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n15 = i3;
                    dArray6[n15] = dArray6[n15] * d4;
                    dArray7[n14++] = dArray6[i3];
                }
                double[] dArray8 = this.qrt[n5];
                for (n6 = 0; n6 < n5; ++n6) {
                    double d5 = dArray8[n6];
                    double[] dArray9 = dArray2[n6];
                    for (n13 = 0; n13 < n7; ++n13) {
                        int n16 = n13;
                        dArray9[n16] = dArray9[n16] - dArray6[n13] * d5;
                    }
                }
            }
        }
        return new BlockRealMatrix(n, n3, dArray, false);
    }

    public RealMatrix getInverse() {
        QRDecomposition$Solver qRDecomposition$Solver = this;
        return qRDecomposition$Solver.solve(MatrixUtils.createRealIdentityMatrix(qRDecomposition$Solver.qrt[0].length));
    }

    /* synthetic */ QRDecomposition$Solver(double[][] dArray, double[] dArray2, double d2, QRDecomposition$1 qRDecomposition$1) {
        this(dArray, dArray2, d2);
    }
}

