/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.OpenMapRealVector$OpenMapSparseIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$Entry;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SparseRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToDoubleHashMap;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToDoubleHashMap$Iterator;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMapRealVector
extends SparseRealVector
implements Serializable {
    public static final double DEFAULT_ZERO_TOLERANCE = 1.0E-12;
    private static final long serialVersionUID = 8772222695580707260L;
    private final OpenIntToDoubleHashMap entries;
    private final int virtualSize;
    private final double epsilon;

    public OpenMapRealVector() {
        this(0, 1.0E-12);
    }

    public OpenMapRealVector(int n) {
        this(n, 1.0E-12);
    }

    public OpenMapRealVector(int n, double d2) {
        this.virtualSize = n;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d2;
    }

    protected OpenMapRealVector(OpenMapRealVector openMapRealVector, int n) {
        this.virtualSize = ((RealVector)openMapRealVector).getDimension() + n;
        this.entries = new OpenIntToDoubleHashMap(openMapRealVector.entries);
        this.epsilon = openMapRealVector.epsilon;
    }

    public OpenMapRealVector(int n, int n2) {
        this(n, n2, 1.0E-12);
    }

    public OpenMapRealVector(int n, int n2, double d2) {
        this.virtualSize = n;
        this.entries = new OpenIntToDoubleHashMap(n2, 0.0);
        this.epsilon = d2;
    }

    public OpenMapRealVector(double[] dArray) {
        this(dArray, 1.0E-12);
    }

    public OpenMapRealVector(double[] dArray, double d2) {
        this.virtualSize = dArray.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d2;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = dArray[i2];
            if (this.isDefaultValue(d3)) continue;
            this.entries.put(i2, d3);
        }
    }

    public OpenMapRealVector(Double[] doubleArray) {
        this(doubleArray, 1.0E-12);
    }

    public OpenMapRealVector(Double[] doubleArray, double d2) {
        this.virtualSize = doubleArray.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d2;
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            double d3 = doubleArray[i2];
            if (this.isDefaultValue(d3)) continue;
            this.entries.put(i2, d3);
        }
    }

    public OpenMapRealVector(OpenMapRealVector openMapRealVector) {
        this.virtualSize = ((RealVector)openMapRealVector).getDimension();
        this.entries = new OpenIntToDoubleHashMap(openMapRealVector.getEntries());
        this.epsilon = openMapRealVector.epsilon;
    }

    public OpenMapRealVector(RealVector realVector) {
        this.virtualSize = realVector.getDimension();
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = 1.0E-12;
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            double d2 = realVector.getEntry(i2);
            if (this.isDefaultValue(d2)) continue;
            this.entries.put(i2, d2);
        }
    }

    private OpenIntToDoubleHashMap getEntries() {
        return this.entries;
    }

    protected boolean isDefaultValue(double d2) {
        return FastMath.abs(d2) < this.epsilon;
    }

    @Override
    public RealVector add(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.add((OpenMapRealVector)realVector);
        }
        return super.add(realVector);
    }

    public OpenMapRealVector add(OpenMapRealVector serializable) {
        this.checkVectorDimensions(((RealVector)((Object)serializable)).getDimension());
        int n = this.entries.size() > ((OpenMapRealVector)serializable).entries.size() ? 1 : 0;
        OpenMapRealVector openMapRealVector = n != 0 ? this.copy() : ((OpenMapRealVector)serializable).copy();
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = n != 0 ? ((OpenMapRealVector)serializable).entries.iterator() : this.entries.iterator();
        Serializable serializable2 = serializable = n != 0 ? this.entries : ((OpenMapRealVector)serializable).entries;
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            n = openIntToDoubleHashMap$Iterator.key();
            if (((OpenIntToDoubleHashMap)serializable).containsKey(n)) {
                ((RealVector)openMapRealVector).setEntry(n, ((OpenIntToDoubleHashMap)serializable).get(n) + openIntToDoubleHashMap$Iterator.value());
                continue;
            }
            ((RealVector)openMapRealVector).setEntry(n, openIntToDoubleHashMap$Iterator.value());
        }
        return openMapRealVector;
    }

    public OpenMapRealVector append(OpenMapRealVector object) {
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this, ((RealVector)object).getDimension());
        object = ((OpenMapRealVector)object).entries.iterator();
        while (((OpenIntToDoubleHashMap$Iterator)object).hasNext()) {
            ((OpenIntToDoubleHashMap$Iterator)object).advance();
            ((RealVector)openMapRealVector).setEntry(((OpenIntToDoubleHashMap$Iterator)object).key() + this.virtualSize, ((OpenIntToDoubleHashMap$Iterator)object).value());
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector append(RealVector realVector) {
        if (realVector instanceof OpenMapRealVector) {
            return this.append((OpenMapRealVector)realVector);
        }
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this, realVector.getDimension());
        for (int i2 = 0; i2 < realVector.getDimension(); ++i2) {
            ((RealVector)openMapRealVector).setEntry(i2 + this.virtualSize, realVector.getEntry(i2));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector append(double d2) {
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this, 1);
        ((RealVector)openMapRealVector).setEntry(this.virtualSize, d2);
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector copy() {
        return new OpenMapRealVector(this);
    }

    @Deprecated
    public double dotProduct(OpenMapRealVector openMapRealVector) {
        return this.dotProduct((RealVector)openMapRealVector);
    }

    @Override
    public OpenMapRealVector ebeDivide(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this);
        int n = ((RealVector)this).getDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            ((RealVector)openMapRealVector).setEntry(i2, ((RealVector)this).getEntry(i2) / realVector.getEntry(i2));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector ebeMultiply(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            ((RealVector)openMapRealVector).setEntry(openIntToDoubleHashMap$Iterator.key(), openIntToDoubleHashMap$Iterator.value() * realVector.getEntry(openIntToDoubleHashMap$Iterator.key()));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector getSubVector(int n, int n2) {
        this.checkIndex(n);
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(n + n2 - 1);
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(n2);
        n2 = n + n2;
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            int n3 = openIntToDoubleHashMap$Iterator.key();
            if (n3 < n || n3 >= n2) continue;
            ((RealVector)openMapRealVector).setEntry(n3 - n, openIntToDoubleHashMap$Iterator.value());
        }
        return openMapRealVector;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    public double getDistance(OpenMapRealVector openMapRealVector) {
        double d2;
        int n;
        this.checkVectorDimensions(((RealVector)openMapRealVector).getDimension());
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        double d3 = 0.0;
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            n = openIntToDoubleHashMap$Iterator.key();
            double d4 = d2 = openIntToDoubleHashMap$Iterator.value() - ((RealVector)openMapRealVector).getEntry(n);
            d3 += d4 * d4;
        }
        openIntToDoubleHashMap$Iterator = openMapRealVector.getEntries().iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            n = openIntToDoubleHashMap$Iterator.key();
            if (this.entries.containsKey(n)) continue;
            double d5 = d2 = openIntToDoubleHashMap$Iterator.value();
            d3 += d5 * d5;
        }
        return FastMath.sqrt(d3);
    }

    @Override
    public double getDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getDistance((OpenMapRealVector)realVector);
        }
        return super.getDistance(realVector);
    }

    @Override
    public double getEntry(int n) {
        this.checkIndex(n);
        return this.entries.get(n);
    }

    public double getL1Distance(OpenMapRealVector openMapRealVector) {
        this.checkVectorDimensions(((RealVector)openMapRealVector).getDimension());
        double d2 = 0.0;
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            double d3 = FastMath.abs(openIntToDoubleHashMap$Iterator.value() - ((RealVector)openMapRealVector).getEntry(openIntToDoubleHashMap$Iterator.key()));
            d2 += d3;
        }
        openIntToDoubleHashMap$Iterator = openMapRealVector.getEntries().iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            int n = openIntToDoubleHashMap$Iterator.key();
            if (this.entries.containsKey(n)) continue;
            double d4 = FastMath.abs(openIntToDoubleHashMap$Iterator.value());
            d2 += FastMath.abs(d4);
        }
        return d2;
    }

    @Override
    public double getL1Distance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getL1Distance((OpenMapRealVector)realVector);
        }
        return super.getL1Distance(realVector);
    }

    private double getLInfDistance(OpenMapRealVector openMapRealVector) {
        this.checkVectorDimensions(((RealVector)openMapRealVector).getDimension());
        double d2 = 0.0;
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            double d3;
            openIntToDoubleHashMap$Iterator.advance();
            double d4 = FastMath.abs(openIntToDoubleHashMap$Iterator.value() - ((RealVector)openMapRealVector).getEntry(openIntToDoubleHashMap$Iterator.key()));
            if (!(d3 > d2)) continue;
            d2 = d4;
        }
        openIntToDoubleHashMap$Iterator = openMapRealVector.getEntries().iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            int n = openIntToDoubleHashMap$Iterator.key();
            if (this.entries.containsKey(n) || !(openIntToDoubleHashMap$Iterator.value() > d2)) continue;
            d2 = openIntToDoubleHashMap$Iterator.value();
        }
        return d2;
    }

    @Override
    public double getLInfDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getLInfDistance((OpenMapRealVector)realVector);
        }
        return super.getLInfDistance(realVector);
    }

    @Override
    public boolean isInfinite() {
        boolean bl = false;
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            double d2 = openIntToDoubleHashMap$Iterator.value();
            if (Double.isNaN(d2)) {
                return false;
            }
            if (!Double.isInfinite(d2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isNaN() {
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            if (!Double.isNaN(openIntToDoubleHashMap$Iterator.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OpenMapRealVector mapAdd(double d2) {
        return this.copy().mapAddToSelf(d2);
    }

    @Override
    public OpenMapRealVector mapAddToSelf(double d2) {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            ((RealVector)this).setEntry(i2, ((RealVector)this).getEntry(i2) + d2);
        }
        return this;
    }

    @Override
    public void setEntry(int n, double d2) {
        this.checkIndex(n);
        if (!this.isDefaultValue(d2)) {
            this.entries.put(n, d2);
            return;
        }
        if (this.entries.containsKey(n)) {
            this.entries.remove(n);
        }
    }

    @Override
    public void setSubVector(int n, RealVector realVector) {
        this.checkIndex(n);
        this.checkIndex(n + realVector.getDimension() - 1);
        for (int i2 = 0; i2 < realVector.getDimension(); ++i2) {
            ((RealVector)this).setEntry(i2 + n, realVector.getEntry(i2));
        }
    }

    @Override
    public void set(double d2) {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            ((RealVector)this).setEntry(i2, d2);
        }
    }

    public OpenMapRealVector subtract(OpenMapRealVector object) {
        this.checkVectorDimensions(((RealVector)object).getDimension());
        OpenMapRealVector openMapRealVector = this.copy();
        object = ((OpenMapRealVector)object).getEntries().iterator();
        while (((OpenIntToDoubleHashMap$Iterator)object).hasNext()) {
            ((OpenIntToDoubleHashMap$Iterator)object).advance();
            int n = ((OpenIntToDoubleHashMap$Iterator)object).key();
            if (this.entries.containsKey(n)) {
                ((RealVector)openMapRealVector).setEntry(n, this.entries.get(n) - ((OpenIntToDoubleHashMap$Iterator)object).value());
                continue;
            }
            ((RealVector)openMapRealVector).setEntry(n, -((OpenIntToDoubleHashMap$Iterator)object).value());
        }
        return openMapRealVector;
    }

    @Override
    public RealVector subtract(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.subtract((OpenMapRealVector)realVector);
        }
        return super.subtract(realVector);
    }

    @Override
    public OpenMapRealVector unitVector() {
        OpenMapRealVector openMapRealVector = this.copy();
        ((RealVector)openMapRealVector).unitize();
        return openMapRealVector;
    }

    @Override
    public void unitize() {
        double d2 = this.getNorm();
        if (this.isDefaultValue(d2)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            this.entries.put(openIntToDoubleHashMap$Iterator.key(), openIntToDoubleHashMap$Iterator.value() / d2);
        }
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.virtualSize];
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            dArray[openIntToDoubleHashMap$Iterator.key()] = openIntToDoubleHashMap$Iterator.value();
        }
        return dArray;
    }

    @Override
    public int hashCode() {
        long l;
        long l2 = l = Double.doubleToLongBits(this.epsilon);
        int n = 31 + (int)(l2 ^ l2 >>> 32);
        n = n * 31 + this.virtualSize;
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            long l3 = l = Double.doubleToLongBits(openIntToDoubleHashMap$Iterator.value());
            n = n * 31 + (int)(l3 ^ l3 >> 32);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        double d2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof OpenMapRealVector)) {
            return false;
        }
        object = (OpenMapRealVector)object;
        if (this.virtualSize != ((OpenMapRealVector)object).virtualSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.epsilon) != Double.doubleToLongBits(((OpenMapRealVector)object).epsilon)) {
            return false;
        }
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            d2 = ((RealVector)object).getEntry(openIntToDoubleHashMap$Iterator.key());
            if (Double.doubleToLongBits(d2) == Double.doubleToLongBits(openIntToDoubleHashMap$Iterator.value())) continue;
            return false;
        }
        openIntToDoubleHashMap$Iterator = super.getEntries().iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            d2 = openIntToDoubleHashMap$Iterator.value();
            if (Double.doubleToLongBits(d2) == Double.doubleToLongBits(((RealVector)this).getEntry(openIntToDoubleHashMap$Iterator.key()))) continue;
            return false;
        }
        return true;
    }

    public double getSparsity() {
        return (double)this.entries.size() / (double)((RealVector)this).getDimension();
    }

    @Override
    public Iterator<RealVector$Entry> sparseIterator() {
        return new OpenMapRealVector$OpenMapSparseIterator(this);
    }

    static /* synthetic */ OpenIntToDoubleHashMap access$000(OpenMapRealVector openMapRealVector) {
        return openMapRealVector.entries;
    }
}

