/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AnyMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SparseRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToDoubleHashMap;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToDoubleHashMap$Iterator;
import java.io.Serializable;

public class OpenMapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix,
Serializable {
    private static final long serialVersionUID = -5962461716457143437L;
    private final int rows;
    private final int columns;
    private final OpenIntToDoubleHashMap entries;

    public OpenMapRealMatrix(int n, int n2) {
        super(n, n2);
        long l = n;
        long l2 = n2;
        if (l * l2 >= Integer.MAX_VALUE) {
            throw new NumberIsTooLargeException(l * l2, (Number)Integer.MAX_VALUE, false);
        }
        this.rows = n;
        this.columns = n2;
        this.entries = new OpenIntToDoubleHashMap(0.0);
    }

    public OpenMapRealMatrix(OpenMapRealMatrix openMapRealMatrix) {
        this.rows = openMapRealMatrix.rows;
        this.columns = openMapRealMatrix.columns;
        this.entries = new OpenIntToDoubleHashMap(openMapRealMatrix.entries);
    }

    public OpenMapRealMatrix copy() {
        return new OpenMapRealMatrix(this);
    }

    public OpenMapRealMatrix createMatrix(int n, int n2) {
        return new OpenMapRealMatrix(n, n2);
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public OpenMapRealMatrix add(OpenMapRealMatrix object) {
        MatrixUtils.checkAdditionCompatible(this, (AnyMatrix)object);
        OpenMapRealMatrix openMapRealMatrix = new OpenMapRealMatrix(this);
        object = ((OpenMapRealMatrix)object).entries.iterator();
        while (((OpenIntToDoubleHashMap$Iterator)object).hasNext()) {
            ((OpenIntToDoubleHashMap$Iterator)object).advance();
            int n = ((OpenIntToDoubleHashMap$Iterator)object).key() / this.columns;
            int n2 = ((OpenIntToDoubleHashMap$Iterator)object).key() - n * this.columns;
            ((AbstractRealMatrix)openMapRealMatrix).setEntry(n, n2, ((AbstractRealMatrix)this).getEntry(n, n2) + ((OpenIntToDoubleHashMap$Iterator)object).value());
        }
        return openMapRealMatrix;
    }

    public OpenMapRealMatrix subtract(RealMatrix realMatrix) {
        try {
            return this.subtract((OpenMapRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            return (OpenMapRealMatrix)super.subtract(realMatrix);
        }
    }

    public OpenMapRealMatrix subtract(OpenMapRealMatrix object) {
        MatrixUtils.checkAdditionCompatible(this, (AnyMatrix)object);
        OpenMapRealMatrix openMapRealMatrix = new OpenMapRealMatrix(this);
        object = ((OpenMapRealMatrix)object).entries.iterator();
        while (((OpenIntToDoubleHashMap$Iterator)object).hasNext()) {
            ((OpenIntToDoubleHashMap$Iterator)object).advance();
            int n = ((OpenIntToDoubleHashMap$Iterator)object).key() / this.columns;
            int n2 = ((OpenIntToDoubleHashMap$Iterator)object).key() - n * this.columns;
            ((AbstractRealMatrix)openMapRealMatrix).setEntry(n, n2, ((AbstractRealMatrix)this).getEntry(n, n2) - ((OpenIntToDoubleHashMap$Iterator)object).value());
        }
        return openMapRealMatrix;
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        try {
            return this.multiply((OpenMapRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
            int n = realMatrix.getColumnDimension();
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, n);
            OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
            while (openIntToDoubleHashMap$Iterator.hasNext()) {
                openIntToDoubleHashMap$Iterator.advance();
                double d2 = openIntToDoubleHashMap$Iterator.value();
                int n2 = openIntToDoubleHashMap$Iterator.key();
                int n3 = n2 / this.columns;
                n2 %= this.columns;
                for (int i2 = 0; i2 < n; ++i2) {
                    ((AbstractRealMatrix)blockRealMatrix).addToEntry(n3, i2, d2 * realMatrix.getEntry(n2, i2));
                }
            }
            return blockRealMatrix;
        }
    }

    public OpenMapRealMatrix multiply(OpenMapRealMatrix openMapRealMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, openMapRealMatrix);
        int n = ((RealLinearOperator)openMapRealMatrix).getColumnDimension();
        OpenMapRealMatrix openMapRealMatrix2 = new OpenMapRealMatrix(this.rows, n);
        OpenIntToDoubleHashMap$Iterator openIntToDoubleHashMap$Iterator = this.entries.iterator();
        while (openIntToDoubleHashMap$Iterator.hasNext()) {
            openIntToDoubleHashMap$Iterator.advance();
            double d2 = openIntToDoubleHashMap$Iterator.value();
            int n2 = openIntToDoubleHashMap$Iterator.key();
            int n3 = n2 / this.columns;
            n2 %= this.columns;
            for (int i2 = 0; i2 < n; ++i2) {
                int n4 = openMapRealMatrix.computeKey(n2, i2);
                if (!openMapRealMatrix.entries.containsKey(n4)) continue;
                int n5 = openMapRealMatrix2.computeKey(n3, i2);
                double d3 = openMapRealMatrix2.entries.get(n5) + d2 * openMapRealMatrix.entries.get(n4);
                if (d3 == 0.0) {
                    openMapRealMatrix2.entries.remove(n5);
                    continue;
                }
                openMapRealMatrix2.entries.put(n5, d3);
            }
        }
        return openMapRealMatrix2;
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        return this.entries.get(this.computeKey(n, n2));
    }

    public int getRowDimension() {
        return this.rows;
    }

    public void setEntry(int n, int n2, double d2) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        if (d2 == 0.0) {
            this.entries.remove(this.computeKey(n, n2));
            return;
        }
        this.entries.put(this.computeKey(n, n2), d2);
    }

    public void addToEntry(int n, int n2, double d2) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        n = this.computeKey(n, n2);
        double d3 = this.entries.get(n) + d2;
        if (d3 == 0.0) {
            this.entries.remove(n);
            return;
        }
        this.entries.put(n, d3);
    }

    public void multiplyEntry(int n, int n2, double d2) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        n = this.computeKey(n, n2);
        double d3 = this.entries.get(n) * d2;
        if (d3 == 0.0) {
            this.entries.remove(n);
            return;
        }
        this.entries.put(n, d3);
    }

    private int computeKey(int n, int n2) {
        return n * this.columns + n2;
    }
}

