/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.Fraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AnyMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DiagonalMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixDimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils$BigFractionMatrixConverter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils$FractionMatrixConverter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSymmetricMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularValueDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixUtils {
    public static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getInstance();
    public static final RealMatrixFormat OCTAVE_FORMAT = new RealMatrixFormat("[", "]", "", "", "; ", ", ");

    private MatrixUtils() {
    }

    public static RealMatrix createRealMatrix(int n, int n2) {
        if (n * n2 <= 4096) {
            return new Array2DRowRealMatrix(n, n2);
        }
        return new BlockRealMatrix(n, n2);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(Field<T> field, int n, int n2) {
        if (n * n2 <= 4096) {
            return new Array2DRowFieldMatrix<T>(field, n, n2);
        }
        return new BlockFieldMatrix<T>(field, n, n2);
    }

    public static RealMatrix createRealMatrix(double[][] dArray) {
        if (dArray == null || dArray[0] == null) {
            throw new NullArgumentException();
        }
        if (dArray.length * dArray[0].length <= 4096) {
            return new Array2DRowRealMatrix(dArray);
        }
        return new BlockRealMatrix(dArray);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(T[][] TArray) {
        if (TArray == null || TArray[0] == null) {
            throw new NullArgumentException();
        }
        if (TArray.length * TArray[0].length <= 4096) {
            return new Array2DRowFieldMatrix(TArray);
        }
        return new BlockFieldMatrix(TArray);
    }

    public static RealMatrix createRealIdentityMatrix(int n) {
        int n2 = n;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n2, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            realMatrix.setEntry(n4, n4, 1.0);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldIdentityMatrix(Field<T> field, int n) {
        FieldElement fieldElement = (FieldElement)field.getZero();
        FieldElement fieldElement2 = (FieldElement)field.getOne();
        int n2 = n;
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n2, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            Object[] objectArray = fieldElementArray[i2];
            Arrays.fill(objectArray, fieldElement);
            objectArray[i2] = fieldElement2;
        }
        return new Array2DRowFieldMatrix(field, fieldElementArray, false);
    }

    public static RealMatrix createRealDiagonalMatrix(double[] dArray) {
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(dArray.length, dArray.length);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            realMatrix.setEntry(n, n, dArray[i2]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldDiagonalMatrix(T[] TArray) {
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), TArray.length, TArray.length);
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            int n = i2;
            fieldMatrix.setEntry(n, n, TArray[i2]);
        }
        return fieldMatrix;
    }

    public static RealVector createRealVector(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        return new ArrayRealVector(dArray, true);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        if (TArray.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        return new ArrayFieldVector(TArray[0].getField(), TArray, true);
    }

    public static RealMatrix createRowRealMatrix(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(1, n);
        for (int i2 = 0; i2 < n; ++i2) {
            realMatrix.setEntry(0, i2, dArray[i2]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createRowFieldMatrix(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n = TArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), 1, n);
        for (int i2 = 0; i2 < n; ++i2) {
            fieldMatrix.setEntry(0, i2, TArray[i2]);
        }
        return fieldMatrix;
    }

    public static RealMatrix createColumnRealMatrix(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, 1);
        for (int i2 = 0; i2 < n; ++i2) {
            realMatrix.setEntry(i2, 0, dArray[i2]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createColumnFieldMatrix(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n = TArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), n, 1);
        for (int i2 = 0; i2 < n; ++i2) {
            fieldMatrix.setEntry(i2, 0, TArray[i2]);
        }
        return fieldMatrix;
    }

    private static boolean isSymmetricInternal(RealMatrix realMatrix, double d2, boolean bl) {
        int n = realMatrix.getRowDimension();
        if (n != realMatrix.getColumnDimension()) {
            if (bl) {
                throw new NonSquareMatrixException(n, realMatrix.getColumnDimension());
            }
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = i2 + 1; i3 < n; ++i3) {
                double d3;
                double d4 = realMatrix.getEntry(i2, i3);
                if (!(FastMath.abs(d4 - (d3 = realMatrix.getEntry(i3, i2))) > FastMath.max(FastMath.abs(d4), FastMath.abs(d3)) * d2)) continue;
                if (bl) {
                    throw new NonSymmetricMatrixException(i2, i3, d2);
                }
                return false;
            }
        }
        return true;
    }

    public static void checkSymmetric(RealMatrix realMatrix, double d2) {
        MatrixUtils.isSymmetricInternal(realMatrix, d2, true);
    }

    public static boolean isSymmetric(RealMatrix realMatrix, double d2) {
        return MatrixUtils.isSymmetricInternal(realMatrix, d2, false);
    }

    public static void checkMatrixIndex(AnyMatrix anyMatrix, int n, int n2) {
        MatrixUtils.checkRowIndex(anyMatrix, n);
        MatrixUtils.checkColumnIndex(anyMatrix, n2);
    }

    public static void checkRowIndex(AnyMatrix anyMatrix, int n) {
        if (n < 0 || n >= anyMatrix.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)n, 0, anyMatrix.getRowDimension() - 1);
        }
    }

    public static void checkColumnIndex(AnyMatrix anyMatrix, int n) {
        if (n < 0 || n >= anyMatrix.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)n, 0, anyMatrix.getColumnDimension() - 1);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix anyMatrix, int n, int n2, int n3, int n4) {
        MatrixUtils.checkRowIndex(anyMatrix, n);
        MatrixUtils.checkRowIndex(anyMatrix, n2);
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
        MatrixUtils.checkColumnIndex(anyMatrix, n3);
        MatrixUtils.checkColumnIndex(anyMatrix, n4);
        if (n4 < n3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)n4, n3, false);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix anyMatrix, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new NullArgumentException();
        }
        if (nArray2 == null) {
            throw new NullArgumentException();
        }
        if (nArray.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY);
        }
        if (nArray2.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY);
        }
        for (int n2 : nArray) {
            MatrixUtils.checkRowIndex(anyMatrix, n2);
        }
        nArray = nArray2;
        int n = nArray2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2;
            n2 = nArray[i2];
            MatrixUtils.checkColumnIndex(anyMatrix, n2);
        }
    }

    public static void checkAdditionCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getRowDimension() != anyMatrix2.getRowDimension() || anyMatrix.getColumnDimension() != anyMatrix2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(anyMatrix.getRowDimension(), anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension(), anyMatrix2.getColumnDimension());
        }
    }

    public static void checkSubtractionCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getRowDimension() != anyMatrix2.getRowDimension() || anyMatrix.getColumnDimension() != anyMatrix2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(anyMatrix.getRowDimension(), anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension(), anyMatrix2.getColumnDimension());
        }
    }

    public static void checkMultiplicationCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getColumnDimension() != anyMatrix2.getRowDimension()) {
            throw new DimensionMismatchException(anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension());
        }
    }

    public static Array2DRowRealMatrix fractionMatrixToRealMatrix(FieldMatrix<Fraction> fieldMatrix) {
        MatrixUtils$FractionMatrixConverter matrixUtils$FractionMatrixConverter = new MatrixUtils$FractionMatrixConverter();
        fieldMatrix.walkInOptimizedOrder(matrixUtils$FractionMatrixConverter);
        return matrixUtils$FractionMatrixConverter.getConvertedMatrix();
    }

    public static Array2DRowRealMatrix bigFractionMatrixToRealMatrix(FieldMatrix<BigFraction> fieldMatrix) {
        MatrixUtils$BigFractionMatrixConverter matrixUtils$BigFractionMatrixConverter = new MatrixUtils$BigFractionMatrixConverter();
        fieldMatrix.walkInOptimizedOrder(matrixUtils$BigFractionMatrixConverter);
        return matrixUtils$BigFractionMatrixConverter.getConvertedMatrix();
    }

    public static void serializeRealVector(RealVector realVector, ObjectOutputStream objectOutputStream) {
        int n = realVector.getDimension();
        objectOutputStream.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            objectOutputStream.writeDouble(realVector.getEntry(i2));
        }
    }

    public static void deserializeRealVector(Object object, String object2, ObjectInputStream objectInputStream) {
        try {
            int n = objectInputStream.readInt();
            double[] dArray = new double[n];
            for (int i2 = 0; i2 < n; ++i2) {
                dArray[i2] = objectInputStream.readDouble();
            }
            ArrayRealVector arrayRealVector = new ArrayRealVector(dArray, false);
            object2 = object.getClass().getDeclaredField((String)object2);
            ((java.lang.reflect.Field)object2).setAccessible(true);
            ((java.lang.reflect.Field)object2).set(object, arrayRealVector);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchFieldException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException();
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
    }

    public static void serializeRealMatrix(RealMatrix realMatrix, ObjectOutputStream objectOutputStream) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                objectOutputStream.writeDouble(realMatrix.getEntry(i2, i3));
            }
        }
    }

    public static void deserializeRealMatrix(Object object, String string, ObjectInputStream objectInputStream) {
        try {
            Object object2;
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            double[][] dArray = new double[n][n2];
            for (int i2 = 0; i2 < n; ++i2) {
                object2 = dArray[i2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    object2[i3] = objectInputStream.readDouble();
                }
            }
            Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray, false);
            java.lang.reflect.Field field = object.getClass().getDeclaredField(string);
            object2 = field;
            field.setAccessible(true);
            ((java.lang.reflect.Field)object2).set(object, array2DRowRealMatrix);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchFieldException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException();
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
    }

    public static void solveLowerTriangularSystem(RealMatrix realMatrix, RealVector realVector) {
        if (realMatrix == null || realVector == null || realMatrix.getRowDimension() != realVector.getDimension()) {
            throw new DimensionMismatchException(realMatrix == null ? 0 : realMatrix.getRowDimension(), realVector == null ? 0 : realVector.getDimension());
        }
        if (realMatrix.getColumnDimension() != realMatrix.getRowDimension()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        for (int i2 = 0; i2 < n; ++i2) {
            double d2;
            int n2 = i2;
            double d3 = realMatrix.getEntry(n2, n2);
            if (FastMath.abs(d2) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double d4 = realVector.getEntry(i2) / d3;
            realVector.setEntry(i2, d4);
            for (int i3 = i2 + 1; i3 < n; ++i3) {
                realVector.setEntry(i3, realVector.getEntry(i3) - d4 * realMatrix.getEntry(i3, i2));
            }
        }
    }

    public static void solveUpperTriangularSystem(RealMatrix realMatrix, RealVector realVector) {
        if (realMatrix == null || realVector == null || realMatrix.getRowDimension() != realVector.getDimension()) {
            throw new DimensionMismatchException(realMatrix == null ? 0 : realMatrix.getRowDimension(), realVector == null ? 0 : realVector.getDimension());
        }
        if (realMatrix.getColumnDimension() != realMatrix.getRowDimension()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        --n;
        while (n >= 0) {
            double d2;
            int n2 = n;
            double d3 = realMatrix.getEntry(n2, n2);
            if (FastMath.abs(d2) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double d4 = realVector.getEntry(n) / d3;
            realVector.setEntry(n, d4);
            for (int i2 = n - 1; i2 >= 0; --i2) {
                realVector.setEntry(i2, realVector.getEntry(i2) - d4 * realMatrix.getEntry(i2, n));
            }
            --n;
        }
    }

    public static RealMatrix blockInverse(RealMatrix object, int n) {
        int n2 = object.getRowDimension();
        if (object.getColumnDimension() != n2) {
            throw new NonSquareMatrixException(object.getRowDimension(), object.getColumnDimension());
        }
        int n3 = n + 1;
        Object object2 = object.getSubMatrix(0, n, 0, n);
        RealMatrix realMatrix = object.getSubMatrix(0, n, n3, n2 - 1);
        RealMatrix realMatrix2 = object.getSubMatrix(n3, n2 - 1, 0, n);
        object = object.getSubMatrix(n3, n2 - 1, n3, n2 - 1);
        Object object3 = new SingularValueDecomposition((RealMatrix)object2);
        if (!(object3 = ((SingularValueDecomposition)object3).getSolver()).isNonSingular()) {
            throw new SingularMatrixException();
        }
        object3 = object3.getInverse();
        Object object4 = new SingularValueDecomposition((RealMatrix)object);
        if (!(object4 = ((SingularValueDecomposition)object4).getSolver()).isNonSingular()) {
            throw new SingularMatrixException();
        }
        object4 = object4.getInverse();
        object2 = object2.subtract(realMatrix.multiply((RealMatrix)object4).multiply(realMatrix2));
        object2 = new SingularValueDecomposition((RealMatrix)object2);
        if (!(object2 = ((SingularValueDecomposition)object2).getSolver()).isNonSingular()) {
            throw new SingularMatrixException();
        }
        object2 = object2.getInverse();
        object = object.subtract(realMatrix2.multiply((RealMatrix)object3).multiply(realMatrix));
        object = new SingularValueDecomposition((RealMatrix)object);
        if (!(object = ((SingularValueDecomposition)object).getSolver()).isNonSingular()) {
            throw new SingularMatrixException();
        }
        object = object.getInverse();
        realMatrix = object3.multiply(realMatrix).multiply((RealMatrix)object).scalarMultiply(-1.0);
        realMatrix2 = object4.multiply(realMatrix2).multiply((RealMatrix)object2).scalarMultiply(-1.0);
        int n4 = n2;
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n4, n4);
        array2DRowRealMatrix.setSubMatrix(object2.getData(), 0, 0);
        array2DRowRealMatrix.setSubMatrix(realMatrix.getData(), 0, n3);
        array2DRowRealMatrix.setSubMatrix(realMatrix2.getData(), n3, 0);
        int n5 = n3;
        array2DRowRealMatrix.setSubMatrix(object.getData(), n5, n5);
        return array2DRowRealMatrix;
    }

    public static RealMatrix inverse(RealMatrix realMatrix) {
        return MatrixUtils.inverse(realMatrix, 0.0);
    }

    public static RealMatrix inverse(RealMatrix object, double d2) {
        MathUtils.checkNotNull(object);
        if (!object.isSquare()) {
            throw new NonSquareMatrixException(object.getRowDimension(), object.getColumnDimension());
        }
        if (object instanceof DiagonalMatrix) {
            return ((DiagonalMatrix)object).inverse(d2);
        }
        object = new QRDecomposition((RealMatrix)object, d2);
        return ((QRDecomposition)object).getSolver().getInverse();
    }
}

