/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.LUDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class LUDecomposition {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;
    private final double[][] lu;
    private final int[] pivot;
    private boolean even;
    private boolean singular;
    private RealMatrix cachedL;
    private RealMatrix cachedU;
    private RealMatrix cachedP;

    public LUDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 1.0E-11);
    }

    public LUDecomposition(RealMatrix realMatrix, double d2) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getColumnDimension();
        this.lu = realMatrix.getData();
        this.pivot = new int[n];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.pivot[n3] = n3;
        }
        this.even = true;
        this.singular = false;
        for (n2 = 0; n2 < n; ++n2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                double[] dArray = this.lu[n5];
                double d3 = dArray[n2];
                for (int i2 = 0; i2 < n5; ++i2) {
                    d3 -= dArray[i2] * this.lu[i2][n2];
                }
                dArray[n2] = d3;
            }
            n5 = n2;
            double d4 = Double.NEGATIVE_INFINITY;
            for (int i3 = n2; i3 < n; ++i3) {
                double[] dArray = this.lu[i3];
                double d5 = dArray[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    d5 -= dArray[n4] * this.lu[n4][n2];
                }
                dArray[n2] = d5;
                if (!(FastMath.abs(d5) > d4)) continue;
                d4 = FastMath.abs(d5);
                n5 = i3;
            }
            if (FastMath.abs(this.lu[n5][n2]) < d2) {
                this.singular = true;
                return;
            }
            if (n5 != n2) {
                double[] dArray = this.lu[n5];
                double[] dArray2 = this.lu[n2];
                for (n4 = 0; n4 < n; ++n4) {
                    double d6 = dArray[n4];
                    dArray[n4] = dArray2[n4];
                    dArray2[n4] = d6;
                }
                n4 = this.pivot[n5];
                this.pivot[n5] = this.pivot[n2];
                this.pivot[n2] = n4;
                this.even = !this.even;
            }
            double d7 = this.lu[n2][n2];
            for (int i4 = n2 + 1; i4 < n; ++i4) {
                double[] dArray = this.lu[i4];
                int n6 = n2;
                dArray[n6] = dArray[n6] / d7;
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedL = MatrixUtils.createRealMatrix(n2, n2);
            int n3 = 0;
            while (n3 < n) {
                double[] dArray = this.lu[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.cachedL.setEntry(n3, i2, dArray[i2]);
                }
                int n4 = n3++;
                this.cachedL.setEntry(n4, n4, 1.0);
            }
        }
        return this.cachedL;
    }

    public RealMatrix getU() {
        if (this.cachedU == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedU = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                double[] dArray = this.lu[i2];
                for (int i3 = i2; i3 < n; ++i3) {
                    this.cachedU.setEntry(i2, i3, dArray[i3]);
                }
            }
        }
        return this.cachedU;
    }

    public RealMatrix getP() {
        if (this.cachedP == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedP = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                this.cachedP.setEntry(i2, this.pivot[i2], 1.0);
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public double getDeterminant() {
        if (this.singular) {
            return 0.0;
        }
        int n = this.pivot.length;
        double d2 = this.even ? 1.0 : -1.0;
        for (int i2 = 0; i2 < n; ++i2) {
            d2 *= this.lu[i2][i2];
        }
        return d2;
    }

    public DecompositionSolver getSolver() {
        return new LUDecomposition$Solver(this.lu, this.pivot, this.singular, null);
    }
}

