/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.LUDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;

class LUDecomposition$Solver
implements DecompositionSolver {
    private final double[][] lu;
    private final int[] pivot;
    private final boolean singular;

    private LUDecomposition$Solver(double[][] dArray, int[] nArray, boolean bl) {
        this.lu = dArray;
        this.pivot = nArray;
        this.singular = bl;
    }

    public boolean isNonSingular() {
        return !this.singular;
    }

    public RealVector solve(RealVector realVector) {
        double d2;
        int n;
        int n2 = this.pivot.length;
        if (realVector.getDimension() != n2) {
            throw new DimensionMismatchException(realVector.getDimension(), n2);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = realVector.getEntry(this.pivot[n]);
        }
        for (n = 0; n < n2; ++n) {
            d2 = dArray[n];
            for (int i2 = n + 1; i2 < n2; ++i2) {
                int n3 = i2;
                dArray[n3] = dArray[n3] - d2 * this.lu[i2][n];
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            int n4 = n;
            dArray[n4] = dArray[n4] / this.lu[n][n];
            d2 = dArray[n];
            for (int i3 = 0; i3 < n; ++i3) {
                int n5 = i3;
                dArray[n5] = dArray[n5] - d2 * this.lu[i3][n];
            }
        }
        return new ArrayRealVector(dArray, false);
    }

    public RealMatrix solve(RealMatrix realMatrix) {
        int n;
        double[] dArray;
        int n2;
        int n3 = this.pivot.length;
        if (realMatrix.getRowDimension() != n3) {
            throw new DimensionMismatchException(realMatrix.getRowDimension(), n3);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        int n4 = realMatrix.getColumnDimension();
        double[][] dArray2 = new double[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray = dArray2[n2];
            n = this.pivot[n2];
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray[i2] = realMatrix.getEntry(n, i2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray = dArray2[n2];
            for (n = n2 + 1; n < n3; ++n) {
                double[] dArray3 = dArray2[n];
                double d2 = this.lu[n][n2];
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = i3;
                    dArray3[n5] = dArray3[n5] - dArray[i3] * d2;
                }
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            dArray = dArray2[n2];
            double d3 = this.lu[n2][n2];
            int n6 = 0;
            while (n6 < n4) {
                int n7 = n6++;
                dArray[n7] = dArray[n7] / d3;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                double[] dArray4 = dArray2[n6];
                double d4 = this.lu[n6][n2];
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n8 = i4;
                    dArray4[n8] = dArray4[n8] - dArray[i4] * d4;
                }
            }
        }
        return new Array2DRowRealMatrix(dArray2, false);
    }

    public RealMatrix getInverse() {
        LUDecomposition$Solver lUDecomposition$Solver = this;
        return lUDecomposition$Solver.solve(MatrixUtils.createRealIdentityMatrix(lUDecomposition$Solver.pivot.length));
    }

    /* synthetic */ LUDecomposition$Solver(double[][] dArray, int[] nArray, boolean bl, LUDecomposition$1 lUDecomposition$1) {
        this(dArray, nArray, bl);
    }
}

