/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Sqrt;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.JacobiPreconditioner$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class JacobiPreconditioner
extends RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] dArray, boolean bl) {
        this.diag = new ArrayRealVector(dArray, bl);
    }

    public static JacobiPreconditioner create(RealLinearOperator realLinearOperator) {
        int n = realLinearOperator.getColumnDimension();
        if (realLinearOperator.getRowDimension() != n) {
            throw new NonSquareOperatorException(realLinearOperator.getRowDimension(), n);
        }
        double[] dArray = new double[n];
        if (realLinearOperator instanceof AbstractRealMatrix) {
            AbstractRealMatrix abstractRealMatrix = (AbstractRealMatrix)realLinearOperator;
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = i2;
                dArray[i2] = abstractRealMatrix.getEntry(n2, n2);
            }
        } else {
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            for (int i3 = 0; i3 < n; ++i3) {
                ((RealVector)arrayRealVector).set(0.0);
                ((RealVector)arrayRealVector).setEntry(i3, 1.0);
                dArray[i3] = realLinearOperator.operate(arrayRealVector).getEntry(i3);
            }
        }
        return new JacobiPreconditioner(dArray, false);
    }

    public int getColumnDimension() {
        return ((RealVector)this.diag).getDimension();
    }

    public int getRowDimension() {
        return ((RealVector)this.diag).getDimension();
    }

    public RealVector operate(RealVector realVector) {
        return new ArrayRealVector(MathArrays.ebeDivide(realVector.toArray(), ((RealVector)this.diag).toArray()), false);
    }

    public RealLinearOperator sqrt() {
        ArrayRealVector arrayRealVector = this.diag.map(new Sqrt());
        return new JacobiPreconditioner$1(this, arrayRealVector);
    }
}

