/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

class HessenbergTransformer {
    private final double[][] householderVectors;
    private final double[] ort;
    private RealMatrix cachedP;
    private RealMatrix cachedPt;
    private RealMatrix cachedH;

    HessenbergTransformer(RealMatrix realMatrix) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        this.householderVectors = realMatrix.getData();
        this.ort = new double[n];
        this.cachedP = null;
        this.cachedPt = null;
        this.cachedH = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int n;
            int n2;
            int n3 = this.householderVectors.length;
            int n4 = n3 - 1;
            int n5 = n3;
            double[][] dArray = new double[n5][n5];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    dArray[n2][n] = n2 == n ? 1.0 : 0.0;
                }
            }
            for (n2 = n4 - 1; n2 > 0; --n2) {
                if (this.householderVectors[n2][n2 - 1] == 0.0) continue;
                for (n = n2 + 1; n <= n4; ++n) {
                    this.ort[n] = this.householderVectors[n][n2 - 1];
                }
                for (n = n2; n <= n4; ++n) {
                    double d2 = 0.0;
                    for (n3 = n2; n3 <= n4; ++n3) {
                        d2 += this.ort[n3] * dArray[n3][n];
                    }
                    d2 = d2 / this.ort[n2] / this.householderVectors[n2][n2 - 1];
                    for (n3 = n2; n3 <= n4; ++n3) {
                        double[] dArray2 = dArray[n3];
                        int n6 = n;
                        dArray2[n6] = dArray2[n6] + d2 * this.ort[n3];
                    }
                }
            }
            this.cachedP = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.householderVectors.length;
            double[][] dArray = new double[n][n];
            for (int i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    dArray[i2][i2 - 1] = this.householderVectors[i2][i2 - 1];
                }
                for (int i3 = i2; i3 < n; ++i3) {
                    dArray[i2][i3] = this.householderVectors[i2][i3];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedH;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    private void transform() {
        int n = this.householderVectors.length;
        int n2 = n - 1;
        for (int i2 = 1; i2 <= n2 - 1; ++i2) {
            int n3;
            double d2;
            int n4;
            double d3 = 0.0;
            for (int i3 = i2; i3 <= n2; ++i3) {
                d3 += FastMath.abs(this.householderVectors[i3][i2 - 1]);
            }
            if (Precision.equals(d3, 0.0)) continue;
            double d4 = 0.0;
            for (int i4 = n2; i4 >= i2; --i4) {
                this.ort[i4] = this.householderVectors[i4][i2 - 1] / d3;
                d4 += this.ort[i4] * this.ort[i4];
            }
            double d5 = this.ort[i2] > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            d4 -= this.ort[i2] * d5;
            int n5 = i2;
            this.ort[n5] = this.ort[n5] - d5;
            for (n4 = i2; n4 < n; ++n4) {
                d2 = 0.0;
                for (n3 = n2; n3 >= i2; --n3) {
                    d2 += this.ort[n3] * this.householderVectors[n3][n4];
                }
                d2 /= d4;
                for (n3 = i2; n3 <= n2; ++n3) {
                    double[] dArray = this.householderVectors[n3];
                    int n6 = n4;
                    dArray[n6] = dArray[n6] - d2 * this.ort[n3];
                }
            }
            for (n4 = 0; n4 <= n2; ++n4) {
                d2 = 0.0;
                for (n3 = n2; n3 >= i2; --n3) {
                    d2 += this.ort[n3] * this.householderVectors[n4][n3];
                }
                d2 /= d4;
                for (n3 = i2; n3 <= n2; ++n3) {
                    double[] dArray = this.householderVectors[n4];
                    int n7 = n3;
                    dArray[n7] = dArray[n7] - d2 * this.ort[n3];
                }
            }
            this.ort[i2] = d3 * this.ort[i2];
            this.householderVectors[i2][i2 - 1] = d3 * d5;
        }
    }
}

