/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldDecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldLUDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldLUDecomposition<T extends FieldElement<T>> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecomposition(FieldMatrix<T> fieldMatrix) {
        if (!fieldMatrix.isSquare()) {
            throw new NonSquareMatrixException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension());
        }
        int n = fieldMatrix.getColumnDimension();
        this.field = fieldMatrix.getField();
        this.lu = fieldMatrix.getData();
        this.pivot = new int[n];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.pivot[n3] = n3;
        }
        this.even = true;
        this.singular = false;
        for (n2 = 0; n2 < n; ++n2) {
            int n4;
            Object object;
            Object object2;
            int n5;
            FieldElement cfr_ignored_0 = (FieldElement)this.field.getZero();
            for (n5 = 0; n5 < n2; ++n5) {
                object2 = this.lu[n5];
                object = object2[n2];
                for (n4 = 0; n4 < n5; ++n4) {
                    object = (FieldElement)object.subtract(object2[n4].multiply(this.lu[n4][n2]));
                }
                object2[n2] = object;
            }
            n5 = n2;
            for (int i2 = n2; i2 < n; ++i2) {
                T[] TArray = this.lu[i2];
                object = TArray[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    object = (FieldElement)object.subtract(TArray[i3].multiply(this.lu[i3][n2]));
                }
                TArray[n2] = object;
                if (!this.lu[n5][n2].equals(this.field.getZero())) continue;
                ++n5;
            }
            if (n5 >= n) {
                this.singular = true;
                return;
            }
            if (n5 != n2) {
                int n6;
                FieldElement cfr_ignored_1 = (FieldElement)this.field.getZero();
                for (n6 = 0; n6 < n; ++n6) {
                    T t = this.lu[n5][n6];
                    this.lu[n5][n6] = this.lu[n2][n6];
                    this.lu[n2][n6] = t;
                }
                n6 = this.pivot[n5];
                this.pivot[n5] = this.pivot[n2];
                this.pivot[n2] = n6;
                this.even = !this.even;
            }
            object2 = this.lu[n2][n2];
            for (n4 = n2 + 1; n4 < n; ++n4) {
                T[] TArray = this.lu[n4];
                T[] TArray2 = TArray;
                TArray[n2] = (FieldElement)TArray2[n2].divide(object2);
            }
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, n2, n2);
            int n3 = 0;
            while (n3 < n) {
                T[] TArray = this.lu[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.cachedL.setEntry(n3, i2, TArray[i2]);
                }
                int n4 = n3++;
                this.cachedL.setEntry(n4, n4, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                T[] TArray = this.lu[i2];
                for (int i3 = i2; i3 < n; ++i3) {
                    this.cachedU.setEntry(i2, i3, TArray[i3]);
                }
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int n;
            int n2 = n = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                this.cachedP.setEntry(i2, this.pivot[i2], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int n = this.pivot.length;
        FieldElement fieldElement = this.even ? (FieldElement)this.field.getOne() : (FieldElement)((FieldElement)this.field.getZero()).subtract(this.field.getOne());
        for (int i2 = 0; i2 < n; ++i2) {
            fieldElement = (FieldElement)fieldElement.multiply(this.lu[i2][i2]);
        }
        return (T)fieldElement;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new FieldLUDecomposition$Solver(this.field, (FieldElement[][])this.lu, this.pivot, this.singular, null);
    }
}

