/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldDecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldLUDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldLUDecomposition$Solver<T extends FieldElement<T>>
implements FieldDecompositionSolver<T> {
    private final Field<T> field;
    private final T[][] lu;
    private final int[] pivot;
    private final boolean singular;

    private FieldLUDecomposition$Solver(Field<T> field, T[][] TArray, int[] nArray, boolean bl) {
        this.field = field;
        this.lu = TArray;
        this.pivot = nArray;
        this.singular = bl;
    }

    @Override
    public boolean isNonSingular() {
        return !this.singular;
    }

    @Override
    public FieldVector<T> solve(FieldVector<T> object) {
        try {
            return this.solve((ArrayFieldVector)object);
        }
        catch (ClassCastException classCastException) {
            int n;
            int n2;
            int n3 = this.pivot.length;
            if (object.getDimension() != n3) {
                throw new DimensionMismatchException(object.getDimension(), n3);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElementArray[n2] = object.getEntry(this.pivot[n2]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                object = fieldElementArray[n2];
                for (n = n2 + 1; n < n3; ++n) {
                    fieldElementArray[n] = (FieldElement)fieldElementArray[n].subtract(object.multiply(this.lu[n][n2]));
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                fieldElementArray[n2] = (FieldElement)fieldElementArray[n2].divide(this.lu[n2][n2]);
                object = fieldElementArray[n2];
                for (n = 0; n < n2; ++n) {
                    fieldElementArray[n] = (FieldElement)fieldElementArray[n].subtract(object.multiply(this.lu[n][n2]));
                }
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public ArrayFieldVector<T> solve(ArrayFieldVector<T> object) {
        int n;
        int n2;
        int n3 = this.pivot.length;
        int n4 = ((ArrayFieldVector)object).getDimension();
        if (n4 != n3) {
            throw new DimensionMismatchException(n4, n3);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            fieldElementArray[n2] = ((ArrayFieldVector)object).getEntry(this.pivot[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = fieldElementArray[n2];
            for (n = n2 + 1; n < n3; ++n) {
                fieldElementArray[n] = (FieldElement)fieldElementArray[n].subtract(object.multiply(this.lu[n][n2]));
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            fieldElementArray[n2] = (FieldElement)fieldElementArray[n2].divide(this.lu[n2][n2]);
            object = fieldElementArray[n2];
            for (n = 0; n < n2; ++n) {
                fieldElementArray[n] = (FieldElement)fieldElementArray[n].subtract(object.multiply(this.lu[n][n2]));
            }
        }
        return new ArrayFieldVector(fieldElementArray, false);
    }

    @Override
    public FieldMatrix<T> solve(FieldMatrix<T> fieldElementArray) {
        int n;
        FieldElement[] fieldElementArray2;
        int n2;
        int n3 = this.pivot.length;
        if (fieldElementArray.getRowDimension() != n3) {
            throw new DimensionMismatchException(fieldElementArray.getRowDimension(), n3);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        int n4 = fieldElementArray.getColumnDimension();
        FieldElement[][] fieldElementArray3 = (FieldElement[][])MathArrays.buildArray(this.field, n3, n4);
        for (n2 = 0; n2 < n3; ++n2) {
            fieldElementArray2 = fieldElementArray3[n2];
            n = this.pivot[n2];
            for (int i2 = 0; i2 < n4; ++i2) {
                fieldElementArray2[i2] = fieldElementArray.getEntry(n, i2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            fieldElementArray2 = fieldElementArray3[n2];
            for (n = n2 + 1; n < n3; ++n) {
                FieldElement[] fieldElementArray4 = fieldElementArray3[n];
                fieldElementArray = this.lu[n][n2];
                for (int i3 = 0; i3 < n4; ++i3) {
                    fieldElementArray4[i3] = (FieldElement)fieldElementArray4[i3].subtract(fieldElementArray2[i3].multiply(fieldElementArray));
                }
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            int n5;
            fieldElementArray2 = fieldElementArray3[n2];
            T t = this.lu[n2][n2];
            for (n5 = 0; n5 < n4; ++n5) {
                fieldElementArray2[n5] = (FieldElement)fieldElementArray2[n5].divide(t);
            }
            for (n5 = 0; n5 < n2; ++n5) {
                fieldElementArray = fieldElementArray3[n5];
                T t2 = this.lu[n5][n2];
                for (n3 = 0; n3 < n4; ++n3) {
                    fieldElementArray[n3] = (FieldElement)fieldElementArray[n3].subtract(fieldElementArray2[n3].multiply(t2));
                }
            }
        }
        return new Array2DRowFieldMatrix(this.field, fieldElementArray3, false);
    }

    @Override
    public FieldMatrix<T> getInverse() {
        int n = this.pivot.length;
        FieldElement fieldElement = (FieldElement)this.field.getOne();
        int n2 = n;
        Array2DRowFieldMatrix<FieldElement> array2DRowFieldMatrix = new Array2DRowFieldMatrix<FieldElement>(this.field, n2, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            array2DRowFieldMatrix.setEntry(n4, n4, fieldElement);
        }
        return this.solve(array2DRowFieldMatrix);
    }

    /* synthetic */ FieldLUDecomposition$Solver(Field field, FieldElement[][] fieldElementArray, int[] nArray, boolean bl, FieldLUDecomposition$1 fieldLUDecomposition$1) {
        this(field, fieldElementArray, nArray, bl);
    }
}

