/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SchurTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.TriDiagonalTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class EigenDecomposition {
    private static final double EPSILON = 1.0E-12;
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;
    private final boolean isSymmetric;

    public EigenDecomposition(RealMatrix object) {
        double d2 = (double)(10 * object.getRowDimension() * object.getColumnDimension()) * Precision.EPSILON;
        this.isSymmetric = MatrixUtils.isSymmetric((RealMatrix)object, d2);
        if (this.isSymmetric) {
            this.transformToTridiagonal((RealMatrix)object);
            EigenDecomposition eigenDecomposition = this;
            eigenDecomposition.findEigenVectors(eigenDecomposition.transformer.getQ().getData());
            return;
        }
        object = this.transformToSchur((RealMatrix)object);
        this.findEigenVectorsFromSchur((SchurTransformer)object);
    }

    @Deprecated
    public EigenDecomposition(RealMatrix realMatrix, double d2) {
        this(realMatrix);
    }

    public EigenDecomposition(double[] dArray, double[] object) {
        this.isSymmetric = true;
        this.main = (double[])dArray.clone();
        this.secondary = (double[])object.clone();
        this.transformer = null;
        int n = dArray.length;
        object = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            object[i2][i2] = 1.0;
        }
        this.findEigenVectors((double[][])object);
    }

    @Deprecated
    public EigenDecomposition(double[] dArray, double[] dArray2, double d2) {
        this(dArray, dArray2);
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int n;
            int n2 = n = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                this.cachedV.setColumnVector(i2, this.eigenvectors[i2]);
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
            for (int i2 = 0; i2 < this.imagEigenvalues.length; ++i2) {
                if (Precision.compareTo(this.imagEigenvalues[i2], 0.0, 1.0E-12) > 0) {
                    int n = i2;
                    this.cachedD.setEntry(n, n + 1, this.imagEigenvalues[i2]);
                    continue;
                }
                if (Precision.compareTo(this.imagEigenvalues[i2], 0.0, 1.0E-12) >= 0) continue;
                int n = i2;
                this.cachedD.setEntry(n, n - 1, this.imagEigenvalues[i2]);
            }
        }
        return this.cachedD;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            int n;
            int n2 = n = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                this.cachedVt.setRowVector(i2, this.eigenvectors[i2]);
            }
        }
        return this.cachedVt;
    }

    public boolean hasComplexEigenvalues() {
        for (int i2 = 0; i2 < this.imagEigenvalues.length; ++i2) {
            if (Precision.equals(this.imagEigenvalues[i2], 0.0, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    public double[] getRealEigenvalues() {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int n) {
        return this.realEigenvalues[n];
    }

    public double[] getImagEigenvalues() {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int n) {
        return this.imagEigenvalues[n];
    }

    public RealVector getEigenvector(int n) {
        return this.eigenvectors[n].copy();
    }

    public double getDeterminant() {
        double d2 = 1.0;
        double[] dArray = this.realEigenvalues;
        int n = this.realEigenvalues.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d3 = dArray[i2];
            d2 *= d3;
        }
        return d2;
    }

    public RealMatrix getSquareRoot() {
        if (!this.isSymmetric) {
            throw new MathUnsupportedOperationException();
        }
        double[] dArray = new double[this.realEigenvalues.length];
        for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
            double d2;
            double d3 = this.realEigenvalues[i2];
            if (d2 <= 0.0) {
                throw new MathUnsupportedOperationException();
            }
            dArray[i2] = FastMath.sqrt(d3);
        }
        RealMatrix realMatrix = MatrixUtils.createRealDiagonalMatrix(dArray);
        RealMatrix realMatrix2 = this.getV();
        RealMatrix realMatrix3 = this.getVT();
        return realMatrix2.multiply(realMatrix).multiply(realMatrix3);
    }

    public DecompositionSolver getSolver() {
        if (this.hasComplexEigenvalues()) {
            throw new MathUnsupportedOperationException();
        }
        return new EigenDecomposition$Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors, null);
    }

    private void transformToTridiagonal(RealMatrix realMatrix) {
        this.transformer = new TriDiagonalTransformer(realMatrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] dArray) {
        int n;
        dArray = (double[][])dArray.clone();
        int n2 = this.main.length;
        this.realEigenvalues = new double[n2];
        this.imagEigenvalues = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            this.realEigenvalues[i2] = this.main[i2];
            dArray2[i2] = this.secondary[i2];
        }
        this.realEigenvalues[n2 - 1] = this.main[n2 - 1];
        dArray2[n2 - 1] = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            if (FastMath.abs(this.realEigenvalues[n]) > d2) {
                d2 = FastMath.abs(this.realEigenvalues[n]);
            }
            if (!(FastMath.abs(dArray2[n]) > d2)) continue;
            d2 = FastMath.abs(dArray2[n]);
        }
        if (d2 != 0.0) {
            for (n = 0; n < n2; ++n) {
                if (FastMath.abs(this.realEigenvalues[n]) <= Precision.EPSILON * d2) {
                    this.realEigenvalues[n] = 0.0;
                }
                if (!(FastMath.abs(dArray2[n]) <= Precision.EPSILON * d2)) continue;
                dArray2[n] = 0.0;
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            int n4 = 0;
            do {
                int n5;
                double d3;
                for (n3 = n; n3 < n2 - 1; ++n3) {
                    d3 = FastMath.abs(this.realEigenvalues[n3]) + FastMath.abs(this.realEigenvalues[n3 + 1]);
                    if (FastMath.abs(dArray2[n3]) + d3 == d3) break;
                }
                if (n3 == n) continue;
                if (n4 == this.maxIter) {
                    throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, this.maxIter, new Object[0]);
                }
                ++n4;
                double d4 = d3 = (this.realEigenvalues[n + 1] - this.realEigenvalues[n]) / (2.0 * dArray2[n]);
                double d5 = FastMath.sqrt(1.0 + d4 * d4);
                d3 = d3 < 0.0 ? this.realEigenvalues[n3] - this.realEigenvalues[n] + dArray2[n] / (d3 - d5) : this.realEigenvalues[n3] - this.realEigenvalues[n] + dArray2[n] / (d3 + d5);
                double d6 = 0.0;
                double d7 = 1.0;
                double d8 = 1.0;
                for (n5 = n3 - 1; n5 >= n; --n5) {
                    double d9 = d7 * dArray2[n5];
                    double d10 = d8 * dArray2[n5];
                    if (FastMath.abs(d9) >= FastMath.abs(d3)) {
                        d8 = d3 / d9;
                        d5 = FastMath.sqrt(d8 * d8 + 1.0);
                        dArray2[n5 + 1] = d9 * d5;
                        d7 = 1.0 / d5;
                        d8 *= d7;
                    } else {
                        d7 = d9 / d3;
                        d5 = FastMath.sqrt(d7 * d7 + 1.0);
                        dArray2[n5 + 1] = d3 * d5;
                        d8 = 1.0 / d5;
                        d7 *= d8;
                    }
                    if (dArray2[n5 + 1] == 0.0) {
                        int n6 = n5 + 1;
                        this.realEigenvalues[n6] = this.realEigenvalues[n6] - d6;
                        dArray2[n3] = 0.0;
                        break;
                    }
                    d3 = this.realEigenvalues[n5 + 1] - d6;
                    d5 = (this.realEigenvalues[n5] - d3) * d7 + d8 * 2.0 * d10;
                    d6 = d7 * d5;
                    this.realEigenvalues[n5 + 1] = d3 + d6;
                    d3 = d8 * d5 - d10;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        d9 = dArray[i3][n5 + 1];
                        dArray[i3][n5 + 1] = d7 * dArray[i3][n5] + d8 * d9;
                        dArray[i3][n5] = d8 * dArray[i3][n5] - d7 * d9;
                    }
                }
                if (d5 == 0.0 && n5 >= n) continue;
                int n7 = n;
                this.realEigenvalues[n7] = this.realEigenvalues[n7] - d6;
                dArray2[n] = d3;
                dArray2[n3] = 0.0;
            } while (n3 != n);
        }
        for (n = 0; n < n2; ++n) {
            int n8;
            int n9 = n;
            double d11 = this.realEigenvalues[n];
            for (n8 = n + 1; n8 < n2; ++n8) {
                if (!(this.realEigenvalues[n8] > d11)) continue;
                n9 = n8;
                d11 = this.realEigenvalues[n8];
            }
            if (n9 == n) continue;
            this.realEigenvalues[n9] = this.realEigenvalues[n];
            this.realEigenvalues[n] = d11;
            for (n8 = 0; n8 < n2; ++n8) {
                d11 = dArray[n8][n];
                dArray[n8][n] = dArray[n8][n9];
                dArray[n8][n9] = d11;
            }
        }
        double d12 = 0.0;
        for (n = 0; n < n2; ++n) {
            if (!(FastMath.abs(this.realEigenvalues[n]) > d12)) continue;
            d12 = FastMath.abs(this.realEigenvalues[n]);
        }
        if (d12 != 0.0) {
            for (n = 0; n < n2; ++n) {
                if (!(FastMath.abs(this.realEigenvalues[n]) < Precision.EPSILON * d12)) continue;
                this.realEigenvalues[n] = 0.0;
            }
        }
        this.eigenvectors = new ArrayRealVector[n2];
        double[] dArray3 = new double[n2];
        for (int i4 = 0; i4 < n2; ++i4) {
            for (int i5 = 0; i5 < n2; ++i5) {
                dArray3[i5] = dArray[i5][i4];
            }
            this.eigenvectors[i4] = new ArrayRealVector(dArray3);
        }
    }

    private SchurTransformer transformToSchur(RealMatrix object) {
        object = new SchurTransformer((RealMatrix)object);
        double[][] dArray = ((SchurTransformer)object).getT().getData();
        this.realEigenvalues = new double[dArray.length];
        this.imagEigenvalues = new double[dArray.length];
        for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
            if (i2 == this.realEigenvalues.length - 1 || Precision.equals(dArray[i2 + 1][i2], 0.0, 1.0E-12)) {
                this.realEigenvalues[i2] = dArray[i2][i2];
                continue;
            }
            double d2 = dArray[i2 + 1][i2 + 1];
            double d3 = 0.5 * (dArray[i2][i2] - d2);
            double d4 = FastMath.sqrt(FastMath.abs(d3 * d3 + dArray[i2 + 1][i2] * dArray[i2][i2 + 1]));
            this.realEigenvalues[i2] = d2 + d3;
            this.imagEigenvalues[i2] = d4;
            this.realEigenvalues[i2 + 1] = d2 + d3;
            this.imagEigenvalues[i2 + 1] = -d4;
            ++i2;
        }
        return object;
    }

    private Complex cdiv(double d2, double d3, double d4, double d5) {
        return new Complex(d2, d3).divide(new Complex(d4, d5));
    }

    private void findEigenVectorsFromSchur(SchurTransformer object) {
        int n;
        int n2;
        double[][] dArray = ((SchurTransformer)object).getT().getData();
        object = ((SchurTransformer)object).getP().getData();
        int n3 = dArray.length;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = FastMath.max(i2 - 1, 0); i3 < n3; ++i3) {
                d2 += FastMath.abs(dArray[i2][i3]);
            }
        }
        if (Precision.equals(d2, 0.0, 1.0E-12)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            double d6;
            double d7;
            double d8;
            int n4;
            int n5;
            double d9 = this.realEigenvalues[n2];
            double d10 = this.imagEigenvalues[n2];
            if (Precision.equals(d10, 0.0)) {
                n5 = n2;
                dArray[n2][n2] = 1.0;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    d8 = dArray[n4][n4] - d9;
                    d3 = 0.0;
                    for (int i4 = n5; i4 <= n2; ++i4) {
                        d3 += dArray[n4][i4] * dArray[i4][n2];
                    }
                    if (Precision.compareTo(this.imagEigenvalues[n4], 0.0, 1.0E-12) < 0) {
                        d5 = d8;
                        d4 = d3;
                        continue;
                    }
                    n5 = n4;
                    if (Precision.equals(this.imagEigenvalues[n4], 0.0)) {
                        dArray[n4][n2] = d8 != 0.0 ? -d3 / d8 : -d3 / (Precision.EPSILON * d2);
                    } else {
                        double d11 = dArray[n4][n4 + 1];
                        d7 = dArray[n4 + 1][n4];
                        d10 = (this.realEigenvalues[n4] - d9) * (this.realEigenvalues[n4] - d9) + this.imagEigenvalues[n4] * this.imagEigenvalues[n4];
                        dArray[n4][n2] = d6 = (d11 * d4 - d5 * d3) / d10;
                        dArray[n4 + 1][n2] = FastMath.abs(d11) > FastMath.abs(d5) ? (-d3 - d8 * d6) / d11 : (-d4 - d7 * d6) / d5;
                    }
                    double d12 = FastMath.abs(dArray[n4][n2]);
                    if (!(Precision.EPSILON * d12 * d12 > 1.0)) continue;
                    for (int i5 = n4; i5 <= n2; ++i5) {
                        double[] dArray2 = dArray[i5];
                        int n6 = n2;
                        dArray2[n6] = dArray2[n6] / d12;
                    }
                }
                continue;
            }
            if (!(d10 < 0.0)) continue;
            n5 = n2 - 1;
            if (FastMath.abs(dArray[n2][n2 - 1]) > FastMath.abs(dArray[n2 - 1][n2])) {
                dArray[n2 - 1][n2 - 1] = d10 / dArray[n2][n2 - 1];
                dArray[n2 - 1][n2] = -(dArray[n2][n2] - d9) / dArray[n2][n2 - 1];
            } else {
                Complex complex = this.cdiv(0.0, -dArray[n2 - 1][n2], dArray[n2 - 1][n2 - 1] - d9, d10);
                dArray[n2 - 1][n2 - 1] = complex.getReal();
                dArray[n2 - 1][n2] = complex.getImaginary();
            }
            dArray[n2][n2 - 1] = 0.0;
            dArray[n2][n2] = 1.0;
            for (n4 = n2 - 2; n4 >= 0; --n4) {
                d8 = 0.0;
                double d13 = 0.0;
                for (int i6 = n5; i6 <= n2; ++i6) {
                    d8 += dArray[n4][i6] * dArray[i6][n2 - 1];
                    d13 += dArray[n4][i6] * dArray[i6][n2];
                }
                d7 = dArray[n4][n4] - d9;
                if (Precision.compareTo(this.imagEigenvalues[n4], 0.0, 1.0E-12) < 0) {
                    d5 = d7;
                    d3 = d8;
                    d4 = d13;
                    continue;
                }
                n5 = n4;
                if (Precision.equals(this.imagEigenvalues[n4], 0.0)) {
                    Complex complex = this.cdiv(-d8, -d13, d7, d10);
                    dArray[n4][n2 - 1] = complex.getReal();
                    dArray[n4][n2] = complex.getImaginary();
                } else {
                    d6 = dArray[n4][n4 + 1];
                    double d14 = dArray[n4 + 1][n4];
                    double d15 = d10;
                    double d16 = (this.realEigenvalues[n4] - d9) * (this.realEigenvalues[n4] - d9) + this.imagEigenvalues[n4] * this.imagEigenvalues[n4] - d15 * d15;
                    double d17 = (this.realEigenvalues[n4] - d9) * 2.0 * d10;
                    if (Precision.equals(d16, 0.0) && Precision.equals(d17, 0.0)) {
                        d16 = Precision.EPSILON * d2 * (FastMath.abs(d7) + FastMath.abs(d10) + FastMath.abs(d6) + FastMath.abs(d14) + FastMath.abs(d5));
                    }
                    Complex complex = this.cdiv(d6 * d3 - d5 * d8 + d10 * d13, d6 * d4 - d5 * d13 - d10 * d8, d16, d17);
                    dArray[n4][n2 - 1] = complex.getReal();
                    dArray[n4][n2] = complex.getImaginary();
                    if (FastMath.abs(d6) > FastMath.abs(d5) + FastMath.abs(d10)) {
                        dArray[n4 + 1][n2 - 1] = (-d8 - d7 * dArray[n4][n2 - 1] + d10 * dArray[n4][n2]) / d6;
                        dArray[n4 + 1][n2] = (-d13 - d7 * dArray[n4][n2] - d10 * dArray[n4][n2 - 1]) / d6;
                    } else {
                        complex = this.cdiv(-d3 - d14 * dArray[n4][n2 - 1], -d4 - d14 * dArray[n4][n2], d5, d10);
                        dArray[n4 + 1][n2 - 1] = complex.getReal();
                        dArray[n4 + 1][n2] = complex.getImaginary();
                    }
                }
                d6 = FastMath.max(FastMath.abs(dArray[n4][n2 - 1]), FastMath.abs(dArray[n4][n2]));
                if (!(Precision.EPSILON * d6 * d6 > 1.0)) continue;
                for (int i7 = n4; i7 <= n2; ++i7) {
                    double[] dArray3 = dArray[i7];
                    int n7 = n2 - 1;
                    dArray3[n7] = dArray3[n7] / d6;
                    double[] dArray4 = dArray[i7];
                    int n8 = n2;
                    dArray4[n8] = dArray4[n8] / d6;
                }
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            for (int i8 = 0; i8 <= n3 - 1; ++i8) {
                d5 = 0.0;
                for (n = 0; n <= FastMath.min(n2, n3 - 1); ++n) {
                    d5 += object[i8][n] * dArray[n][n2];
                }
                object[i8][n2] = d5;
            }
        }
        this.eigenvectors = new ArrayRealVector[n3];
        double[] dArray5 = new double[n3];
        for (int i9 = 0; i9 < n3; ++i9) {
            for (n = 0; n < n3; ++n) {
                dArray5[n] = (double)object[n][i9];
            }
            this.eigenvectors[i9] = new ArrayRealVector(dArray5);
        }
    }
}

