/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

class EigenDecomposition$Solver
implements DecompositionSolver {
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private final ArrayRealVector[] eigenvectors;

    private EigenDecomposition$Solver(double[] dArray, double[] dArray2, ArrayRealVector[] arrayRealVectorArray) {
        this.realEigenvalues = dArray;
        this.imagEigenvalues = dArray2;
        this.eigenvectors = arrayRealVectorArray;
    }

    public RealVector solve(RealVector realVector) {
        if (!this.isNonSingular()) {
            throw new SingularMatrixException();
        }
        int n = this.realEigenvalues.length;
        if (realVector.getDimension() != n) {
            throw new DimensionMismatchException(realVector.getDimension(), n);
        }
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayRealVector arrayRealVector = this.eigenvectors[i2];
            double[] dArray2 = arrayRealVector.getDataRef();
            double d2 = ((RealVector)arrayRealVector).dotProduct(realVector) / this.realEigenvalues[i2];
            for (int i3 = 0; i3 < n; ++i3) {
                int n2 = i3;
                dArray[n2] = dArray[n2] + d2 * dArray2[i3];
            }
        }
        return new ArrayRealVector(dArray, false);
    }

    public RealMatrix solve(RealMatrix realMatrix) {
        if (!this.isNonSingular()) {
            throw new SingularMatrixException();
        }
        int n = this.realEigenvalues.length;
        if (realMatrix.getRowDimension() != n) {
            throw new DimensionMismatchException(realMatrix.getRowDimension(), n);
        }
        int n2 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n][n2];
        double[] dArray2 = new double[n];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                dArray2[n3] = realMatrix.getEntry(n3, i2);
                dArray[n3][i2] = 0.0;
            }
            for (n3 = 0; n3 < n; ++n3) {
                int n4;
                ArrayRealVector arrayRealVector = this.eigenvectors[n3];
                double[] dArray3 = arrayRealVector.getDataRef();
                double d2 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    d2 += ((RealVector)arrayRealVector).getEntry(n4) * dArray2[n4];
                }
                d2 /= this.realEigenvalues[n3];
                for (n4 = 0; n4 < n; ++n4) {
                    double[] dArray4 = dArray[n4];
                    int n5 = i2;
                    dArray4[n5] = dArray4[n5] + d2 * dArray3[n4];
                }
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public boolean isNonSingular() {
        int n;
        double d2 = 0.0;
        for (n = 0; n < this.realEigenvalues.length; ++n) {
            d2 = FastMath.max(d2, this.eigenvalueNorm(n));
        }
        if (d2 == 0.0) {
            return false;
        }
        for (n = 0; n < this.realEigenvalues.length; ++n) {
            if (!Precision.equals(this.eigenvalueNorm(n) / d2, 0.0, 1.0E-12)) continue;
            return false;
        }
        return true;
    }

    private double eigenvalueNorm(int n) {
        double d2 = this.realEigenvalues[n];
        double d3 = this.imagEigenvalues[n];
        double d4 = d2;
        double d5 = d3;
        return FastMath.sqrt(d4 * d4 + d5 * d5);
    }

    public RealMatrix getInverse() {
        if (!this.isNonSingular()) {
            throw new SingularMatrixException();
        }
        int n = this.realEigenvalues.length;
        double[][] dArray = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray2 = dArray[i2];
            for (int i3 = 0; i3 < n; ++i3) {
                double d2 = 0.0;
                for (int i4 = 0; i4 < n; ++i4) {
                    double[] dArray3 = this.eigenvectors[i4].getDataRef();
                    d2 += dArray3[i2] * dArray3[i3] / this.realEigenvalues[i4];
                }
                dArray2[i3] = d2;
            }
        }
        return MatrixUtils.createRealMatrix(dArray);
    }

    /* synthetic */ EigenDecomposition$Solver(double[] dArray, double[] dArray2, ArrayRealVector[] arrayRealVectorArray, EigenDecomposition$1 eigenDecomposition$1) {
        this(dArray, dArray2, arrayRealVectorArray);
    }
}

