/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.SingularMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int n) {
        int n2 = n;
        super(n2, n2);
        this.data = new double[n];
    }

    public DiagonalMatrix(double[] dArray) {
        this(dArray, true);
    }

    public DiagonalMatrix(double[] dArray, boolean bl) {
        MathUtils.checkNotNull(dArray);
        this.data = bl ? (double[])dArray.clone() : dArray;
    }

    public RealMatrix createMatrix(int n, int n2) {
        if (n != n2) {
            throw new DimensionMismatchException(n, n2);
        }
        return new DiagonalMatrix(n);
    }

    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkAdditionCompatible(this, diagonalMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.data[i2] + diagonalMatrix.data[i2];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, diagonalMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.data[i2] - diagonalMatrix.data[i2];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, diagonalMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.data[i2] * diagonalMatrix.data[i2];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)realMatrix);
        }
        MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = this.data[i2] * realMatrix.getEntry(i2, i3);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public double[][] getData() {
        int n = ((RealLinearOperator)this).getRowDimension();
        double[][] dArray = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2][i2] = this.data[i2];
        }
        return dArray;
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        if (n == n2) {
            return this.data[n];
        }
        return 0.0;
    }

    public void setEntry(int n, int n2, double d2) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            this.data[n] = d2;
            return;
        }
        this.ensureZero(d2);
    }

    public void addToEntry(int n, int n2, double d2) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] + d2;
            return;
        }
        this.ensureZero(d2);
    }

    public void multiplyEntry(int n, int n2, double d2) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] * d2;
        }
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data.length;
    }

    public double[] operate(double[] dArray) {
        return this.multiply(new DiagonalMatrix(dArray, false)).getDataRef();
    }

    public double[] preMultiply(double[] dArray) {
        return ((AbstractRealMatrix)this).operate(dArray);
    }

    public RealVector preMultiply(RealVector object) {
        object = object instanceof ArrayRealVector ? (Object)((ArrayRealVector)object).getDataRef() : (Object)((RealVector)object).toArray();
        return MatrixUtils.createRealVector(((AbstractRealMatrix)this).preMultiply((double[])object));
    }

    private void ensureZero(double d2) {
        if (!Precision.equals(0.0, d2, 1)) {
            throw new NumberIsTooLargeException(FastMath.abs(d2), (Number)0, true);
        }
    }

    public DiagonalMatrix inverse() {
        return this.inverse(0.0);
    }

    public DiagonalMatrix inverse(double d2) {
        if (this.isSingular(d2)) {
            throw new SingularMatrixException();
        }
        double[] dArray = new double[this.data.length];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            dArray[i2] = 1.0 / this.data[i2];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public boolean isSingular(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (!Precision.equals(this.data[i2], 0.0, d2)) continue;
            return true;
        }
        return false;
    }
}

