/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.ExceptionContext;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DefaultIterativeLinearSolverEvent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationEvent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationManager;

public class ConjugateGradient
extends PreconditionedIterativeLinearSolver {
    public static final String OPERATOR = "operator";
    public static final String VECTOR = "vector";
    private boolean check;
    private final double delta;

    public ConjugateGradient(int n, double d2, boolean bl) {
        super(n);
        this.delta = d2;
        this.check = bl;
    }

    public ConjugateGradient(IterationManager iterationManager, double d2, boolean bl) {
        super(iterationManager);
        this.delta = d2;
        this.check = bl;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        ConjugateGradient.checkParameters(realLinearOperator, realLinearOperator2, realVector, realVector2);
        IterationManager iterationManager = this.getIterationManager();
        iterationManager.resetIterationCount();
        double d2 = this.delta * realVector.getNorm();
        RealVector realVector3 = RealVector.unmodifiableRealVector(realVector);
        iterationManager.incrementIterationCount();
        RealVector realVector4 = RealVector.unmodifiableRealVector(realVector2);
        RealVector realVector5 = realVector2.copy();
        Object object = realLinearOperator.operate(realVector5);
        realVector = realVector.combine(1.0, -1.0, (RealVector)object);
        RealVector realVector6 = RealVector.unmodifiableRealVector(realVector);
        double d3 = realVector.getNorm();
        RealVector realVector7 = realLinearOperator2 == null ? realVector : null;
        object = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector4, realVector3, realVector6, d3);
        iterationManager.fireInitializationEvent((IterationEvent)object);
        if (d3 <= d2) {
            iterationManager.fireTerminationEvent((IterationEvent)object);
            return realVector2;
        }
        double d4 = 0.0;
        do {
            iterationManager.incrementIterationCount();
            object = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector4, realVector3, realVector6, d3);
            iterationManager.fireIterationStartedEvent((IterationEvent)object);
            if (realLinearOperator2 != null) {
                realVector7 = realLinearOperator2.operate(realVector);
            }
            double d5 = realVector.dotProduct(realVector7);
            if (this.check && d5 <= 0.0) {
                NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
                ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
                exceptionContext.setValue(OPERATOR, realLinearOperator2);
                exceptionContext.setValue(VECTOR, realVector);
                throw nonPositiveDefiniteOperatorException;
            }
            if (iterationManager.getIterations() == 2) {
                realVector5.setSubVector(0, realVector7);
            } else {
                realVector5.combineToSelf(d5 / d4, 1.0, realVector7);
            }
            object = realLinearOperator.operate(realVector5);
            double d6 = realVector5.dotProduct((RealVector)object);
            if (this.check && d6 <= 0.0) {
                NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
                ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
                exceptionContext.setValue(OPERATOR, realLinearOperator);
                exceptionContext.setValue(VECTOR, realVector5);
                throw nonPositiveDefiniteOperatorException;
            }
            double d7 = d5 / d6;
            realVector2.combineToSelf(1.0, d7, realVector5);
            realVector.combineToSelf(1.0, -d7, (RealVector)object);
            d4 = d5;
            d3 = realVector.getNorm();
            object = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector4, realVector3, realVector6, d3);
            iterationManager.fireIterationPerformedEvent((IterationEvent)object);
        } while (!(d3 <= d2));
        iterationManager.fireTerminationEvent((IterationEvent)object);
        return realVector2;
    }
}

