/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.CholeskyDecomposition$Solver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSymmetricMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecomposition(RealMatrix realMatrix, double d2, double d3) {
        double[] dArray;
        int n;
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n2 = realMatrix.getRowDimension();
        this.lTData = realMatrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        for (n = 0; n < n2; ++n) {
            dArray = this.lTData[n];
            for (int i2 = n + 1; i2 < n2; ++i2) {
                double[] dArray2 = this.lTData[i2];
                double d4 = dArray[i2];
                double d5 = dArray2[n];
                double d6 = d2 * FastMath.max(FastMath.abs(d4), FastMath.abs(d5));
                if (FastMath.abs(d4 - d5) > d6) {
                    throw new NonSymmetricMatrixException(n, i2, d2);
                }
                dArray2[n] = 0.0;
            }
        }
        for (n = 0; n < n2; ++n) {
            double[] dArray3;
            dArray = this.lTData[n];
            if (dArray3[n] <= d3) {
                throw new NonPositiveDefiniteMatrixException(dArray[n], n, d3);
            }
            dArray[n] = FastMath.sqrt(dArray[n]);
            double d7 = 1.0 / dArray[n];
            for (int i3 = n2 - 1; i3 > n; --i3) {
                int n3 = i3;
                dArray[n3] = dArray[n3] * d7;
                double[] dArray4 = this.lTData[i3];
                for (int i4 = i3; i4 < n2; ++i4) {
                    int n4 = i4;
                    dArray4[n4] = dArray4[n4] - dArray[i3] * dArray[i4];
                }
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double d2 = 1.0;
        for (int i2 = 0; i2 < this.lTData.length; ++i2) {
            double d3;
            double d4 = d3 = this.lTData[i2][i2];
            d2 *= d4 * d4;
        }
        return d2;
    }

    public DecompositionSolver getSolver() {
        return new CholeskyDecomposition$Solver(this.lTData, null);
    }
}

