/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.CholeskyDecomposition$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.DecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;

class CholeskyDecomposition$Solver
implements DecompositionSolver {
    private final double[][] lTData;

    private CholeskyDecomposition$Solver(double[][] dArray) {
        this.lTData = dArray;
    }

    public boolean isNonSingular() {
        return true;
    }

    public RealVector solve(RealVector object) {
        int n;
        int n2 = this.lTData.length;
        if (((RealVector)object).getDimension() != n2) {
            throw new DimensionMismatchException(((RealVector)object).getDimension(), n2);
        }
        object = ((RealVector)object).toArray();
        for (n = 0; n < n2; ++n) {
            double[] dArray = this.lTData[n];
            Object object2 = object;
            int n3 = n;
            object2[n3] = object2[n3] / dArray[n];
            Object object3 = object[n];
            for (int i2 = n + 1; i2 < n2; ++i2) {
                Object object4 = object;
                int n4 = i2;
                object4[n4] = object4[n4] - object3 * dArray[i2];
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            Object object5 = object;
            int n5 = n;
            object5[n5] = object5[n5] / this.lTData[n][n];
            Object object6 = object[n];
            for (int i3 = 0; i3 < n; ++i3) {
                Object object7 = object;
                int n6 = i3;
                object7[n6] = object7[n6] - object6 * this.lTData[i3][n];
            }
        }
        return new ArrayRealVector((double[])object, false);
    }

    public RealMatrix solve(RealMatrix object) {
        int n;
        int n2 = this.lTData.length;
        if (object.getRowDimension() != n2) {
            throw new DimensionMismatchException(object.getRowDimension(), n2);
        }
        int n3 = object.getColumnDimension();
        object = object.getData();
        for (n = 0; n < n2; ++n) {
            double[] dArray = this.lTData[n];
            double d2 = dArray[n];
            Object object2 = object[n];
            int n4 = 0;
            while (n4 < n3) {
                Object object3 = object2;
                int n5 = n4++;
                object3[n5] = object3[n5] / d2;
            }
            for (n4 = n + 1; n4 < n2; ++n4) {
                Object object4 = object[n4];
                double d3 = dArray[n4];
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object5 = object4;
                    int n6 = i2;
                    object5[n6] = object5[n6] - object2[i2] * d3;
                }
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            double d4 = this.lTData[n][n];
            Object object6 = object[n];
            int n7 = 0;
            while (n7 < n3) {
                Object object7 = object6;
                int n8 = n7++;
                object7[n8] = object7[n8] / d4;
            }
            for (n7 = 0; n7 < n; ++n7) {
                Object object8 = object[n7];
                double d5 = this.lTData[n7][n];
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object9 = object8;
                    int n9 = i3;
                    object9[n9] = object9[n9] - object6[i3] * d5;
                }
            }
        }
        return new Array2DRowRealMatrix((double[][])object);
    }

    public RealMatrix getInverse() {
        CholeskyDecomposition$Solver choleskyDecomposition$Solver = this;
        return choleskyDecomposition$Solver.solve(MatrixUtils.createRealIdentityMatrix(choleskyDecomposition$Solver.lTData.length));
    }

    /* synthetic */ CholeskyDecomposition$Solver(double[][] dArray, CholeskyDecomposition$1 choleskyDecomposition$1) {
        this(dArray);
    }
}

