/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixDimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.Arrays;

public class BlockRealMatrix
extends AbstractRealMatrix
implements Serializable {
    public static final int BLOCK_SIZE = 52;
    private static final long serialVersionUID = 4991895511313664478L;
    private final double[][] blocks;
    private final int rows;
    private final int columns;
    private final int blockRows;
    private final int blockColumns;

    public BlockRealMatrix(int n, int n2) {
        super(n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 52 - 1) / 52;
        this.blockColumns = (n2 + 52 - 1) / 52;
        this.blocks = BlockRealMatrix.createBlocksLayout(n, n2);
    }

    public BlockRealMatrix(double[][] dArray) {
        this(dArray.length, dArray[0].length, BlockRealMatrix.toBlocksLayout(dArray), false);
    }

    public BlockRealMatrix(int n, int n2, double[][] dArray, boolean bl) {
        super(n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 52 - 1) / 52;
        this.blockColumns = (n2 + 52 - 1) / 52;
        this.blocks = bl ? (Object)new double[this.blockRows * this.blockColumns][] : dArray;
        n = 0;
        for (n2 = 0; n2 < this.blockRows; ++n2) {
            int n3 = this.blockHeight(n2);
            int n4 = 0;
            while (n4 < this.blockColumns) {
                if (dArray[n].length != n3 * this.blockWidth(n4)) {
                    throw new DimensionMismatchException(dArray[n].length, n3 * this.blockWidth(n4));
                }
                if (bl) {
                    this.blocks[n] = (double[])dArray[n].clone();
                }
                ++n4;
                ++n;
            }
        }
    }

    public static double[][] toBlocksLayout(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = (n2 + 52 - 1) / 52;
        int n5 = (n3 + 52 - 1) / 52;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            n = dArray[i2].length;
            if (n == n3) continue;
            throw new DimensionMismatchException(n3, n);
        }
        double[][] dArrayArray = new double[n4 * n5][];
        n = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n6 = i3 * 52;
            int n7 = FastMath.min(n6 + 52, n2);
            int n8 = n7 - n6;
            for (int i4 = 0; i4 < n5; ++i4) {
                int n9 = i4 * 52;
                int n10 = FastMath.min(n9 + 52, n3);
                double[] dArray2 = new double[n8 * (n10 -= n9)];
                dArrayArray[n] = dArray2;
                int n11 = 0;
                for (int i5 = n6; i5 < n7; ++i5) {
                    System.arraycopy(dArray[i5], n9, dArray2, n11, n10);
                    n11 += n10;
                }
                ++n;
            }
        }
        return dArrayArray;
    }

    public static double[][] createBlocksLayout(int n, int n2) {
        int n3 = (n + 52 - 1) / 52;
        int n4 = (n2 + 52 - 1) / 52;
        double[][] dArrayArray = new double[n3 * n4][];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 * 52;
            int n7 = FastMath.min(n6 + 52, n);
            n6 = n7 - n6;
            for (n7 = 0; n7 < n4; ++n7) {
                int n8 = n7 * 52;
                int n9 = FastMath.min(n8 + 52, n2);
                n8 = n9 - n8;
                dArrayArray[n5] = new double[n6 * n8];
                ++n5;
            }
        }
        return dArrayArray;
    }

    public BlockRealMatrix createMatrix(int n, int n2) {
        return new BlockRealMatrix(n, n2);
    }

    public BlockRealMatrix copy() {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            System.arraycopy(this.blocks[i2], 0, blockRealMatrix.blocks[i2], 0, this.blocks[i2].length);
        }
        return blockRealMatrix;
    }

    public BlockRealMatrix add(RealMatrix realMatrix) {
        try {
            return this.add((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkAdditionCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
            int n = 0;
            for (int i2 = 0; i2 < blockRealMatrix.blockRows; ++i2) {
                for (int i3 = 0; i3 < blockRealMatrix.blockColumns; ++i3) {
                    double[] dArray = blockRealMatrix.blocks[n];
                    double[] dArray2 = this.blocks[n];
                    int n2 = i2 * 52;
                    int n3 = FastMath.min(n2 + 52, this.rows);
                    int n4 = i3 * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    int n6 = 0;
                    while (n2 < n3) {
                        for (int i4 = n4; i4 < n5; ++i4) {
                            dArray[n6] = dArray2[n6] + realMatrix.getEntry(n2, i4);
                            ++n6;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix add(BlockRealMatrix blockRealMatrix) {
        MatrixUtils.checkAdditionCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, this.columns);
        for (int i2 = 0; i2 < blockRealMatrix2.blocks.length; ++i2) {
            double[] dArray = blockRealMatrix2.blocks[i2];
            double[] dArray2 = this.blocks[i2];
            double[] dArray3 = blockRealMatrix.blocks[i2];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = dArray2[i3] + dArray3[i3];
            }
        }
        return blockRealMatrix2;
    }

    public BlockRealMatrix subtract(RealMatrix realMatrix) {
        try {
            return this.subtract((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkSubtractionCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
            int n = 0;
            for (int i2 = 0; i2 < blockRealMatrix.blockRows; ++i2) {
                for (int i3 = 0; i3 < blockRealMatrix.blockColumns; ++i3) {
                    double[] dArray = blockRealMatrix.blocks[n];
                    double[] dArray2 = this.blocks[n];
                    int n2 = i2 * 52;
                    int n3 = FastMath.min(n2 + 52, this.rows);
                    int n4 = i3 * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    int n6 = 0;
                    while (n2 < n3) {
                        for (int i4 = n4; i4 < n5; ++i4) {
                            dArray[n6] = dArray2[n6] - realMatrix.getEntry(n2, i4);
                            ++n6;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix subtract(BlockRealMatrix blockRealMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, this.columns);
        for (int i2 = 0; i2 < blockRealMatrix2.blocks.length; ++i2) {
            double[] dArray = blockRealMatrix2.blocks[i2];
            double[] dArray2 = this.blocks[i2];
            double[] dArray3 = blockRealMatrix.blocks[i2];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = dArray2[i3] - dArray3[i3];
            }
        }
        return blockRealMatrix2;
    }

    public BlockRealMatrix scalarAdd(double d2) {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i2 = 0; i2 < blockRealMatrix.blocks.length; ++i2) {
            double[] dArray = blockRealMatrix.blocks[i2];
            double[] dArray2 = this.blocks[i2];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = dArray2[i3] + d2;
            }
        }
        return blockRealMatrix;
    }

    public RealMatrix scalarMultiply(double d2) {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i2 = 0; i2 < blockRealMatrix.blocks.length; ++i2) {
            double[] dArray = blockRealMatrix.blocks[i2];
            double[] dArray2 = this.blocks[i2];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = dArray2[i3] * d2;
            }
        }
        return blockRealMatrix;
    }

    public BlockRealMatrix multiply(RealMatrix realMatrix) {
        try {
            return this.multiply((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, realMatrix.getColumnDimension());
            int n = 0;
            for (int i2 = 0; i2 < blockRealMatrix.blockRows; ++i2) {
                int n2 = i2 * 52;
                int n3 = FastMath.min(n2 + 52, this.rows);
                for (int i3 = 0; i3 < blockRealMatrix.blockColumns; ++i3) {
                    int n4 = i3 * 52;
                    int n5 = FastMath.min(n4 + 52, realMatrix.getColumnDimension());
                    double[] dArray = blockRealMatrix.blocks[n];
                    for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                        int n6 = this.blockWidth(i4);
                        double[] dArray2 = this.blocks[i2 * this.blockColumns + i4];
                        int n7 = i4 * 52;
                        int n8 = 0;
                        for (int i5 = n2; i5 < n3; ++i5) {
                            int n9 = (i5 - n2) * n6;
                            int n10 = n9 + n6;
                            for (int i6 = n4; i6 < n5; ++i6) {
                                double d2 = 0.0;
                                int n11 = n7;
                                for (int i7 = n9; i7 < n10; ++i7) {
                                    d2 += dArray2[i7] * realMatrix.getEntry(n11, i6);
                                    ++n11;
                                }
                                int n12 = n8++;
                                dArray[n12] = dArray[n12] + d2;
                            }
                        }
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix multiply(BlockRealMatrix blockRealMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, blockRealMatrix.columns);
        int n = 0;
        for (int i2 = 0; i2 < blockRealMatrix2.blockRows; ++i2) {
            int n2 = i2 * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int i3 = 0; i3 < blockRealMatrix2.blockColumns; ++i3) {
                int n4 = blockRealMatrix2.blockWidth(i3);
                int n5 = n4 + n4;
                int n6 = n5 + n4;
                int n7 = n6 + n4;
                double[] dArray = blockRealMatrix2.blocks[n];
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n8 = this.blockWidth(i4);
                    double[] dArray2 = this.blocks[i2 * this.blockColumns + i4];
                    double[] dArray3 = blockRealMatrix.blocks[i4 * blockRealMatrix.blockColumns + i3];
                    int n9 = 0;
                    for (int i5 = n2; i5 < n3; ++i5) {
                        int n10 = (i5 - n2) * n8;
                        int n11 = n10 + n8;
                        for (int i6 = 0; i6 < n4; ++i6) {
                            double d2 = 0.0;
                            int n12 = n10;
                            int n13 = i6;
                            while (n12 < n11 - 3) {
                                d2 += dArray2[n12] * dArray3[n13] + dArray2[n12 + 1] * dArray3[n13 + n4] + dArray2[n12 + 2] * dArray3[n13 + n5] + dArray2[n12 + 3] * dArray3[n13 + n6];
                                n12 += 4;
                                n13 += n7;
                            }
                            while (n12 < n11) {
                                d2 += dArray2[n12++] * dArray3[n13];
                                n13 += n4;
                            }
                            int n14 = n9++;
                            dArray[n14] = dArray[n14] + d2;
                        }
                    }
                }
                ++n;
            }
        }
        return blockRealMatrix2;
    }

    public double[][] getData() {
        double[][] dArray = new double[((RealLinearOperator)this).getRowDimension()][((RealLinearOperator)this).getColumnDimension()];
        int n = this.columns - (this.blockColumns - 1) * 52;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            int n4 = 0;
            int n5 = 0;
            while (n2 < n3) {
                double[] dArray2 = dArray[n2];
                int n6 = i2 * this.blockColumns;
                int n7 = 0;
                for (int i3 = 0; i3 < this.blockColumns - 1; ++i3) {
                    System.arraycopy(this.blocks[n6++], n4, dArray2, n7, 52);
                    n7 += 52;
                }
                System.arraycopy(this.blocks[n6], n5, dArray2, n7, n);
                n4 += 52;
                n5 += n;
                ++n2;
            }
        }
        return dArray;
    }

    public double getNorm() {
        double[] dArray = new double[52];
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n;
            int n2 = this.blockWidth(i2);
            Arrays.fill(dArray, 0, n2, 0.0);
            for (n = 0; n < this.blockRows; ++n) {
                int n3 = this.blockHeight(n);
                double[] dArray2 = this.blocks[n * this.blockColumns + i2];
                int n4 = 0;
                while (n4 < n2) {
                    double d3 = 0.0;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        d3 += FastMath.abs(dArray2[i3 * n2 + n4]);
                    }
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d3;
                }
            }
            for (n = 0; n < n2; ++n) {
                d2 = FastMath.max(d2, dArray[n]);
            }
        }
        return d2;
    }

    public double getFrobeniusNorm() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            double[] dArray = this.blocks[i2];
            int n = dArray.length;
            for (int i3 = 0; i3 < n; ++i3) {
                double d3;
                double d4 = d3 = dArray[i3];
                d2 += d4 * d4;
            }
        }
        return FastMath.sqrt(d2);
    }

    public BlockRealMatrix getSubMatrix(int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2 - n + 1, n4 - n3 + 1);
        n4 = n / 52;
        n %= 52;
        int n5 = n3 / 52;
        n3 %= 52;
        for (int i2 = 0; i2 < blockRealMatrix.blockRows; ++i2) {
            int n6 = blockRealMatrix.blockHeight(i2);
            int n7 = n5;
            for (int i3 = 0; i3 < blockRealMatrix.blockColumns; ++i3) {
                int n8;
                int n9 = blockRealMatrix.blockWidth(i3);
                int n10 = i2 * blockRealMatrix.blockColumns + i3;
                double[] dArray = blockRealMatrix.blocks[n10];
                int n11 = n4 * this.blockColumns + n7;
                int n12 = this.blockWidth(n7);
                int n13 = n6 + n - 52;
                int n14 = n9 + n3 - 52;
                if (n13 > 0) {
                    if (n14 > 0) {
                        n8 = this.blockWidth(n7 + 1);
                        BlockRealMatrix blockRealMatrix2 = this;
                        blockRealMatrix2.copyBlockPart(blockRealMatrix2.blocks[n11], n12, n, 52, n3, 52, dArray, n9, 0, 0);
                        BlockRealMatrix blockRealMatrix3 = this;
                        blockRealMatrix3.copyBlockPart(blockRealMatrix3.blocks[n11 + 1], n8, n, 52, 0, n14, dArray, n9, 0, n9 - n14);
                        BlockRealMatrix blockRealMatrix4 = this;
                        blockRealMatrix4.copyBlockPart(blockRealMatrix4.blocks[n11 + this.blockColumns], n12, 0, n13, n3, 52, dArray, n9, n6 - n13, 0);
                        BlockRealMatrix blockRealMatrix5 = this;
                        blockRealMatrix5.copyBlockPart(blockRealMatrix5.blocks[n11 + this.blockColumns + 1], n8, 0, n13, 0, n14, dArray, n9, n6 - n13, n9 - n14);
                    } else {
                        BlockRealMatrix blockRealMatrix6 = this;
                        blockRealMatrix6.copyBlockPart(blockRealMatrix6.blocks[n11], n12, n, 52, n3, n9 + n3, dArray, n9, 0, 0);
                        BlockRealMatrix blockRealMatrix7 = this;
                        blockRealMatrix7.copyBlockPart(blockRealMatrix7.blocks[n11 + this.blockColumns], n12, 0, n13, n3, n9 + n3, dArray, n9, n6 - n13, 0);
                    }
                } else if (n14 > 0) {
                    n8 = this.blockWidth(n7 + 1);
                    BlockRealMatrix blockRealMatrix8 = this;
                    blockRealMatrix8.copyBlockPart(blockRealMatrix8.blocks[n11], n12, n, n6 + n, n3, 52, dArray, n9, 0, 0);
                    BlockRealMatrix blockRealMatrix9 = this;
                    blockRealMatrix9.copyBlockPart(blockRealMatrix9.blocks[n11 + 1], n8, n, n6 + n, 0, n14, dArray, n9, 0, n9 - n14);
                } else {
                    BlockRealMatrix blockRealMatrix10 = this;
                    blockRealMatrix10.copyBlockPart(blockRealMatrix10.blocks[n11], n12, n, n6 + n, n3, n9 + n3, dArray, n9, 0, 0);
                }
                ++n7;
            }
            ++n4;
        }
        return blockRealMatrix;
    }

    private void copyBlockPart(double[] dArray, int n, int n2, int n3, int n4, int n5, double[] dArray2, int n6, int n7, int n8) {
        n5 -= n4;
        n4 = n2 * n + n4;
        n7 = n7 * n6 + n8;
        while (n2 < n3) {
            System.arraycopy(dArray, n4, dArray2, n7, n5);
            n4 += n;
            n7 += n6;
            ++n2;
        }
    }

    public void setSubMatrix(double[][] dArray, int n, int n2) {
        int n3;
        MathUtils.checkNotNull(dArray);
        int n4 = dArray[0].length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        int n5 = n + dArray.length - 1;
        int n6 = n2 + n4 - 1;
        MatrixUtils.checkSubMatrixIndex(this, n, n5, n2, n6);
        double[][] dArray2 = dArray;
        int n7 = dArray.length;
        for (n3 = 0; n3 < n7; ++n3) {
            double[] dArray3 = dArray2[n3];
            if (dArray3.length == n4) continue;
            throw new DimensionMismatchException(n4, dArray3.length);
        }
        int n8 = n / 52;
        n7 = (n5 + 52) / 52;
        n3 = n2 / 52;
        int n9 = (n6 + 52) / 52;
        for (n4 = n8; n4 < n7; ++n4) {
            n8 = this.blockHeight(n4);
            int n10 = n4 * 52;
            int n11 = FastMath.max(n, n10);
            n8 = FastMath.min(n5 + 1, n10 + n8);
            for (int i2 = n3; i2 < n9; ++i2) {
                int n12 = this.blockWidth(i2);
                int n13 = i2 * 52;
                int n14 = FastMath.max(n2, n13);
                int n15 = FastMath.min(n6 + 1, n13 + n12);
                n15 -= n14;
                double[] dArray4 = this.blocks[n4 * this.blockColumns + i2];
                for (int i3 = n11; i3 < n8; ++i3) {
                    System.arraycopy(dArray[i3 - n], n14 - n2, dArray4, (i3 - n10) * n12 + (n14 - n13), n15);
                }
            }
        }
    }

    public BlockRealMatrix getRowMatrix(int n) {
        MatrixUtils.checkRowIndex(this, n);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(1, this.columns);
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = 0;
        int n4 = 0;
        double[] dArray = blockRealMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n5 = this.blockWidth(i2);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i2];
            int n6 = dArray.length - n4;
            if (n5 > n6) {
                System.arraycopy(dArray2, n * n5, dArray, n4, n6);
                dArray = blockRealMatrix.blocks[++n3];
                System.arraycopy(dArray2, n * n5, dArray, 0, n5 - n6);
                n4 = n5 - n6;
                continue;
            }
            System.arraycopy(dArray2, n * n5, dArray, n4, n5);
            n4 += n5;
        }
        return blockRealMatrix;
    }

    public void setRowMatrix(int n, RealMatrix realMatrix) {
        try {
            this.setRowMatrix(n, (BlockRealMatrix)realMatrix);
            return;
        }
        catch (ClassCastException classCastException) {
            super.setRowMatrix(n, realMatrix);
            return;
        }
    }

    public void setRowMatrix(int n, BlockRealMatrix blockRealMatrix) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (((RealLinearOperator)blockRealMatrix).getRowDimension() != 1 || ((RealLinearOperator)blockRealMatrix).getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(((RealLinearOperator)blockRealMatrix).getRowDimension(), ((RealLinearOperator)blockRealMatrix).getColumnDimension(), 1, n2);
        }
        n2 = n / 52;
        n -= n2 * 52;
        int n3 = 0;
        int n4 = 0;
        double[] dArray = blockRealMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n5 = this.blockWidth(i2);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i2];
            int n6 = dArray.length - n4;
            if (n5 > n6) {
                System.arraycopy(dArray, n4, dArray2, n * n5, n6);
                dArray = blockRealMatrix.blocks[++n3];
                System.arraycopy(dArray, 0, dArray2, n * n5, n5 - n6);
                n4 = n5 - n6;
                continue;
            }
            System.arraycopy(dArray, n4, dArray2, n * n5, n5);
            n4 += n5;
        }
    }

    public BlockRealMatrix getColumnMatrix(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, 1);
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        int n5 = 0;
        double[] dArray = blockRealMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n6 = this.blockHeight(i2);
            double[] dArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n6; ++i3) {
                if (n5 >= dArray.length) {
                    dArray = blockRealMatrix.blocks[++n4];
                    n5 = 0;
                }
                dArray[n5++] = dArray2[i3 * n3 + n];
            }
        }
        return blockRealMatrix;
    }

    public void setColumnMatrix(int n, RealMatrix realMatrix) {
        try {
            this.setColumnMatrix(n, (BlockRealMatrix)realMatrix);
            return;
        }
        catch (ClassCastException classCastException) {
            super.setColumnMatrix(n, realMatrix);
            return;
        }
    }

    void setColumnMatrix(int n, BlockRealMatrix blockRealMatrix) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (((RealLinearOperator)blockRealMatrix).getRowDimension() != n2 || ((RealLinearOperator)blockRealMatrix).getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(((RealLinearOperator)blockRealMatrix).getRowDimension(), ((RealLinearOperator)blockRealMatrix).getColumnDimension(), n2, 1);
        }
        n2 = n / 52;
        n -= n2 * 52;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        int n5 = 0;
        double[] dArray = blockRealMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n6 = this.blockHeight(i2);
            double[] dArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n6; ++i3) {
                if (n5 >= dArray.length) {
                    dArray = blockRealMatrix.blocks[++n4];
                    n5 = 0;
                }
                dArray2[i3 * n3 + n] = dArray[n5++];
            }
        }
    }

    public RealVector getRowVector(int n) {
        MatrixUtils.checkRowIndex(this, n);
        double[] dArray = new double[this.columns];
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(dArray2, n * n4, dArray, n3, n4);
            n3 += n4;
        }
        return new ArrayRealVector(dArray, false);
    }

    public void setRowVector(int n, RealVector realVector) {
        try {
            ((AbstractRealMatrix)this).setRow(n, ((ArrayRealVector)realVector).getDataRef());
            return;
        }
        catch (ClassCastException classCastException) {
            super.setRowVector(n, realVector);
            return;
        }
    }

    public RealVector getColumnVector(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        double[] dArray = new double[this.rows];
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            double[] dArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                dArray[n4++] = dArray2[i3 * n3 + n];
            }
        }
        return new ArrayRealVector(dArray, false);
    }

    public void setColumnVector(int n, RealVector realVector) {
        try {
            ((AbstractRealMatrix)this).setColumn(n, ((ArrayRealVector)realVector).getDataRef());
            return;
        }
        catch (ClassCastException classCastException) {
            super.setColumnVector(n, realVector);
            return;
        }
    }

    public double[] getRow(int n) {
        MatrixUtils.checkRowIndex(this, n);
        double[] dArray = new double[this.columns];
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(dArray2, n * n4, dArray, n3, n4);
            n3 += n4;
        }
        return dArray;
    }

    public void setRow(int n, double[] dArray) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, dArray.length, 1, n2);
        }
        n2 = n / 52;
        n -= n2 * 52;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(dArray, n3, dArray2, n * n4, n4);
            n3 += n4;
        }
    }

    public double[] getColumn(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        double[] dArray = new double[this.rows];
        int n2 = n / 52;
        n -= n2 * 52;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            double[] dArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                dArray[n4++] = dArray2[i3 * n3 + n];
            }
        }
        return dArray;
    }

    public void setColumn(int n, double[] dArray) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(dArray.length, 1, n2, 1);
        }
        n2 = n / 52;
        n -= n2 * 52;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            double[] dArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                dArray2[i3 * n3 + n] = dArray[n4++];
            }
        }
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        n = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        return this.blocks[n3 * this.blockColumns + n4][n];
    }

    public void setEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        n = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        this.blocks[n3 * this.blockColumns + n4][n] = d2;
    }

    public void addToEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        n = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        double[] dArray = this.blocks[n3 * this.blockColumns + n4];
        int n5 = n;
        dArray[n5] = dArray[n5] + d2;
    }

    public void multiplyEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        n = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        double[] dArray = this.blocks[n3 * this.blockColumns + n4];
        int n5 = n;
        dArray[n5] = dArray[n5] * d2;
    }

    public BlockRealMatrix transpose() {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n);
        n2 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            for (int i3 = 0; i3 < this.blockRows; ++i3) {
                double[] dArray = blockRealMatrix.blocks[n2];
                double[] dArray2 = this.blocks[i3 * this.blockColumns + i2];
                int n3 = i2 * 52;
                int n4 = FastMath.min(n3 + 52, this.columns);
                int n5 = i3 * 52;
                int n6 = FastMath.min(n5 + 52, this.rows);
                int n7 = 0;
                for (int i4 = n3; i4 < n4; ++i4) {
                    int n8 = n4 - n3;
                    int n9 = i4 - n3;
                    for (int i5 = n5; i5 < n6; ++i5) {
                        dArray[n7] = dArray2[n9];
                        ++n7;
                        n9 += n8;
                    }
                }
                ++n2;
            }
        }
        return blockRealMatrix;
    }

    public int getRowDimension() {
        return this.rows;
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public double[] operate(double[] dArray) {
        if (dArray.length != this.columns) {
            throw new DimensionMismatchException(dArray.length, this.columns);
        }
        double[] dArray2 = new double[this.rows];
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                double[] dArray3 = this.blocks[i2 * this.blockColumns + i3];
                int n3 = i3 * 52;
                int n4 = FastMath.min(n3 + 52, this.columns);
                int n5 = 0;
                int n6 = n;
                while (n6 < n2) {
                    int n7;
                    double d2 = 0.0;
                    for (n7 = n3; n7 < n4 - 3; n7 += 4) {
                        d2 += dArray3[n5] * dArray[n7] + dArray3[n5 + 1] * dArray[n7 + 1] + dArray3[n5 + 2] * dArray[n7 + 2] + dArray3[n5 + 3] * dArray[n7 + 3];
                        n5 += 4;
                    }
                    while (n7 < n4) {
                        d2 += dArray3[n5++] * dArray[n7++];
                    }
                    int n8 = n6++;
                    dArray2[n8] = dArray2[n8] + d2;
                }
            }
        }
        return dArray2;
    }

    public double[] preMultiply(double[] dArray) {
        if (dArray.length != this.rows) {
            throw new DimensionMismatchException(dArray.length, this.rows);
        }
        double[] dArray2 = new double[this.columns];
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n = this.blockWidth(i2);
            int n2 = n + n;
            int n3 = n2 + n;
            int n4 = n3 + n;
            int n5 = i2 * 52;
            int n6 = FastMath.min(n5 + 52, this.columns);
            for (int i3 = 0; i3 < this.blockRows; ++i3) {
                double[] dArray3 = this.blocks[i3 * this.blockColumns + i2];
                int n7 = i3 * 52;
                int n8 = FastMath.min(n7 + 52, this.rows);
                int n9 = n5;
                while (n9 < n6) {
                    int n10;
                    int n11 = n9 - n5;
                    double d2 = 0.0;
                    for (n10 = n7; n10 < n8 - 3; n10 += 4) {
                        d2 += dArray3[n11] * dArray[n10] + dArray3[n11 + n] * dArray[n10 + 1] + dArray3[n11 + n2] * dArray[n10 + 2] + dArray3[n11 + n3] * dArray[n10 + 3];
                        n11 += n4;
                    }
                    while (n10 < n8) {
                        d2 += dArray3[n11] * dArray[n10++];
                        n11 += n;
                    }
                    int n12 = n9++;
                    dArray2[n12] = dArray2[n12] + d2;
                }
            }
        }
        return dArray2;
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        realMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int i3 = n; i3 < n2; ++i3) {
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n3 = this.blockWidth(i4);
                    int n4 = i4 * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    double[] dArray = this.blocks[i2 * this.blockColumns + i4];
                    n3 = (i3 - n) * n3;
                    while (n4 < n5) {
                        dArray[n3] = realMatrixChangingVisitor.visit(i3, n4, dArray[n3]);
                        ++n3;
                        ++n4;
                    }
                }
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        realMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int i3 = n; i3 < n2; ++i3) {
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n3 = this.blockWidth(i4);
                    int n4 = i4 * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    double[] dArray = this.blocks[i2 * this.blockColumns + i4];
                    n3 = (i3 - n) * n3;
                    while (n4 < n5) {
                        realMatrixPreservingVisitor.visit(i3, n4, dArray[n3]);
                        ++n3;
                        ++n4;
                    }
                }
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 52; i2 < 1 + n2 / 52; ++i2) {
            int n5 = i2 * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 52, n2 + 1);
            while (n6 < n7) {
                for (int i3 = n3 / 52; i3 < 1 + n4 / 52; ++i3) {
                    int n8 = this.blockWidth(i3);
                    int n9 = i3 * 52;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((i3 + 1) * 52, n4 + 1);
                    double[] dArray = this.blocks[i2 * this.blockColumns + i3];
                    n8 = (n6 - n5) * n8 + n10 - n9;
                    for (n9 = n10; n9 < n11; ++n9) {
                        dArray[n8] = realMatrixChangingVisitor.visit(n6, n9, dArray[n8]);
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 52; i2 < 1 + n2 / 52; ++i2) {
            int n5 = i2 * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 52, n2 + 1);
            while (n6 < n7) {
                for (int i3 = n3 / 52; i3 < 1 + n4 / 52; ++i3) {
                    int n8 = this.blockWidth(i3);
                    int n9 = i3 * 52;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((i3 + 1) * 52, n4 + 1);
                    double[] dArray = this.blocks[i2 * this.blockColumns + i3];
                    n8 = (n6 - n5) * n8 + n10 - n9;
                    for (n9 = n10; n9 < n11; ++n9) {
                        realMatrixPreservingVisitor.visit(n6, n9, dArray[n8]);
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        realMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                int n4 = i3 * 52;
                int n5 = FastMath.min(n4 + 52, this.columns);
                double[] dArray = this.blocks[n];
                int n6 = 0;
                for (int i4 = n2; i4 < n3; ++i4) {
                    for (int i5 = n4; i5 < n5; ++i5) {
                        dArray[n6] = realMatrixChangingVisitor.visit(i4, i5, dArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        realMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                int n4 = i3 * 52;
                int n5 = FastMath.min(n4 + 52, this.columns);
                double[] dArray = this.blocks[n];
                int n6 = 0;
                for (int i4 = n2; i4 < n3; ++i4) {
                    for (int i5 = n4; i5 < n5; ++i5) {
                        realMatrixPreservingVisitor.visit(i4, i5, dArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 52; i2 < 1 + n2 / 52; ++i2) {
            int n5 = i2 * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 52, n2 + 1);
            for (int i3 = n3 / 52; i3 < 1 + n4 / 52; ++i3) {
                int n8 = this.blockWidth(i3);
                int n9 = i3 * 52;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((i3 + 1) * 52, n4 + 1);
                double[] dArray = this.blocks[i2 * this.blockColumns + i3];
                for (int i4 = n6; i4 < n7; ++i4) {
                    int n12 = (i4 - n5) * n8 + n10 - n9;
                    for (int i5 = n10; i5 < n11; ++i5) {
                        dArray[n12] = realMatrixChangingVisitor.visit(i4, i5, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 52; i2 < 1 + n2 / 52; ++i2) {
            int n5 = i2 * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 52, n2 + 1);
            for (int i3 = n3 / 52; i3 < 1 + n4 / 52; ++i3) {
                int n8 = this.blockWidth(i3);
                int n9 = i3 * 52;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((i3 + 1) * 52, n4 + 1);
                double[] dArray = this.blocks[i2 * this.blockColumns + i3];
                for (int i4 = n6; i4 < n7; ++i4) {
                    int n12 = (i4 - n5) * n8 + n10 - n9;
                    for (int i5 = n10; i5 < n11; ++i5) {
                        realMatrixPreservingVisitor.visit(i4, i5, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    private int blockHeight(int n) {
        if (n == this.blockRows - 1) {
            return this.rows - n * 52;
        }
        return 52;
    }

    private int blockWidth(int n) {
        if (n == this.blockColumns - 1) {
            return this.columns - n * 52;
        }
        return 52;
    }
}

