/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixDimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    public static final int BLOCK_SIZE = 36;
    private static final long serialVersionUID = -4602336630143123183L;
    private final T[][] blocks;
    private final int rows;
    private final int columns;
    private final int blockRows;
    private final int blockColumns;

    public BlockFieldMatrix(Field<T> field, int n, int n2) {
        super(field, n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 36 - 1) / 36;
        this.blockColumns = (n2 + 36 - 1) / 36;
        this.blocks = BlockFieldMatrix.createBlocksLayout(field, (int)n, (int)n2);
    }

    public BlockFieldMatrix(T[][] TArray) {
        this(TArray.length, TArray[0].length, BlockFieldMatrix.toBlocksLayout(TArray), false);
    }

    public BlockFieldMatrix(int n, int n2, T[][] TArray, boolean bl) {
        super(BlockFieldMatrix.extractField(TArray), n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 36 - 1) / 36;
        this.blockColumns = (n2 + 36 - 1) / 36;
        this.blocks = bl ? (FieldElement[][])MathArrays.buildArray(this.getField(), this.blockRows * this.blockColumns, -1) : TArray;
        n = 0;
        for (n2 = 0; n2 < this.blockRows; ++n2) {
            int n3 = this.blockHeight(n2);
            int n4 = 0;
            while (n4 < this.blockColumns) {
                if (TArray[n].length != n3 * this.blockWidth(n4)) {
                    throw new DimensionMismatchException(TArray[n].length, n3 * this.blockWidth(n4));
                }
                if (bl) {
                    this.blocks[n] = (FieldElement[])TArray[n].clone();
                }
                ++n4;
                ++n;
            }
        }
    }

    public static <T extends FieldElement<T>> T[][] toBlocksLayout(T[][] TArray) {
        int n = TArray.length;
        int n2 = TArray[0].length;
        int n3 = (n + 36 - 1) / 36;
        int n4 = (n2 + 36 - 1) / 36;
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            int n5 = TArray[i2].length;
            if (n5 == n2) continue;
            throw new DimensionMismatchException(n2, n5);
        }
        Field field = BlockFieldMatrix.extractField(TArray);
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n3 * n4, -1);
        int n6 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = i3 * 36;
            int n8 = FastMath.min(n7 + 36, n);
            int n9 = n8 - n7;
            for (int i4 = 0; i4 < n4; ++i4) {
                int n10 = i4 * 36;
                int n11 = FastMath.min(n10 + 36, n2);
                FieldElement[] fieldElementArray2 = (FieldElement[])MathArrays.buildArray(field, n9 * (n11 -= n10));
                fieldElementArray[n6] = fieldElementArray2;
                int n12 = 0;
                for (int i5 = n7; i5 < n8; ++i5) {
                    System.arraycopy(TArray[i5], n10, fieldElementArray2, n12, n11);
                    n12 += n11;
                }
                ++n6;
            }
        }
        return fieldElementArray;
    }

    public static <T extends FieldElement<T>> T[][] createBlocksLayout(Field<T> field, int n, int n2) {
        int n3 = (n + 36 - 1) / 36;
        int n4 = (n2 + 36 - 1) / 36;
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n3 * n4, -1);
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 * 36;
            int n7 = FastMath.min(n6 + 36, n);
            n6 = n7 - n6;
            for (n7 = 0; n7 < n4; ++n7) {
                int n8 = n7 * 36;
                int n9 = FastMath.min(n8 + 36, n2);
                n8 = n9 - n8;
                fieldElementArray[n5] = (FieldElement[])MathArrays.buildArray(field, n6 * n8);
                ++n5;
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) {
        return new BlockFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public FieldMatrix<T> copy() {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            System.arraycopy(this.blocks[i2], 0, blockFieldMatrix.blocks[i2], 0, this.blocks[i2].length);
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> fieldMatrix) {
        try {
            return this.add((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkAdditionCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
            int n = 0;
            for (int i2 = 0; i2 < blockFieldMatrix.blockRows; ++i2) {
                for (int i3 = 0; i3 < blockFieldMatrix.blockColumns; ++i3) {
                    T[] TArray = blockFieldMatrix.blocks[n];
                    T[] TArray2 = this.blocks[n];
                    int n2 = i2 * 36;
                    int n3 = FastMath.min(n2 + 36, this.rows);
                    int n4 = i3 * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    int n6 = 0;
                    while (n2 < n3) {
                        for (int i4 = n4; i4 < n5; ++i4) {
                            TArray[n6] = (FieldElement)TArray2[n6].add(fieldMatrix.getEntry(n2, i4));
                            ++n6;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> add(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkAdditionCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i2 = 0; i2 < blockFieldMatrix2.blocks.length; ++i2) {
            T[] TArray = blockFieldMatrix2.blocks[i2];
            T[] TArray2 = this.blocks[i2];
            T[] TArray3 = blockFieldMatrix.blocks[i2];
            for (int i3 = 0; i3 < TArray.length; ++i3) {
                TArray[i3] = (FieldElement)TArray2[i3].add(TArray3[i3]);
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> fieldMatrix) {
        try {
            return this.subtract((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkSubtractionCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
            int n = 0;
            for (int i2 = 0; i2 < blockFieldMatrix.blockRows; ++i2) {
                for (int i3 = 0; i3 < blockFieldMatrix.blockColumns; ++i3) {
                    T[] TArray = blockFieldMatrix.blocks[n];
                    T[] TArray2 = this.blocks[n];
                    int n2 = i2 * 36;
                    int n3 = FastMath.min(n2 + 36, this.rows);
                    int n4 = i3 * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    int n6 = 0;
                    while (n2 < n3) {
                        for (int i4 = n4; i4 < n5; ++i4) {
                            TArray[n6] = (FieldElement)TArray2[n6].subtract(fieldMatrix.getEntry(n2, i4));
                            ++n6;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> subtract(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkSubtractionCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i2 = 0; i2 < blockFieldMatrix2.blocks.length; ++i2) {
            T[] TArray = blockFieldMatrix2.blocks[i2];
            T[] TArray2 = this.blocks[i2];
            T[] TArray3 = blockFieldMatrix.blocks[i2];
            for (int i3 = 0; i3 < TArray.length; ++i3) {
                TArray[i3] = (FieldElement)TArray2[i3].subtract(TArray3[i3]);
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T t) {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i2 = 0; i2 < blockFieldMatrix.blocks.length; ++i2) {
            T[] TArray = blockFieldMatrix.blocks[i2];
            T[] TArray2 = this.blocks[i2];
            for (int i3 = 0; i3 < TArray.length; ++i3) {
                TArray[i3] = (FieldElement)TArray2[i3].add(t);
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T t) {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i2 = 0; i2 < blockFieldMatrix.blocks.length; ++i2) {
            T[] TArray = blockFieldMatrix.blocks[i2];
            T[] TArray2 = this.blocks[i2];
            for (int i3 = 0; i3 < TArray.length; ++i3) {
                TArray[i3] = (FieldElement)TArray2[i3].multiply(t);
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> fieldMatrix) {
        try {
            return this.multiply((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkMultiplicationCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, fieldMatrix.getColumnDimension());
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            int n = 0;
            for (int i2 = 0; i2 < blockFieldMatrix.blockRows; ++i2) {
                int n2 = i2 * 36;
                int n3 = FastMath.min(n2 + 36, this.rows);
                for (int i3 = 0; i3 < blockFieldMatrix.blockColumns; ++i3) {
                    int n4 = i3 * 36;
                    int n5 = FastMath.min(n4 + 36, fieldMatrix.getColumnDimension());
                    T[] TArray = blockFieldMatrix.blocks[n];
                    for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                        int n6 = this.blockWidth(i4);
                        T[] TArray2 = this.blocks[i2 * this.blockColumns + i4];
                        int n7 = i4 * 36;
                        int n8 = 0;
                        for (int i5 = n2; i5 < n3; ++i5) {
                            int n9 = (i5 - n2) * n6;
                            int n10 = n9 + n6;
                            for (int i6 = n4; i6 < n5; ++i6) {
                                FieldElement fieldElement2 = fieldElement;
                                int n11 = n7;
                                for (int i7 = n9; i7 < n10; ++i7) {
                                    fieldElement2 = (FieldElement)fieldElement2.add(TArray2[i7].multiply(fieldMatrix.getEntry(n11, i6)));
                                    ++n11;
                                }
                                TArray[n8] = TArray[n8].add((FieldElement)fieldElement2);
                                ++n8;
                            }
                        }
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> multiply(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkMultiplicationCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, blockFieldMatrix.columns);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        int n = 0;
        for (int i2 = 0; i2 < blockFieldMatrix2.blockRows; ++i2) {
            int n2 = i2 * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int i3 = 0; i3 < blockFieldMatrix2.blockColumns; ++i3) {
                int n4 = super.blockWidth(i3);
                int n5 = n4 + n4;
                int n6 = n5 + n4;
                int n7 = n6 + n4;
                T[] TArray = blockFieldMatrix2.blocks[n];
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n8 = this.blockWidth(i4);
                    T[] TArray2 = this.blocks[i2 * this.blockColumns + i4];
                    T[] TArray3 = blockFieldMatrix.blocks[i4 * blockFieldMatrix.blockColumns + i3];
                    int n9 = 0;
                    for (int i5 = n2; i5 < n3; ++i5) {
                        int n10 = (i5 - n2) * n8;
                        int n11 = n10 + n8;
                        for (int i6 = 0; i6 < n4; ++i6) {
                            FieldElement fieldElement2 = fieldElement;
                            int n12 = n10;
                            int n13 = i6;
                            while (n12 < n11 - 3) {
                                fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n12].multiply(TArray3[n13]))).add(TArray2[n12 + 1].multiply(TArray3[n13 + n4]))).add(TArray2[n12 + 2].multiply(TArray3[n13 + n5]))).add(TArray2[n12 + 3].multiply(TArray3[n13 + n6]));
                                n12 += 4;
                                n13 += n7;
                            }
                            while (n12 < n11) {
                                fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n12++].multiply(TArray3[n13]));
                                n13 += n4;
                            }
                            TArray[n9] = TArray[n9].add((FieldElement)fieldElement2);
                            ++n9;
                        }
                    }
                }
                ++n;
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), ((AbstractFieldMatrix)this).getRowDimension(), ((AbstractFieldMatrix)this).getColumnDimension());
        int n = this.columns - (this.blockColumns - 1) * 36;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            int n4 = 0;
            int n5 = 0;
            while (n2 < n3) {
                FieldElement[] fieldElementArray2 = fieldElementArray[n2];
                int n6 = i2 * this.blockColumns;
                int n7 = 0;
                for (int i3 = 0; i3 < this.blockColumns - 1; ++i3) {
                    System.arraycopy(this.blocks[n6++], n4, fieldElementArray2, n7, 36);
                    n7 += 36;
                }
                System.arraycopy(this.blocks[n6], n5, fieldElementArray2, n7, n);
                n4 += 36;
                n5 += n;
                ++n2;
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), n2 - n + 1, n4 - n3 + 1);
        n4 = n / 36;
        n %= 36;
        int n5 = n3 / 36;
        n3 %= 36;
        for (int i2 = 0; i2 < blockFieldMatrix.blockRows; ++i2) {
            int n6 = super.blockHeight(i2);
            int n7 = n5;
            for (int i3 = 0; i3 < blockFieldMatrix.blockColumns; ++i3) {
                int n8;
                int n9 = super.blockWidth(i3);
                int n10 = i2 * blockFieldMatrix.blockColumns + i3;
                T[] TArray = blockFieldMatrix.blocks[n10];
                int n11 = n4 * this.blockColumns + n7;
                int n12 = this.blockWidth(n7);
                int n13 = n6 + n - 36;
                int n14 = n9 + n3 - 36;
                if (n13 > 0) {
                    if (n14 > 0) {
                        n8 = this.blockWidth(n7 + 1);
                        BlockFieldMatrix blockFieldMatrix2 = this;
                        blockFieldMatrix2.copyBlockPart((FieldElement[])blockFieldMatrix2.blocks[n11], n12, n, 36, n3, 36, (FieldElement[])TArray, n9, 0, 0);
                        BlockFieldMatrix blockFieldMatrix3 = this;
                        blockFieldMatrix3.copyBlockPart((FieldElement[])blockFieldMatrix3.blocks[n11 + 1], n8, n, 36, 0, n14, (FieldElement[])TArray, n9, 0, n9 - n14);
                        BlockFieldMatrix blockFieldMatrix4 = this;
                        blockFieldMatrix4.copyBlockPart((FieldElement[])blockFieldMatrix4.blocks[n11 + this.blockColumns], n12, 0, n13, n3, 36, (FieldElement[])TArray, n9, n6 - n13, 0);
                        BlockFieldMatrix blockFieldMatrix5 = this;
                        blockFieldMatrix5.copyBlockPart((FieldElement[])blockFieldMatrix5.blocks[n11 + this.blockColumns + 1], n8, 0, n13, 0, n14, (FieldElement[])TArray, n9, n6 - n13, n9 - n14);
                    } else {
                        BlockFieldMatrix blockFieldMatrix6 = this;
                        blockFieldMatrix6.copyBlockPart((FieldElement[])blockFieldMatrix6.blocks[n11], n12, n, 36, n3, n9 + n3, (FieldElement[])TArray, n9, 0, 0);
                        BlockFieldMatrix blockFieldMatrix7 = this;
                        blockFieldMatrix7.copyBlockPart((FieldElement[])blockFieldMatrix7.blocks[n11 + this.blockColumns], n12, 0, n13, n3, n9 + n3, (FieldElement[])TArray, n9, n6 - n13, 0);
                    }
                } else if (n14 > 0) {
                    n8 = this.blockWidth(n7 + 1);
                    BlockFieldMatrix blockFieldMatrix8 = this;
                    blockFieldMatrix8.copyBlockPart((FieldElement[])blockFieldMatrix8.blocks[n11], n12, n, n6 + n, n3, 36, (FieldElement[])TArray, n9, 0, 0);
                    BlockFieldMatrix blockFieldMatrix9 = this;
                    blockFieldMatrix9.copyBlockPart((FieldElement[])blockFieldMatrix9.blocks[n11 + 1], n8, n, n6 + n, 0, n14, (FieldElement[])TArray, n9, 0, n9 - n14);
                } else {
                    BlockFieldMatrix blockFieldMatrix10 = this;
                    blockFieldMatrix10.copyBlockPart((FieldElement[])blockFieldMatrix10.blocks[n11], n12, n, n6 + n, n3, n9 + n3, (FieldElement[])TArray, n9, 0, 0);
                }
                ++n7;
            }
            ++n4;
        }
        return blockFieldMatrix;
    }

    private void copyBlockPart(T[] TArray, int n, int n2, int n3, int n4, int n5, T[] TArray2, int n6, int n7, int n8) {
        n5 -= n4;
        n4 = n2 * n + n4;
        n7 = n7 * n6 + n8;
        while (n2 < n3) {
            System.arraycopy(TArray, n4, TArray2, n7, n5);
            n4 += n;
            n7 += n6;
            ++n2;
        }
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) {
        int n3;
        MathUtils.checkNotNull(TArray);
        int n4 = TArray[0].length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        int n5 = n + TArray.length - 1;
        int n6 = n2 + n4 - 1;
        this.checkSubMatrixIndex(n, n5, n2, n6);
        T[][] TArray2 = TArray;
        int n7 = TArray.length;
        for (n3 = 0; n3 < n7; ++n3) {
            T[] TArray3 = TArray2[n3];
            if (TArray3.length == n4) continue;
            throw new DimensionMismatchException(n4, TArray3.length);
        }
        int n8 = n / 36;
        n7 = (n5 + 36) / 36;
        n3 = n2 / 36;
        int n9 = (n6 + 36) / 36;
        for (n4 = n8; n4 < n7; ++n4) {
            n8 = this.blockHeight(n4);
            int n10 = n4 * 36;
            int n11 = FastMath.max(n, n10);
            n8 = FastMath.min(n5 + 1, n10 + n8);
            for (int i2 = n3; i2 < n9; ++i2) {
                int n12 = this.blockWidth(i2);
                int n13 = i2 * 36;
                int n14 = FastMath.max(n2, n13);
                int n15 = FastMath.min(n6 + 1, n13 + n12);
                n15 -= n14;
                T[] TArray4 = this.blocks[n4 * this.blockColumns + i2];
                for (int i3 = n11; i3 < n8; ++i3) {
                    System.arraycopy(TArray[i3 - n], n14 - n2, TArray4, (i3 - n10) * n12 + (n14 - n13), n15);
                }
            }
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int n) {
        this.checkRowIndex(n);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), 1, this.columns);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = 0;
        int n4 = 0;
        T[] TArray = blockFieldMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n5 = this.blockWidth(i2);
            T[] TArray2 = this.blocks[n2 * this.blockColumns + i2];
            int n6 = TArray.length - n4;
            if (n5 > n6) {
                System.arraycopy(TArray2, n * n5, TArray, n4, n6);
                TArray = blockFieldMatrix.blocks[++n3];
                System.arraycopy(TArray2, n * n5, TArray, 0, n5 - n6);
                n4 = n5 - n6;
                continue;
            }
            System.arraycopy(TArray2, n * n5, TArray, n4, n5);
            n4 += n5;
        }
        return blockFieldMatrix;
    }

    @Override
    public void setRowMatrix(int n, FieldMatrix<T> fieldMatrix) {
        try {
            this.setRowMatrix(n, (BlockFieldMatrix)fieldMatrix);
            return;
        }
        catch (ClassCastException classCastException) {
            super.setRowMatrix(n, fieldMatrix);
            return;
        }
    }

    @Override
    public void setRowMatrix(int n, BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkRowIndex(n);
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        if (((AbstractFieldMatrix)blockFieldMatrix).getRowDimension() != 1 || ((AbstractFieldMatrix)blockFieldMatrix).getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(((AbstractFieldMatrix)blockFieldMatrix).getRowDimension(), ((AbstractFieldMatrix)blockFieldMatrix).getColumnDimension(), 1, n2);
        }
        n2 = n / 36;
        n -= n2 * 36;
        int n3 = 0;
        int n4 = 0;
        T[] TArray = blockFieldMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n5 = this.blockWidth(i2);
            T[] TArray2 = this.blocks[n2 * this.blockColumns + i2];
            int n6 = TArray.length - n4;
            if (n5 > n6) {
                System.arraycopy(TArray, n4, TArray2, n * n5, n6);
                TArray = blockFieldMatrix.blocks[++n3];
                System.arraycopy(TArray, 0, TArray2, n * n5, n5 - n6);
                n4 = n5 - n6;
                continue;
            }
            System.arraycopy(TArray, n4, TArray2, n * n5, n5);
            n4 += n5;
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int n) {
        this.checkColumnIndex(n);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, 1);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        int n5 = 0;
        T[] TArray = blockFieldMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n6 = this.blockHeight(i2);
            T[] TArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n6; ++i3) {
                if (n5 >= TArray.length) {
                    TArray = blockFieldMatrix.blocks[++n4];
                    n5 = 0;
                }
                TArray[n5++] = TArray2[i3 * n3 + n];
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public void setColumnMatrix(int n, FieldMatrix<T> fieldMatrix) {
        try {
            this.setColumnMatrix(n, (BlockFieldMatrix)fieldMatrix);
            return;
        }
        catch (ClassCastException classCastException) {
            super.setColumnMatrix(n, fieldMatrix);
            return;
        }
    }

    @Override
    void setColumnMatrix(int n, BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkColumnIndex(n);
        int n2 = ((AbstractFieldMatrix)this).getRowDimension();
        if (((AbstractFieldMatrix)blockFieldMatrix).getRowDimension() != n2 || ((AbstractFieldMatrix)blockFieldMatrix).getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(((AbstractFieldMatrix)blockFieldMatrix).getRowDimension(), ((AbstractFieldMatrix)blockFieldMatrix).getColumnDimension(), n2, 1);
        }
        n2 = n / 36;
        n -= n2 * 36;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        int n5 = 0;
        T[] TArray = blockFieldMatrix.blocks[0];
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n6 = this.blockHeight(i2);
            T[] TArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n6; ++i3) {
                if (n5 >= TArray.length) {
                    TArray = blockFieldMatrix.blocks[++n4];
                    n5 = 0;
                }
                TArray2[i3 * n3 + n] = TArray[n5++];
            }
        }
    }

    @Override
    public FieldVector<T> getRowVector(int n) {
        this.checkRowIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            T[] TArray = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(TArray, n * n4, fieldElementArray, n3, n4);
            n3 += n4;
        }
        return new ArrayFieldVector(this.getField(), fieldElementArray, false);
    }

    @Override
    public void setRowVector(int n, FieldVector<T> fieldVector) {
        try {
            this.setRow(n, ((ArrayFieldVector)fieldVector).getDataRef());
            return;
        }
        catch (ClassCastException classCastException) {
            super.setRowVector(n, fieldVector);
            return;
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int n) {
        this.checkColumnIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            T[] TArray = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                fieldElementArray[n4++] = TArray[i3 * n3 + n];
            }
        }
        return new ArrayFieldVector(this.getField(), fieldElementArray, false);
    }

    @Override
    public void setColumnVector(int n, FieldVector<T> fieldVector) {
        try {
            this.setColumn(n, ((ArrayFieldVector)fieldVector).getDataRef());
            return;
        }
        catch (ClassCastException classCastException) {
            super.setColumnVector(n, fieldVector);
            return;
        }
    }

    @Override
    public T[] getRow(int n) {
        this.checkRowIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            T[] TArray = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(TArray, n * n4, fieldElementArray, n3, n4);
            n3 += n4;
        }
        return fieldElementArray;
    }

    @Override
    public void setRow(int n, T[] TArray) {
        this.checkRowIndex(n);
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, TArray.length, 1, n2);
        }
        n2 = n / 36;
        n -= n2 * 36;
        int n3 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n4 = this.blockWidth(i2);
            T[] TArray2 = this.blocks[n2 * this.blockColumns + i2];
            System.arraycopy(TArray, n3, TArray2, n * n4, n4);
            n3 += n4;
        }
    }

    @Override
    public T[] getColumn(int n) {
        this.checkColumnIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        int n2 = n / 36;
        n -= n2 * 36;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            T[] TArray = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                fieldElementArray[n4++] = TArray[i3 * n3 + n];
            }
        }
        return fieldElementArray;
    }

    @Override
    public void setColumn(int n, T[] TArray) {
        this.checkColumnIndex(n);
        int n2 = ((AbstractFieldMatrix)this).getRowDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(TArray.length, 1, n2, 1);
        }
        n2 = n / 36;
        n -= n2 * 36;
        int n3 = this.blockWidth(n2);
        int n4 = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n5 = this.blockHeight(i2);
            T[] TArray2 = this.blocks[i2 * this.blockColumns + n2];
            for (int i3 = 0; i3 < n5; ++i3) {
                TArray2[i3 * n3 + n] = TArray[n4++];
            }
        }
    }

    @Override
    public T getEntry(int n, int n2) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        n = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        return this.blocks[n3 * this.blockColumns + n4][n];
    }

    @Override
    public void setEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        n = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        this.blocks[n3 * this.blockColumns + n4][n] = t;
    }

    @Override
    public void addToEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        n = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        T[] TArray = this.blocks[n3 * this.blockColumns + n4];
        T[] TArray2 = TArray;
        TArray[n] = (FieldElement)TArray2[n].add(t);
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        n = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        T[] TArray = this.blocks[n3 * this.blockColumns + n4];
        T[] TArray2 = TArray;
        TArray[n] = (FieldElement)TArray2[n].multiply(t);
    }

    @Override
    public FieldMatrix<T> transpose() {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), n2, n);
        n2 = 0;
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            for (int i3 = 0; i3 < this.blockRows; ++i3) {
                T[] TArray = blockFieldMatrix.blocks[n2];
                T[] TArray2 = this.blocks[i3 * this.blockColumns + i2];
                int n3 = i2 * 36;
                int n4 = FastMath.min(n3 + 36, this.columns);
                int n5 = i3 * 36;
                int n6 = FastMath.min(n5 + 36, this.rows);
                int n7 = 0;
                for (int i4 = n3; i4 < n4; ++i4) {
                    int n8 = n4 - n3;
                    int n9 = i4 - n3;
                    for (int i5 = n5; i5 < n6; ++i5) {
                        TArray[n7] = TArray2[n9];
                        ++n7;
                        n9 += n8;
                    }
                }
                ++n2;
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public T[] operate(T[] TArray) {
        if (TArray.length != this.columns) {
            throw new DimensionMismatchException(TArray.length, this.columns);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                T[] TArray2 = this.blocks[i2 * this.blockColumns + i3];
                int n3 = i3 * 36;
                int n4 = FastMath.min(n3 + 36, this.columns);
                int n5 = 0;
                for (int i4 = n; i4 < n2; ++i4) {
                    int n6;
                    FieldElement fieldElement2 = fieldElement;
                    for (n6 = n3; n6 < n4 - 3; n6 += 4) {
                        fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n5].multiply(TArray[n6]))).add(TArray2[n5 + 1].multiply(TArray[n6 + 1]))).add(TArray2[n5 + 2].multiply(TArray[n6 + 2]))).add(TArray2[n5 + 3].multiply(TArray[n6 + 3]));
                        n5 += 4;
                    }
                    while (n6 < n4) {
                        fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n5++].multiply(TArray[n6++]));
                    }
                    fieldElementArray[i4] = fieldElementArray[i4].add(fieldElement2);
                }
            }
        }
        return fieldElementArray;
    }

    @Override
    public T[] preMultiply(T[] TArray) {
        if (TArray.length != this.rows) {
            throw new DimensionMismatchException(TArray.length, this.rows);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < this.blockColumns; ++i2) {
            int n = this.blockWidth(i2);
            int n2 = n + n;
            int n3 = n2 + n;
            int n4 = n3 + n;
            int n5 = i2 * 36;
            int n6 = FastMath.min(n5 + 36, this.columns);
            for (int i3 = 0; i3 < this.blockRows; ++i3) {
                T[] TArray2 = this.blocks[i3 * this.blockColumns + i2];
                int n7 = i3 * 36;
                int n8 = FastMath.min(n7 + 36, this.rows);
                for (int i4 = n5; i4 < n6; ++i4) {
                    int n9;
                    int n10 = i4 - n5;
                    FieldElement fieldElement2 = fieldElement;
                    for (n9 = n7; n9 < n8 - 3; n9 += 4) {
                        fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n10].multiply(TArray[n9]))).add(TArray2[n10 + n].multiply(TArray[n9 + 1]))).add(TArray2[n10 + n2].multiply(TArray[n9 + 2]))).add(TArray2[n10 + n3].multiply(TArray[n9 + 3]));
                        n10 += n4;
                    }
                    while (n9 < n8) {
                        fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n10].multiply(TArray[n9++]));
                        n10 += n;
                    }
                    fieldElementArray[i4] = fieldElementArray[i4].add(fieldElement2);
                }
            }
        }
        return fieldElementArray;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        fieldMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int i3 = n; i3 < n2; ++i3) {
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n3 = this.blockWidth(i4);
                    int n4 = i4 * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    T[] TArray = this.blocks[i2 * this.blockColumns + i4];
                    n3 = (i3 - n) * n3;
                    while (n4 < n5) {
                        TArray[n3] = fieldMatrixChangingVisitor.visit(i3, n4, TArray[n3]);
                        ++n3;
                        ++n4;
                    }
                }
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n = i2 * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int i3 = n; i3 < n2; ++i3) {
                for (int i4 = 0; i4 < this.blockColumns; ++i4) {
                    int n3 = this.blockWidth(i4);
                    int n4 = i4 * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    T[] TArray = this.blocks[i2 * this.blockColumns + i4];
                    n3 = (i3 - n) * n3;
                    while (n4 < n5) {
                        fieldMatrixPreservingVisitor.visit(i3, n4, TArray[n3]);
                        ++n3;
                        ++n4;
                    }
                }
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 36; i2 < 1 + n2 / 36; ++i2) {
            int n5 = i2 * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 36, n2 + 1);
            while (n6 < n7) {
                for (int i3 = n3 / 36; i3 < 1 + n4 / 36; ++i3) {
                    int n8 = this.blockWidth(i3);
                    int n9 = i3 * 36;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((i3 + 1) * 36, n4 + 1);
                    T[] TArray = this.blocks[i2 * this.blockColumns + i3];
                    n8 = (n6 - n5) * n8 + n10 - n9;
                    for (n9 = n10; n9 < n11; ++n9) {
                        TArray[n8] = fieldMatrixChangingVisitor.visit(n6, n9, TArray[n8]);
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 36; i2 < 1 + n2 / 36; ++i2) {
            int n5 = i2 * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 36, n2 + 1);
            while (n6 < n7) {
                for (int i3 = n3 / 36; i3 < 1 + n4 / 36; ++i3) {
                    int n8 = this.blockWidth(i3);
                    int n9 = i3 * 36;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((i3 + 1) * 36, n4 + 1);
                    T[] TArray = this.blocks[i2 * this.blockColumns + i3];
                    n8 = (n6 - n5) * n8 + n10 - n9;
                    for (n9 = n10; n9 < n11; ++n9) {
                        fieldMatrixPreservingVisitor.visit(n6, n9, TArray[n8]);
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        fieldMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                int n4 = i3 * 36;
                int n5 = FastMath.min(n4 + 36, this.columns);
                T[] TArray = this.blocks[n];
                int n6 = 0;
                for (int i4 = n2; i4 < n3; ++i4) {
                    for (int i5 = n4; i5 < n5; ++i5) {
                        TArray[n6] = fieldMatrixChangingVisitor.visit(i4, i5, TArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i2 = 0; i2 < this.blockRows; ++i2) {
            int n2 = i2 * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int i3 = 0; i3 < this.blockColumns; ++i3) {
                int n4 = i3 * 36;
                int n5 = FastMath.min(n4 + 36, this.columns);
                T[] TArray = this.blocks[n];
                int n6 = 0;
                for (int i4 = n2; i4 < n3; ++i4) {
                    for (int i5 = n4; i5 < n5; ++i5) {
                        fieldMatrixPreservingVisitor.visit(i4, i5, TArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 36; i2 < 1 + n2 / 36; ++i2) {
            int n5 = i2 * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 36, n2 + 1);
            for (int i3 = n3 / 36; i3 < 1 + n4 / 36; ++i3) {
                int n8 = this.blockWidth(i3);
                int n9 = i3 * 36;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((i3 + 1) * 36, n4 + 1);
                T[] TArray = this.blocks[i2 * this.blockColumns + i3];
                for (int i4 = n6; i4 < n7; ++i4) {
                    int n12 = (i4 - n5) * n8 + n10 - n9;
                    for (int i5 = n10; i5 < n11; ++i5) {
                        TArray[n12] = fieldMatrixChangingVisitor.visit(i4, i5, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i2 = n / 36; i2 < 1 + n2 / 36; ++i2) {
            int n5 = i2 * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i2 + 1) * 36, n2 + 1);
            for (int i3 = n3 / 36; i3 < 1 + n4 / 36; ++i3) {
                int n8 = this.blockWidth(i3);
                int n9 = i3 * 36;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((i3 + 1) * 36, n4 + 1);
                T[] TArray = this.blocks[i2 * this.blockColumns + i3];
                for (int i4 = n6; i4 < n7; ++i4) {
                    int n12 = (i4 - n5) * n8 + n10 - n9;
                    for (int i5 = n10; i5 < n11; ++i5) {
                        fieldMatrixPreservingVisitor.visit(i4, i5, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    private int blockHeight(int n) {
        if (n == this.blockRows - 1) {
            return this.rows - n * 36;
        }
        return 36;
    }

    private int blockWidth(int n) {
        if (n == this.blockColumns - 1) {
            return this.columns - n * 36;
        }
        return 36;
    }
}

