/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

class BiDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedU;
    private RealMatrix cachedB;
    private RealMatrix cachedV;

    BiDiagonalTransformer(RealMatrix realMatrix) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        int n3 = FastMath.min(n, n2);
        this.householderVectors = realMatrix.getData();
        this.main = new double[n3];
        this.secondary = new double[n3 - 1];
        this.cachedU = null;
        this.cachedB = null;
        this.cachedV = null;
        if (n >= n2) {
            this.transformToUpperBiDiagonal();
            return;
        }
        this.transformToLowerBiDiagonal();
    }

    public RealMatrix getU() {
        if (this.cachedU == null) {
            int n;
            int n2 = this.householderVectors.length;
            int n3 = this.householderVectors[0].length;
            int n4 = this.main.length;
            int n5 = n2 >= n3 ? 0 : 1;
            double[] dArray = n2 >= n3 ? this.main : this.secondary;
            int n6 = n2;
            double[][] dArray2 = new double[n6][n6];
            for (n = n2 - 1; n >= n4; --n) {
                dArray2[n][n] = 1.0;
            }
            for (n = n4 - 1; n >= n5; --n) {
                double[] dArray3 = this.householderVectors[n];
                dArray2[n][n] = 1.0;
                if (dArray3[n - n5] == 0.0) continue;
                for (int i2 = n; i2 < n2; ++i2) {
                    int n7;
                    double d2 = 0.0;
                    for (n7 = n; n7 < n2; ++n7) {
                        d2 -= dArray2[n7][i2] * this.householderVectors[n7][n - n5];
                    }
                    d2 /= dArray[n - n5] * dArray3[n - n5];
                    for (n7 = n; n7 < n2; ++n7) {
                        double[] dArray4 = dArray2[n7];
                        int n8 = i2;
                        dArray4[n8] = dArray4[n8] + -d2 * this.householderVectors[n7][n - n5];
                    }
                }
            }
            if (n5 > 0) {
                dArray2[0][0] = 1.0;
            }
            this.cachedU = MatrixUtils.createRealMatrix(dArray2);
        }
        return this.cachedU;
    }

    public RealMatrix getB() {
        if (this.cachedB == null) {
            int n = this.householderVectors.length;
            int n2 = this.householderVectors[0].length;
            double[][] dArray = new double[n][n2];
            for (int i2 = 0; i2 < this.main.length; ++i2) {
                dArray[i2][i2] = this.main[i2];
                if (n < n2) {
                    if (i2 <= 0) continue;
                    dArray[i2][i2 - 1] = this.secondary[i2 - 1];
                    continue;
                }
                if (i2 >= this.main.length - 1) continue;
                dArray[i2][i2 + 1] = this.secondary[i2];
            }
            this.cachedB = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedB;
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int n;
            int n2 = this.householderVectors.length;
            int n3 = this.householderVectors[0].length;
            int n4 = this.main.length;
            int n5 = n2 >= n3 ? 1 : 0;
            double[] dArray = n2 >= n3 ? this.secondary : this.main;
            int n6 = n3;
            double[][] dArray2 = new double[n6][n6];
            for (n = n3 - 1; n >= n4; --n) {
                dArray2[n][n] = 1.0;
            }
            for (n = n4 - 1; n >= n5; --n) {
                double[] dArray3 = this.householderVectors[n - n5];
                dArray2[n][n] = 1.0;
                if (dArray3[n] == 0.0) continue;
                for (int i2 = n; i2 < n3; ++i2) {
                    int n7;
                    double d2 = 0.0;
                    for (n7 = n; n7 < n3; ++n7) {
                        d2 -= dArray2[n7][i2] * dArray3[n7];
                    }
                    d2 /= dArray[n - n5] * dArray3[n];
                    for (n7 = n; n7 < n3; ++n7) {
                        double[] dArray4 = dArray2[n7];
                        int n8 = i2;
                        dArray4[n8] = dArray4[n8] + -d2 * dArray3[n7];
                    }
                }
            }
            if (n5 > 0) {
                dArray2[0][0] = 1.0;
            }
            this.cachedV = MatrixUtils.createRealMatrix(dArray2);
        }
        return this.cachedV;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    boolean isUpperBiDiagonal() {
        return this.householderVectors.length >= this.householderVectors[0].length;
    }

    private void transformToUpperBiDiagonal() {
        int n = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            double d3;
            int n3;
            double[] dArray;
            double d4;
            double d5 = 0.0;
            for (int i3 = i2; i3 < n; ++i3) {
                double d6 = d4 = this.householderVectors[i3][i2];
                d5 += d6 * d6;
            }
            double[] dArray2 = this.householderVectors[i2];
            this.main[i2] = d4 = dArray[i2] > 0.0 ? -FastMath.sqrt(d5) : FastMath.sqrt(d5);
            if (d4 != 0.0) {
                int n4 = i2;
                dArray2[n4] = dArray2[n4] - d4;
                for (n3 = i2 + 1; n3 < n2; ++n3) {
                    double[] dArray3;
                    int n5;
                    d3 = 0.0;
                    for (n5 = i2; n5 < n; ++n5) {
                        dArray3 = this.householderVectors[n5];
                        d3 -= dArray3[n3] * dArray3[i2];
                    }
                    d3 /= d4 * this.householderVectors[i2][i2];
                    for (n5 = i2; n5 < n; ++n5) {
                        double[] dArray4 = this.householderVectors[n5];
                        dArray3 = dArray4;
                        int n6 = n3;
                        dArray4[n6] = dArray4[n6] - d3 * dArray3[i2];
                    }
                }
            }
            if (i2 >= n2 - 1) continue;
            d5 = 0.0;
            for (n3 = i2 + 1; n3 < n2; ++n3) {
                double d7 = d3 = dArray2[n3];
                d5 += d7 * d7;
            }
            this.secondary[i2] = d2 = dArray2[i2 + 1] > 0.0 ? -FastMath.sqrt(d5) : FastMath.sqrt(d5);
            if (d2 == 0.0) continue;
            int n7 = i2 + 1;
            dArray2[n7] = dArray2[n7] - d2;
            for (int i4 = i2 + 1; i4 < n; ++i4) {
                int n8;
                double[] dArray5 = this.householderVectors[i4];
                double d8 = 0.0;
                for (n8 = i2 + 1; n8 < n2; ++n8) {
                    d8 -= dArray5[n8] * dArray2[n8];
                }
                d8 /= d2 * dArray2[i2 + 1];
                for (n8 = i2 + 1; n8 < n2; ++n8) {
                    int n9 = n8;
                    dArray5[n9] = dArray5[n9] - d8 * dArray2[n8];
                }
            }
        }
    }

    private void transformToLowerBiDiagonal() {
        int n = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d2;
            double d3;
            double d4;
            double[] dArray = this.householderVectors[i2];
            double d5 = 0.0;
            for (int i3 = i2; i3 < n2; ++i3) {
                double d6;
                double d7 = d6 = dArray[i3];
                d5 += d7 * d7;
            }
            this.main[i2] = d4 = dArray[i2] > 0.0 ? -FastMath.sqrt(d5) : FastMath.sqrt(d5);
            if (d4 != 0.0) {
                int n3 = i2;
                dArray[n3] = dArray[n3] - d4;
                for (int i4 = i2 + 1; i4 < n; ++i4) {
                    int n4;
                    double[] dArray2 = this.householderVectors[i4];
                    d3 = 0.0;
                    for (n4 = i2; n4 < n2; ++n4) {
                        d3 -= dArray2[n4] * dArray[n4];
                    }
                    d3 /= d4 * this.householderVectors[i2][i2];
                    for (n4 = i2; n4 < n2; ++n4) {
                        int n5 = n4;
                        dArray2[n5] = dArray2[n5] - d3 * dArray[n4];
                    }
                }
            }
            if (i2 >= n - 1) continue;
            double[] dArray3 = this.householderVectors[i2 + 1];
            d5 = 0.0;
            for (int i5 = i2 + 1; i5 < n; ++i5) {
                double d8 = d3 = this.householderVectors[i5][i2];
                d5 += d8 * d8;
            }
            this.secondary[i2] = d2 = dArray3[i2] > 0.0 ? -FastMath.sqrt(d5) : FastMath.sqrt(d5);
            if (d2 == 0.0) continue;
            int n6 = i2;
            dArray3[n6] = dArray3[n6] - d2;
            for (int i6 = i2 + 1; i6 < n2; ++i6) {
                int n7;
                double d9 = 0.0;
                for (n7 = i2 + 1; n7 < n; ++n7) {
                    double[] dArray4 = this.householderVectors[n7];
                    d9 -= dArray4[i6] * dArray4[i2];
                }
                d9 /= d2 * dArray3[i2];
                for (n7 = i2 + 1; n7 < n; ++n7) {
                    double[] dArray5 = this.householderVectors[n7];
                    double[] dArray6 = dArray5;
                    int n8 = i6;
                    dArray5[n8] = dArray5[n8] - d9 * dArray6[i2];
                }
            }
        }
    }
}

