/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector$Entry;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVectorChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVectorFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVectorPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.Arrays;

public class ArrayRealVector
extends RealVector
implements Serializable {
    private static final long serialVersionUID = -1097961340710804027L;
    private static final RealVectorFormat DEFAULT_FORMAT = RealVectorFormat.getInstance();
    private double[] data;

    public ArrayRealVector() {
        this.data = new double[0];
    }

    public ArrayRealVector(int n) {
        this.data = new double[n];
    }

    public ArrayRealVector(int n, double d2) {
        this.data = new double[n];
        Arrays.fill(this.data, d2);
    }

    public ArrayRealVector(double[] dArray) {
        this.data = (double[])dArray.clone();
    }

    public ArrayRealVector(double[] dArray, boolean bl) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        this.data = bl ? (double[])dArray.clone() : dArray;
    }

    public ArrayRealVector(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)dArray.length, true);
        }
        this.data = new double[n2];
        System.arraycopy(dArray, n, this.data, 0, n2);
    }

    public ArrayRealVector(Double[] doubleArray) {
        this.data = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            this.data[i2] = doubleArray[i2];
        }
    }

    public ArrayRealVector(Double[] doubleArray, int n, int n2) {
        if (doubleArray == null) {
            throw new NullArgumentException();
        }
        if (doubleArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)doubleArray.length, true);
        }
        this.data = new double[n2];
        for (int i2 = n; i2 < n + n2; ++i2) {
            this.data[i2 - n] = doubleArray[i2];
        }
    }

    public ArrayRealVector(RealVector realVector) {
        if (realVector == null) {
            throw new NullArgumentException();
        }
        this.data = new double[realVector.getDimension()];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = realVector.getEntry(i2);
        }
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector) {
        this(arrayRealVector, true);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, boolean bl) {
        this.data = bl ? (double[])arrayRealVector.data.clone() : arrayRealVector.data;
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, ArrayRealVector arrayRealVector2) {
        this.data = new double[arrayRealVector.data.length + arrayRealVector2.data.length];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, arrayRealVector.data.length);
        System.arraycopy(arrayRealVector2.data, 0, this.data, arrayRealVector.data.length, arrayRealVector2.data.length);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, RealVector realVector) {
        int n = arrayRealVector.data.length;
        int n2 = realVector.getDimension();
        this.data = new double[n + n2];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, n);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.data[n + i2] = realVector.getEntry(i2);
        }
    }

    public ArrayRealVector(RealVector realVector, ArrayRealVector arrayRealVector) {
        int n = realVector.getDimension();
        int n2 = arrayRealVector.data.length;
        this.data = new double[n + n2];
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2] = realVector.getEntry(i2);
        }
        System.arraycopy(arrayRealVector.data, 0, this.data, n, n2);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, double[] dArray) {
        int n = ((RealVector)arrayRealVector).getDimension();
        int n2 = dArray.length;
        this.data = new double[n + n2];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, n);
        System.arraycopy(dArray, 0, this.data, n, n2);
    }

    public ArrayRealVector(double[] dArray, ArrayRealVector arrayRealVector) {
        int n = dArray.length;
        int n2 = ((RealVector)arrayRealVector).getDimension();
        this.data = new double[n + n2];
        System.arraycopy(dArray, 0, this.data, 0, n);
        System.arraycopy(arrayRealVector.data, 0, this.data, n, n2);
    }

    public ArrayRealVector(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        this.data = new double[n + n2];
        System.arraycopy(dArray, 0, this.data, 0, n);
        System.arraycopy(dArray2, 0, this.data, n, n2);
    }

    public ArrayRealVector copy() {
        return new ArrayRealVector(this, true);
    }

    public ArrayRealVector add(RealVector object) {
        if (object instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)object).data;
            int n = ((ArrayRealVector)object).data.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i2 = 0; i2 < n; ++i2) {
                dArray2[i2] = this.data[i2] + dArray[i2];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions((RealVector)object);
        double[] dArray = (double[])this.data.clone();
        object = ((RealVector)object).iterator();
        while (object.hasNext()) {
            RealVector$Entry realVector$Entry = (RealVector$Entry)object.next();
            int n = realVector$Entry.getIndex();
            dArray[n] = dArray[n] + realVector$Entry.getValue();
        }
        return new ArrayRealVector(dArray, false);
    }

    public ArrayRealVector subtract(RealVector object) {
        if (object instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)object).data;
            int n = ((ArrayRealVector)object).data.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i2 = 0; i2 < n; ++i2) {
                dArray2[i2] = this.data[i2] - dArray[i2];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions((RealVector)object);
        double[] dArray = (double[])this.data.clone();
        object = ((RealVector)object).iterator();
        while (object.hasNext()) {
            RealVector$Entry realVector$Entry = (RealVector$Entry)object.next();
            int n = realVector$Entry.getIndex();
            dArray[n] = dArray[n] - realVector$Entry.getValue();
        }
        return new ArrayRealVector(dArray, false);
    }

    public ArrayRealVector map(UnivariateFunction univariateFunction) {
        return this.copy().mapToSelf(univariateFunction);
    }

    public ArrayRealVector mapToSelf(UnivariateFunction univariateFunction) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = univariateFunction.value(this.data[i2]);
        }
        return this;
    }

    public RealVector mapAddToSelf(double d2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d2;
        }
        return this;
    }

    public RealVector mapSubtractToSelf(double d2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d2;
        }
        return this;
    }

    public RealVector mapMultiplyToSelf(double d2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d2;
        }
        return this;
    }

    public RealVector mapDivideToSelf(double d2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] / d2;
        }
        return this;
    }

    public ArrayRealVector ebeMultiply(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = ((ArrayRealVector)realVector).data.length;
            this.checkVectorDimensions(n);
            realVector = new ArrayRealVector(n);
            double[] dArray2 = ((ArrayRealVector)realVector).data;
            for (int i2 = 0; i2 < n; ++i2) {
                dArray2[i2] = this.data[i2] * dArray[i2];
            }
            return realVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            int n = i3;
            dArray[n] = dArray[n] * realVector.getEntry(i3);
        }
        return new ArrayRealVector(dArray, false);
    }

    public ArrayRealVector ebeDivide(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = ((ArrayRealVector)realVector).data.length;
            this.checkVectorDimensions(n);
            realVector = new ArrayRealVector(n);
            double[] dArray2 = ((ArrayRealVector)realVector).data;
            for (int i2 = 0; i2 < n; ++i2) {
                dArray2[i2] = this.data[i2] / dArray[i2];
            }
            return realVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            int n = i3;
            dArray[n] = dArray[n] / realVector.getEntry(i3);
        }
        return new ArrayRealVector(dArray, false);
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double dotProduct(RealVector object) {
        if (object instanceof ArrayRealVector) {
            object = ((ArrayRealVector)object).data;
            this.checkVectorDimensions(((Object)object).length);
            double d2 = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                d2 += this.data[i2] * object[i2];
            }
            return d2;
        }
        return super.dotProduct((RealVector)object);
    }

    public double getNorm() {
        double d2 = 0.0;
        double[] dArray = this.data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d3;
            double d4 = d3 = dArray[i2];
            d2 += d4 * d4;
        }
        return FastMath.sqrt(d2);
    }

    public double getL1Norm() {
        double d2 = 0.0;
        double[] dArray = this.data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d3 = dArray[i2];
            d2 += FastMath.abs(d3);
        }
        return d2;
    }

    public double getLInfNorm() {
        double d2 = 0.0;
        double[] dArray = this.data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d3 = dArray[i2];
            d2 = FastMath.max(d2, FastMath.abs(d3));
        }
        return d2;
    }

    public double getDistance(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d2 = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double d3;
                double d4 = d3 = this.data[i2] - dArray[i2];
                d2 += d4 * d4;
            }
            return FastMath.sqrt(d2);
        }
        this.checkVectorDimensions(realVector);
        double d5 = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double d6;
            double d7 = d6 = this.data[i3] - realVector.getEntry(i3);
            d5 += d7 * d7;
        }
        return FastMath.sqrt(d5);
    }

    public double getL1Distance(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d2 = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double d3 = this.data[i2] - dArray[i2];
                d2 += FastMath.abs(d3);
            }
            return d2;
        }
        this.checkVectorDimensions(realVector);
        double d4 = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double d5 = this.data[i3] - realVector.getEntry(i3);
            d4 += FastMath.abs(d5);
        }
        return d4;
    }

    public double getLInfDistance(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d2 = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double d3 = this.data[i2] - dArray[i2];
                d2 = FastMath.max(d2, FastMath.abs(d3));
            }
            return d2;
        }
        this.checkVectorDimensions(realVector);
        double d4 = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double d5 = this.data[i3] - realVector.getEntry(i3);
            d4 = FastMath.max(d4, FastMath.abs(d5));
        }
        return d4;
    }

    public RealMatrix outerProduct(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = this.data.length;
            int n2 = dArray.length;
            RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    realMatrix.setEntry(i2, i3, this.data[i2] * dArray[i3]);
                }
            }
            return realMatrix;
        }
        int n = this.data.length;
        int n3 = realVector.getDimension();
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n3);
        for (int i4 = 0; i4 < n; ++i4) {
            for (int i5 = 0; i5 < n3; ++i5) {
                realMatrix.setEntry(i4, i5, this.data[i4] * realVector.getEntry(i5));
            }
        }
        return realMatrix;
    }

    public double getEntry(int n) {
        try {
            return this.data[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, ((RealVector)this).getDimension() - 1);
        }
    }

    public int getDimension() {
        return this.data.length;
    }

    public RealVector append(RealVector realVector) {
        try {
            return new ArrayRealVector(this, (ArrayRealVector)realVector);
        }
        catch (ClassCastException classCastException) {
            return new ArrayRealVector(this, realVector);
        }
    }

    public ArrayRealVector append(ArrayRealVector arrayRealVector) {
        return new ArrayRealVector(this, arrayRealVector);
    }

    public RealVector append(double d2) {
        double[] dArray = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, dArray, 0, this.data.length);
        dArray[this.data.length] = d2;
        return new ArrayRealVector(dArray, false);
    }

    public RealVector getSubVector(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        ArrayRealVector arrayRealVector = new ArrayRealVector(n2);
        try {
            System.arraycopy(this.data, n, arrayRealVector.data, 0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + n2 - 1);
        }
        return arrayRealVector;
    }

    public void setEntry(int n, double d2) {
        try {
            this.data[n] = d2;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            return;
        }
    }

    public void addToEntry(int n, double d2) {
        try {
            int n2 = n;
            this.data[n2] = this.data[n2] + d2;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.data.length - 1);
        }
    }

    public void setSubVector(int n, RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            this.setSubVector(n, ((ArrayRealVector)realVector).data);
            return;
        }
        try {
            for (int i2 = n; i2 < n + realVector.getDimension(); ++i2) {
                this.data[i2] = realVector.getEntry(i2 - n);
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + realVector.getDimension() - 1);
            return;
        }
    }

    public void setSubVector(int n, double[] dArray) {
        try {
            System.arraycopy(dArray, 0, this.data, n, dArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + dArray.length - 1);
            return;
        }
    }

    public void set(double d2) {
        Arrays.fill(this.data, d2);
    }

    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        return DEFAULT_FORMAT.format(this);
    }

    protected void checkVectorDimensions(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
    }

    protected void checkVectorDimensions(int n) {
        if (this.data.length != n) {
            throw new DimensionMismatchException(this.data.length, n);
        }
    }

    public boolean isNaN() {
        double[] dArray = this.data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d2 = dArray[i2];
            if (!Double.isNaN(d2)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        if (((RealVector)this).isNaN()) {
            return false;
        }
        double[] dArray = this.data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d2 = dArray[i2];
            if (!Double.isInfinite(d2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RealVector)) {
            return false;
        }
        if (this.data.length != ((RealVector)(object = (RealVector)object)).getDimension()) {
            return false;
        }
        if (((RealVector)object).isNaN()) {
            return ((RealVector)this).isNaN();
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (this.data[i2] == ((RealVector)object).getEntry(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (((RealVector)this).isNaN()) {
            return 9;
        }
        return MathUtils.hash(this.data);
    }

    public ArrayRealVector combine(double d2, double d3, RealVector realVector) {
        return this.copy().combineToSelf(d2, d3, realVector);
    }

    public ArrayRealVector combineToSelf(double d2, double d3, RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                this.data[i2] = d2 * this.data[i2] + d3 * dArray[i2];
            }
        } else {
            this.checkVectorDimensions(realVector);
            for (int i3 = 0; i3 < this.data.length; ++i3) {
                this.data[i3] = d2 * this.data[i3] + d3 * realVector.getEntry(i3);
            }
        }
        return this;
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        realVectorPreservingVisitor.start(this.data.length, 0, this.data.length - 1);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            realVectorPreservingVisitor.visit(i2, this.data[i2]);
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        realVectorPreservingVisitor.start(this.data.length, n, n2);
        while (n <= n2) {
            realVectorPreservingVisitor.visit(n, this.data[n]);
            ++n;
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        return ((RealVector)this).walkInDefaultOrder(realVectorPreservingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) {
        return ((RealVector)this).walkInDefaultOrder(realVectorPreservingVisitor, n, n2);
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        realVectorChangingVisitor.start(this.data.length, 0, this.data.length - 1);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = realVectorChangingVisitor.visit(i2, this.data[i2]);
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        realVectorChangingVisitor.start(this.data.length, n, n2);
        while (n <= n2) {
            this.data[n] = realVectorChangingVisitor.visit(n, this.data[n]);
            ++n;
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        return ((RealVector)this).walkInDefaultOrder(realVectorChangingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) {
        return ((RealVector)this).walkInDefaultOrder(realVectorChangingVisitor, n, n2);
    }
}

