/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVectorChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVectorPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7648186910365927050L;
    private T[] data;
    private final Field<T> field;

    public ArrayFieldVector(Field<T> field) {
        this(field, 0);
    }

    public ArrayFieldVector(Field<T> field, int n) {
        this.field = field;
        this.data = (FieldElement[])MathArrays.buildArray(field, n);
    }

    public ArrayFieldVector(int n, T t) {
        this(t.getField(), n);
        Arrays.fill(this.data, t);
    }

    public ArrayFieldVector(T[] TArray) {
        MathUtils.checkNotNull(TArray);
        try {
            this.field = TArray[0].getField();
            this.data = (FieldElement[])TArray.clone();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
    }

    public ArrayFieldVector(Field<T> field, T[] TArray) {
        MathUtils.checkNotNull(TArray);
        this.field = field;
        this.data = (FieldElement[])TArray.clone();
    }

    public ArrayFieldVector(T[] TArray, boolean bl) {
        MathUtils.checkNotNull(TArray);
        if (TArray.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.field = TArray[0].getField();
        this.data = bl ? (FieldElement[])TArray.clone() : TArray;
    }

    public ArrayFieldVector(Field<T> field, T[] TArray, boolean bl) {
        MathUtils.checkNotNull(TArray);
        this.field = field;
        this.data = bl ? (FieldElement[])TArray.clone() : TArray;
    }

    public ArrayFieldVector(T[] TArray, int n, int n2) {
        MathUtils.checkNotNull(TArray);
        if (TArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)TArray.length, true);
        }
        this.field = TArray[0].getField();
        this.data = (FieldElement[])MathArrays.buildArray(this.field, n2);
        System.arraycopy(TArray, n, this.data, 0, n2);
    }

    public ArrayFieldVector(Field<T> field, T[] TArray, int n, int n2) {
        MathUtils.checkNotNull(TArray);
        if (TArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)TArray.length, true);
        }
        this.field = field;
        this.data = (FieldElement[])MathArrays.buildArray(field, n2);
        System.arraycopy(TArray, n, this.data, 0, n2);
    }

    public ArrayFieldVector(FieldVector<T> fieldVector) {
        MathUtils.checkNotNull(fieldVector);
        this.field = fieldVector.getField();
        this.data = (FieldElement[])MathArrays.buildArray(this.field, fieldVector.getDimension());
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = fieldVector.getEntry(i2);
        }
    }

    public ArrayFieldVector(ArrayFieldVector<T> arrayFieldVector) {
        MathUtils.checkNotNull(arrayFieldVector);
        this.field = arrayFieldVector.getField();
        this.data = (FieldElement[])arrayFieldVector.data.clone();
    }

    public ArrayFieldVector(ArrayFieldVector<T> arrayFieldVector, boolean bl) {
        MathUtils.checkNotNull(arrayFieldVector);
        this.field = arrayFieldVector.getField();
        this.data = bl ? (FieldElement[])arrayFieldVector.data.clone() : arrayFieldVector.data;
    }

    @Deprecated
    public ArrayFieldVector(ArrayFieldVector<T> arrayFieldVector, ArrayFieldVector<T> arrayFieldVector2) {
        this((FieldVector<T>)arrayFieldVector, (FieldVector<T>)arrayFieldVector2);
    }

    public ArrayFieldVector(FieldVector<T> fieldElementArray, FieldVector<T> fieldElementArray2) {
        MathUtils.checkNotNull(fieldElementArray);
        MathUtils.checkNotNull(fieldElementArray2);
        this.field = fieldElementArray.getField();
        fieldElementArray = fieldElementArray instanceof ArrayFieldVector ? ((ArrayFieldVector)fieldElementArray).data : fieldElementArray.toArray();
        fieldElementArray2 = fieldElementArray2 instanceof ArrayFieldVector ? ((ArrayFieldVector)fieldElementArray2).data : fieldElementArray2.toArray();
        this.data = (FieldElement[])MathArrays.buildArray(this.field, fieldElementArray.length + fieldElementArray2.length);
        System.arraycopy(fieldElementArray, 0, this.data, 0, fieldElementArray.length);
        System.arraycopy(fieldElementArray2, 0, this.data, fieldElementArray.length, fieldElementArray2.length);
    }

    @Deprecated
    public ArrayFieldVector(ArrayFieldVector<T> arrayFieldVector, T[] TArray) {
        this(arrayFieldVector, (FieldElement[])TArray);
    }

    public ArrayFieldVector(FieldVector<T> fieldElementArray, T[] TArray) {
        MathUtils.checkNotNull(fieldElementArray);
        MathUtils.checkNotNull(TArray);
        this.field = fieldElementArray.getField();
        fieldElementArray = fieldElementArray instanceof ArrayFieldVector ? ((ArrayFieldVector)fieldElementArray).data : fieldElementArray.toArray();
        this.data = (FieldElement[])MathArrays.buildArray(this.field, fieldElementArray.length + TArray.length);
        System.arraycopy(fieldElementArray, 0, this.data, 0, fieldElementArray.length);
        System.arraycopy(TArray, 0, this.data, fieldElementArray.length, TArray.length);
    }

    @Deprecated
    public ArrayFieldVector(T[] TArray, ArrayFieldVector<T> arrayFieldVector) {
        this((FieldElement[])TArray, arrayFieldVector);
    }

    public ArrayFieldVector(T[] TArray, FieldVector<T> fieldElementArray) {
        MathUtils.checkNotNull(TArray);
        MathUtils.checkNotNull(fieldElementArray);
        this.field = fieldElementArray.getField();
        fieldElementArray = fieldElementArray instanceof ArrayFieldVector ? ((ArrayFieldVector)fieldElementArray).data : fieldElementArray.toArray();
        this.data = (FieldElement[])MathArrays.buildArray(this.field, TArray.length + fieldElementArray.length);
        System.arraycopy(TArray, 0, this.data, 0, TArray.length);
        System.arraycopy(fieldElementArray, 0, this.data, TArray.length, fieldElementArray.length);
    }

    public ArrayFieldVector(T[] TArray, T[] TArray2) {
        MathUtils.checkNotNull(TArray);
        MathUtils.checkNotNull(TArray2);
        if (TArray.length + TArray2.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.data = (FieldElement[])MathArrays.buildArray(TArray[0].getField(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, this.data, 0, TArray.length);
        System.arraycopy(TArray2, 0, this.data, TArray.length, TArray2.length);
        this.field = this.data[0].getField();
    }

    public ArrayFieldVector(Field<T> field, T[] TArray, T[] TArray2) {
        MathUtils.checkNotNull(TArray);
        MathUtils.checkNotNull(TArray2);
        if (TArray.length + TArray2.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.data = (FieldElement[])MathArrays.buildArray(field, TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, this.data, 0, TArray.length);
        System.arraycopy(TArray2, 0, this.data, TArray.length, TArray2.length);
        this.field = field;
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> copy() {
        return new ArrayFieldVector<T>(this, true);
    }

    @Override
    public FieldVector<T> add(FieldVector<T> fieldVector) {
        try {
            return this.add((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            this.checkVectorDimensions(fieldVector);
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                fieldElementArray[i2] = (FieldElement)this.data[i2].add(fieldVector.getEntry(i2));
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public ArrayFieldVector<T> add(ArrayFieldVector<T> arrayFieldVector) {
        this.checkVectorDimensions(arrayFieldVector.data.length);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].add(arrayFieldVector.data[i2]);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> fieldVector) {
        try {
            return this.subtract((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            this.checkVectorDimensions(fieldVector);
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                fieldElementArray[i2] = (FieldElement)this.data[i2].subtract(fieldVector.getEntry(i2));
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public ArrayFieldVector<T> subtract(ArrayFieldVector<T> arrayFieldVector) {
        this.checkVectorDimensions(arrayFieldVector.data.length);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].subtract(arrayFieldVector.data[i2]);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapAdd(T t) {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].add(t);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T t) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].add(t);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T t) {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].subtract(t);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T t) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].subtract(t);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T t) {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].multiply(t);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T t) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].multiply(t);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T t) {
        MathUtils.checkNotNull(t);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].divide(t);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T t) {
        MathUtils.checkNotNull(t);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = (FieldElement)this.data[i2].divide(t);
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        FieldElement fieldElement = (FieldElement)this.field.getOne();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            try {
                fieldElementArray[i2] = (FieldElement)fieldElement.divide(this.data[i2]);
                continue;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw new MathArithmeticException(LocalizedFormats.INDEX, i2);
            }
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> mapInvToSelf() {
        FieldElement fieldElement = (FieldElement)this.field.getOne();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            try {
                this.data[i2] = (FieldElement)fieldElement.divide(this.data[i2]);
                continue;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw new MathArithmeticException(LocalizedFormats.INDEX, i2);
            }
        }
        return this;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> fieldVector) {
        try {
            return this.ebeMultiply((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            this.checkVectorDimensions(fieldVector);
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                fieldElementArray[i2] = (FieldElement)this.data[i2].multiply(fieldVector.getEntry(i2));
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public ArrayFieldVector<T> ebeMultiply(ArrayFieldVector<T> arrayFieldVector) {
        this.checkVectorDimensions(arrayFieldVector.data.length);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElementArray[i2] = (FieldElement)this.data[i2].multiply(arrayFieldVector.data[i2]);
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> fieldVector) {
        try {
            return this.ebeDivide((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            this.checkVectorDimensions(fieldVector);
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                try {
                    fieldElementArray[i2] = (FieldElement)this.data[i2].divide(fieldVector.getEntry(i2));
                    continue;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw new MathArithmeticException(LocalizedFormats.INDEX, i2);
                }
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public ArrayFieldVector<T> ebeDivide(ArrayFieldVector<T> arrayFieldVector) {
        this.checkVectorDimensions(arrayFieldVector.data.length);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            try {
                fieldElementArray[i2] = (FieldElement)this.data[i2].divide(arrayFieldVector.data[i2]);
                continue;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw new MathArithmeticException(LocalizedFormats.INDEX, i2);
            }
        }
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public T[] getData() {
        return (FieldElement[])this.data.clone();
    }

    public T[] getDataRef() {
        return this.data;
    }

    @Override
    public T dotProduct(FieldVector<T> fieldVector) {
        try {
            return this.dotProduct((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            this.checkVectorDimensions(fieldVector);
            FieldElement fieldElement = (FieldElement)this.field.getZero();
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                fieldElement = (FieldElement)fieldElement.add(this.data[i2].multiply(fieldVector.getEntry(i2)));
            }
            return (T)fieldElement;
        }
    }

    @Override
    public T dotProduct(ArrayFieldVector<T> arrayFieldVector) {
        this.checkVectorDimensions(arrayFieldVector.data.length);
        FieldElement fieldElement = (FieldElement)this.field.getZero();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fieldElement = (FieldElement)fieldElement.add(this.data[i2].multiply(arrayFieldVector.data[i2]));
        }
        return (T)fieldElement;
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> fieldVector) {
        FieldVector<FieldElement> fieldVector2 = fieldVector;
        return fieldVector.mapMultiply((FieldElement)this.dotProduct(fieldVector).divide(fieldVector2.dotProduct(fieldVector2)));
    }

    @Override
    public ArrayFieldVector<T> projection(ArrayFieldVector<T> arrayFieldVector) {
        ArrayFieldVector<FieldElement> arrayFieldVector2 = arrayFieldVector;
        return (ArrayFieldVector)arrayFieldVector.mapMultiply((FieldElement)this.dotProduct(arrayFieldVector).divide(arrayFieldVector2.dotProduct(arrayFieldVector2)));
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> fieldVector) {
        try {
            return this.outerProduct((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            int n = this.data.length;
            int n2 = fieldVector.getDimension();
            Array2DRowFieldMatrix<FieldElement> array2DRowFieldMatrix = new Array2DRowFieldMatrix<FieldElement>(this.field, n, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    array2DRowFieldMatrix.setEntry(i2, i3, (FieldElement)this.data[i2].multiply(fieldVector.getEntry(i3)));
                }
            }
            return array2DRowFieldMatrix;
        }
    }

    @Override
    public FieldMatrix<T> outerProduct(ArrayFieldVector<T> arrayFieldVector) {
        int n = this.data.length;
        int n2 = arrayFieldVector.data.length;
        Array2DRowFieldMatrix<FieldElement> array2DRowFieldMatrix = new Array2DRowFieldMatrix<FieldElement>(this.field, n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                array2DRowFieldMatrix.setEntry(i2, i3, (FieldElement)this.data[i2].multiply(arrayFieldVector.data[i3]));
            }
        }
        return array2DRowFieldMatrix;
    }

    @Override
    public T getEntry(int n) {
        return this.data[n];
    }

    @Override
    public int getDimension() {
        return this.data.length;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> fieldVector) {
        try {
            return this.append((ArrayFieldVector)fieldVector);
        }
        catch (ClassCastException classCastException) {
            return new ArrayFieldVector<T>(this, new ArrayFieldVector<T>(fieldVector));
        }
    }

    @Override
    public ArrayFieldVector<T> append(ArrayFieldVector<T> arrayFieldVector) {
        return new ArrayFieldVector<T>(this, arrayFieldVector);
    }

    @Override
    public FieldVector<T> append(T t) {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.data.length + 1);
        System.arraycopy(this.data, 0, fieldElementArray, 0, this.data.length);
        fieldElementArray[this.data.length] = t;
        return new ArrayFieldVector(this.field, fieldElementArray, false);
    }

    @Override
    public FieldVector<T> getSubVector(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        ArrayFieldVector<T> arrayFieldVector = new ArrayFieldVector<T>(this.field, n2);
        try {
            System.arraycopy(this.data, n, arrayFieldVector.data, 0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + n2 - 1);
        }
        return arrayFieldVector;
    }

    @Override
    public void setEntry(int n, T t) {
        try {
            this.data[n] = t;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            return;
        }
    }

    @Override
    public void setSubVector(int n, FieldVector<T> fieldVector) {
        try {
            try {
                this.set(n, (ArrayFieldVector)fieldVector);
            }
            catch (ClassCastException classCastException) {
                for (int i2 = n; i2 < n + fieldVector.getDimension(); ++i2) {
                    this.data[i2] = fieldVector.getEntry(i2 - n);
                }
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + fieldVector.getDimension() - 1);
        }
    }

    public void set(int n, ArrayFieldVector<T> arrayFieldVector) {
        try {
            System.arraycopy(arrayFieldVector.data, 0, this.data, n, arrayFieldVector.data.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + arrayFieldVector.data.length - 1);
            return;
        }
    }

    @Override
    public void set(T t) {
        Arrays.fill(this.data, t);
    }

    @Override
    public T[] toArray() {
        return (FieldElement[])this.data.clone();
    }

    protected void checkVectorDimensions(FieldVector<T> fieldVector) {
        this.checkVectorDimensions(fieldVector.getDimension());
    }

    protected void checkVectorDimensions(int n) {
        if (this.data.length != n) {
            throw new DimensionMismatchException(this.data.length, n);
        }
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        int n = this.getDimension();
        fieldVectorPreservingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            fieldVectorPreservingVisitor.visit(i2, this.getEntry(i2));
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        fieldVectorPreservingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            fieldVectorPreservingVisitor.visit(n, this.getEntry(n));
            ++n;
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor, n, n2);
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        int n = this.getDimension();
        fieldVectorChangingVisitor.start(n, 0, n - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            this.setEntry(i2, fieldVectorChangingVisitor.visit(i2, this.getEntry(i2)));
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) {
        this.checkIndices(n, n2);
        fieldVectorChangingVisitor.start(this.getDimension(), n, n2);
        while (n <= n2) {
            this.setEntry(n, fieldVectorChangingVisitor.visit(n, this.getEntry(n)));
            ++n;
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor, n, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            object = (FieldVector)object;
            if (this.data.length != object.getDimension()) {
                return false;
            }
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (this.data[i2].equals(object.getEntry(i2))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 3542;
        T[] TArray = this.data;
        int n2 = this.data.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T t = TArray[i2];
            n ^= t.hashCode();
        }
        return n;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.getDimension() - 1);
        }
    }

    private void checkIndices(int n, int n2) {
        int n3 = this.getDimension();
        if (n < 0 || n >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, n3 - 1);
        }
        if (n2 < 0 || n2 >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n2, 0, n3 - 1);
        }
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
    }
}

