/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AnyMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Array2DRowRealMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    private double[][] data;

    public Array2DRowRealMatrix() {
    }

    public Array2DRowRealMatrix(int n, int n2) {
        super(n, n2);
        this.data = new double[n][n2];
    }

    public Array2DRowRealMatrix(double[][] dArray) {
        this.copyIn(dArray);
    }

    public Array2DRowRealMatrix(double[][] dArray, boolean n) {
        if (n) {
            this.copyIn(dArray);
            return;
        }
        if (dArray == null) {
            throw new NullArgumentException();
        }
        n = dArray.length;
        if (!n) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int n2 = dArray[0].length;
        if (n2 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (int i2 = 1; i2 < n; ++i2) {
            if (dArray[i2].length == n2) continue;
            throw new DimensionMismatchException(dArray[i2].length, n2);
        }
        this.data = dArray;
    }

    public Array2DRowRealMatrix(double[] dArray) {
        int n = dArray.length;
        this.data = new double[n][1];
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2][0] = dArray[i2];
        }
    }

    public RealMatrix createMatrix(int n, int n2) {
        return new Array2DRowRealMatrix(n, n2);
    }

    public RealMatrix copy() {
        return new Array2DRowRealMatrix(this.copyOut(), false);
    }

    public Array2DRowRealMatrix add(Array2DRowRealMatrix array2DRowRealMatrix) {
        MatrixUtils.checkAdditionCompatible(this, array2DRowRealMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray2 = this.data[i2];
            double[] dArray3 = array2DRowRealMatrix.data[i2];
            double[] dArray4 = dArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray4[i3] = dArray2[i3] + dArray3[i3];
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public Array2DRowRealMatrix subtract(Array2DRowRealMatrix array2DRowRealMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, array2DRowRealMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray2 = this.data[i2];
            double[] dArray3 = array2DRowRealMatrix.data[i2];
            double[] dArray4 = dArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray4[i3] = dArray2[i3] - dArray3[i3];
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public Array2DRowRealMatrix multiply(Array2DRowRealMatrix object) {
        MatrixUtils.checkMultiplicationCompatible(this, (AnyMatrix)object);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)object).getColumnDimension();
        int n3 = ((RealLinearOperator)this).getColumnDimension();
        double[][] dArray = new double[n][n2];
        double[] dArray2 = new double[n3];
        object = ((Array2DRowRealMatrix)object).data;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                dArray2[n4] = (double)object[n4][i2];
            }
            for (n4 = 0; n4 < n; ++n4) {
                double[] dArray3 = this.data[n4];
                double d2 = 0.0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    d2 += dArray3[i3] * dArray2[i3];
                }
                dArray[n4][i2] = d2;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(double[][] dArray, int n, int n2) {
        if (this.data == null) {
            if (n > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, n);
            }
            if (n2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, n2);
            }
            MathUtils.checkNotNull(dArray);
            int n3 = dArray.length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            n3 = dArray[0].length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = new double[dArray.length][n3];
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (dArray[i2].length != n3) {
                    throw new DimensionMismatchException(dArray[i2].length, n3);
                }
                System.arraycopy(dArray[i2], 0, this.data[i2 + n], n2, n3);
            }
            return;
        }
        super.setSubMatrix(dArray, n, n2);
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        return this.data[n][n2];
    }

    public void setEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.data[n][n2] = d2;
    }

    public void addToEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d2;
    }

    public void multiplyEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] * d2;
    }

    public int getRowDimension() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public int getColumnDimension() {
        if (this.data == null || this.data[0] == null) {
            return 0;
        }
        return this.data[0].length;
    }

    public double[] operate(double[] dArray) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n2) {
            throw new DimensionMismatchException(dArray.length, n2);
        }
        double[] dArray2 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray3 = this.data[i2];
            double d2 = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                d2 += dArray3[i3] * dArray[i3];
            }
            dArray2[i2] = d2;
        }
        return dArray2;
    }

    public double[] preMultiply(double[] dArray) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < n; ++i3) {
                d2 += this.data[i3][i2] * dArray[i3];
            }
            dArray2[i2] = d2;
        }
        return dArray2;
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray = this.data[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i3] = realMatrixChangingVisitor.visit(i2, i3, dArray[i3]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray = this.data[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrixPreservingVisitor.visit(i2, i3, dArray[i3]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            double[] dArray = this.data[n];
            for (int i2 = n3; i2 <= n4; ++i2) {
                dArray[i2] = realMatrixChangingVisitor.visit(n, i2, dArray[i2]);
            }
            ++n;
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            double[] dArray = this.data[n];
            for (int i2 = n3; i2 <= n4; ++i2) {
                realMatrixPreservingVisitor.visit(n, i2, dArray[i2]);
            }
            ++n;
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                double[] dArray = this.data[i3];
                double[] dArray2 = dArray;
                dArray[i2] = realMatrixChangingVisitor.visit(i3, i2, dArray2[i2]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                realMatrixPreservingVisitor.visit(i3, i2, this.data[i3][i2]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                double[] dArray = this.data[i2];
                double[] dArray2 = dArray;
                dArray[n3] = realMatrixChangingVisitor.visit(i2, n3, dArray2[n3]);
            }
            ++n3;
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                realMatrixPreservingVisitor.visit(i2, n3, this.data[i2][n3]);
            }
            ++n3;
        }
        return realMatrixPreservingVisitor.end();
    }

    private double[][] copyOut() {
        int n = ((RealLinearOperator)this).getRowDimension();
        double[][] dArray = new double[n][((RealLinearOperator)this).getColumnDimension()];
        for (int i2 = 0; i2 < n; ++i2) {
            System.arraycopy(this.data[i2], 0, dArray[i2], 0, this.data[i2].length);
        }
        return dArray;
    }

    private void copyIn(double[][] dArray) {
        ((AbstractRealMatrix)this).setSubMatrix(dArray, 0, 0);
    }
}

