/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int n, int n2) {
        super(field, n, n2);
        this.data = (FieldElement[][])MathArrays.buildArray(field, n, n2);
    }

    public Array2DRowFieldMatrix(T[][] TArray) {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[][])TArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] TArray) {
        super(field);
        this.copyIn((FieldElement[][])TArray);
    }

    public Array2DRowFieldMatrix(T[][] TArray, boolean bl) {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[][])TArray, bl);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] TArray, boolean n) {
        super(field);
        if (n != 0) {
            this.copyIn((FieldElement[][])TArray);
            return;
        }
        MathUtils.checkNotNull(TArray);
        int n2 = TArray.length;
        if (n2 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        n = TArray[0].length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            if (TArray[i2].length == n) continue;
            throw new DimensionMismatchException(n, TArray[i2].length);
        }
        this.data = TArray;
    }

    public Array2DRowFieldMatrix(T[] TArray) {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[])TArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[] TArray) {
        super(field);
        int n = TArray.length;
        this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), n, 1);
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2][0] = TArray[i2];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) {
        return new Array2DRowFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        this.checkAdditionCompatible(array2DRowFieldMatrix);
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray = this.data[i2];
            T[] TArray2 = array2DRowFieldMatrix.data[i2];
            FieldElement[] fieldElementArray2 = fieldElementArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldElementArray2[i3] = (FieldElement)TArray[i3].add(TArray2[i3]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        this.checkSubtractionCompatible(array2DRowFieldMatrix);
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray = this.data[i2];
            T[] TArray2 = array2DRowFieldMatrix.data[i2];
            FieldElement[] fieldElementArray2 = fieldElementArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldElementArray2[i3] = (FieldElement)TArray[i3].subtract(TArray2[i3]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        this.checkMultiplicationCompatible(array2DRowFieldMatrix);
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)array2DRowFieldMatrix).getColumnDimension();
        int n3 = ((AbstractFieldMatrix)this).getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray = this.data[i2];
            FieldElement[] fieldElementArray2 = fieldElementArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                FieldElement fieldElement = (FieldElement)this.getField().getZero();
                for (int i4 = 0; i4 < n3; ++i4) {
                    fieldElement = (FieldElement)fieldElement.add(TArray[i4].multiply(array2DRowFieldMatrix.data[i4][i3]));
                }
                fieldElementArray2[i3] = fieldElement;
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) {
        if (this.data == null) {
            if (n > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, n);
            }
            if (n2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, n2);
            }
            int n3 = TArray.length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            n3 = TArray[0].length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), TArray.length, n3);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (TArray[i2].length != n3) {
                    throw new DimensionMismatchException(n3, TArray[i2].length);
                }
                System.arraycopy(TArray[i2], 0, this.data[i2 + n], n2, n3);
            }
            return;
        }
        super.setSubMatrix(TArray, n, n2);
    }

    @Override
    public T getEntry(int n, int n2) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        return this.data[n][n2];
    }

    @Override
    public void setEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.data[n][n2] = t;
    }

    @Override
    public void addToEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        T[] TArray = this.data[n];
        TArray[n2] = (FieldElement)TArray[n2].add(t);
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        T[] TArray = this.data[n];
        TArray[n2] = (FieldElement)TArray[n2].multiply(t);
    }

    @Override
    public int getRowDimension() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public int getColumnDimension() {
        if (this.data == null || this.data[0] == null) {
            return 0;
        }
        return this.data[0].length;
    }

    @Override
    public T[] operate(T[] TArray) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        if (TArray.length != n2) {
            throw new DimensionMismatchException(TArray.length, n2);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), n);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray2 = this.data[i2];
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldElement = (FieldElement)fieldElement.add(TArray2[i3].multiply(TArray[i3]));
            }
            fieldElementArray[i2] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public T[] preMultiply(T[] TArray) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        if (TArray.length != n) {
            throw new DimensionMismatchException(TArray.length, n);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            for (int i3 = 0; i3 < n; ++i3) {
                fieldElement = (FieldElement)fieldElement.add(this.data[i3][i2].multiply(TArray[i3]));
            }
            fieldElementArray[i2] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray = this.data[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                TArray[i3] = fieldMatrixChangingVisitor.visit(i2, i3, TArray[i3]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            T[] TArray = this.data[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrixPreservingVisitor.visit(i2, i3, TArray[i3]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(((AbstractFieldMatrix)this).getRowDimension(), ((AbstractFieldMatrix)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            T[] TArray = this.data[n];
            for (int i2 = n3; i2 <= n4; ++i2) {
                TArray[i2] = fieldMatrixChangingVisitor.visit(n, i2, TArray[i2]);
            }
            ++n;
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(((AbstractFieldMatrix)this).getRowDimension(), ((AbstractFieldMatrix)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            T[] TArray = this.data[n];
            for (int i2 = n3; i2 <= n4; ++i2) {
                fieldMatrixPreservingVisitor.visit(n, i2, TArray[i2]);
            }
            ++n;
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                T[] TArray = this.data[i3];
                T[] TArray2 = TArray;
                TArray[i2] = fieldMatrixChangingVisitor.visit(i3, i2, TArray2[i2]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        int n2 = ((AbstractFieldMatrix)this).getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                fieldMatrixPreservingVisitor.visit(i3, i2, this.data[i3][i2]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(((AbstractFieldMatrix)this).getRowDimension(), ((AbstractFieldMatrix)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                T[] TArray = this.data[i2];
                T[] TArray2 = TArray;
                TArray[n3] = fieldMatrixChangingVisitor.visit(i2, n3, TArray2[n3]);
            }
            ++n3;
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(((AbstractFieldMatrix)this).getRowDimension(), ((AbstractFieldMatrix)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                fieldMatrixPreservingVisitor.visit(i2, n3, this.data[i2][n3]);
            }
            ++n3;
        }
        return fieldMatrixPreservingVisitor.end();
    }

    private T[][] copyOut() {
        int n = ((AbstractFieldMatrix)this).getRowDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, ((AbstractFieldMatrix)this).getColumnDimension());
        for (int i2 = 0; i2 < n; ++i2) {
            System.arraycopy(this.data[i2], 0, fieldElementArray[i2], 0, this.data[i2].length);
        }
        return fieldElementArray;
    }

    private void copyIn(T[][] TArray) {
        this.setSubMatrix((FieldElement[][])TArray, 0, 0);
    }
}

