/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix$4;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix$5;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixDimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public abstract class AbstractRealMatrix
extends RealLinearOperator
implements RealMatrix {
    private static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getInstance(Locale.US);

    protected AbstractRealMatrix() {
    }

    protected AbstractRealMatrix(int n, int n2) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException(n2);
        }
    }

    public RealMatrix add(RealMatrix realMatrix) {
        MatrixUtils.checkAdditionCompatible(this, realMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrix2.setEntry(i2, i3, this.getEntry(i2, i3) + realMatrix.getEntry(i2, i3));
            }
        }
        return realMatrix2;
    }

    public RealMatrix subtract(RealMatrix realMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, realMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrix2.setEntry(i2, i3, this.getEntry(i2, i3) - realMatrix.getEntry(i2, i3));
            }
        }
        return realMatrix2;
    }

    public RealMatrix scalarAdd(double d2) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrix.setEntry(i2, i3, this.getEntry(i2, i3) + d2);
            }
        }
        return realMatrix;
    }

    public RealMatrix scalarMultiply(double d2) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrix.setEntry(i2, i3, this.getEntry(i2, i3) * d2);
            }
        }
        return realMatrix;
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        int n3 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d2 = 0.0;
                for (int i4 = 0; i4 < n3; ++i4) {
                    d2 += this.getEntry(i2, i4) * realMatrix.getEntry(i4, i3);
                }
                realMatrix2.setEntry(i2, i3, d2);
            }
        }
        return realMatrix2;
    }

    public RealMatrix preMultiply(RealMatrix realMatrix) {
        return realMatrix.multiply(this);
    }

    public RealMatrix power(int n) {
        int n2;
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_EXPONENT, n);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension());
        }
        if (n == 0) {
            return MatrixUtils.createRealIdentityMatrix(((RealLinearOperator)this).getRowDimension());
        }
        if (n == 1) {
            return this.copy();
        }
        Object object = Integer.toBinaryString(--n).toCharArray();
        Serializable serializable = new ArrayList<Integer>();
        int n3 = -1;
        for (int i2 = 0; i2 < ((char[])object).length; ++i2) {
            if (object[i2] != '1') continue;
            n2 = ((char[])object).length - i2 - 1;
            ((ArrayList)serializable).add(n2);
            if (n3 != -1) continue;
            n3 = n2;
        }
        RealMatrix[] realMatrixArray = new RealMatrix[n3 + 1];
        RealMatrix[] realMatrixArray2 = realMatrixArray;
        realMatrixArray[0] = this.copy();
        for (n2 = 1; n2 <= n3; ++n2) {
            realMatrixArray2[n2] = realMatrixArray2[n2 - 1].multiply(realMatrixArray2[n2 - 1]);
        }
        RealMatrix realMatrix = this.copy();
        object = ((ArrayList)serializable).iterator();
        while (object.hasNext()) {
            serializable = (Integer)object.next();
            realMatrix = realMatrix.multiply(realMatrixArray2[(Integer)serializable]);
        }
        return realMatrix;
    }

    public double[][] getData() {
        double[][] dArray = new double[((RealLinearOperator)this).getRowDimension()][((RealLinearOperator)this).getColumnDimension()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double[] dArray2 = dArray[i2];
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                dArray2[i3] = this.getEntry(i2, i3);
            }
        }
        return dArray;
    }

    public double getNorm() {
        return this.walkInColumnOrder(new AbstractRealMatrix$1(this));
    }

    public double getFrobeniusNorm() {
        return this.walkInOptimizedOrder(new AbstractRealMatrix$2(this));
    }

    public RealMatrix getSubMatrix(int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        RealMatrix realMatrix = this.createMatrix(n2 - n + 1, n4 - n3 + 1);
        for (int i2 = n; i2 <= n2; ++i2) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                realMatrix.setEntry(i2 - n, i3 - n3, this.getEntry(i2, i3));
            }
        }
        return realMatrix;
    }

    public RealMatrix getSubMatrix(int[] nArray, int[] nArray2) {
        MatrixUtils.checkSubMatrixIndex(this, nArray, nArray2);
        RealMatrix realMatrix = this.createMatrix(nArray.length, nArray2.length);
        realMatrix.walkInOptimizedOrder(new AbstractRealMatrix$3(this, nArray, nArray2));
        return realMatrix;
    }

    public void copySubMatrix(int n, int n2, int n3, int n4, double[][] dArray) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        int n5 = n2 + 1 - n;
        int n6 = n4 + 1 - n3;
        if (dArray.length < n5 || dArray[0].length < n6) {
            throw new MatrixDimensionMismatchException(dArray.length, dArray[0].length, n5, n6);
        }
        for (int i2 = 1; i2 < n5; ++i2) {
            if (dArray[i2].length >= n6) continue;
            throw new MatrixDimensionMismatchException(dArray.length, dArray[i2].length, n5, n6);
        }
        this.walkInOptimizedOrder(new AbstractRealMatrix$4(this, dArray), n, n2, n3, n4);
    }

    public void copySubMatrix(int[] nArray, int[] nArray2, double[][] dArray) {
        MatrixUtils.checkSubMatrixIndex(this, nArray, nArray2);
        int n = nArray2.length;
        if (dArray.length < nArray.length || dArray[0].length < n) {
            throw new MatrixDimensionMismatchException(dArray.length, dArray[0].length, nArray.length, nArray2.length);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double[] dArray2 = dArray[i2];
            if (dArray2.length < n) {
                throw new MatrixDimensionMismatchException(dArray.length, dArray2.length, nArray.length, nArray2.length);
            }
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                dArray2[i3] = this.getEntry(nArray[i2], nArray2[i3]);
            }
        }
    }

    public void setSubMatrix(double[][] dArray, int n, int n2) {
        int n3;
        MathUtils.checkNotNull(dArray);
        int n4 = dArray.length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int n5 = dArray[0].length;
        if (n5 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (dArray[n3].length == n5) continue;
            throw new DimensionMismatchException(n5, dArray[n3].length);
        }
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        MatrixUtils.checkRowIndex(this, n4 + n - 1);
        MatrixUtils.checkColumnIndex(this, n5 + n2 - 1);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n5; ++i2) {
                this.setEntry(n + n3, n2 + i2, dArray[n3][i2]);
            }
        }
    }

    public RealMatrix getRowMatrix(int n) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(1, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            realMatrix.setEntry(0, i2, this.getEntry(n, i2));
        }
        return realMatrix;
    }

    public void setRowMatrix(int n, RealMatrix realMatrix) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (realMatrix.getRowDimension() != 1 || realMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(realMatrix.getRowDimension(), realMatrix.getColumnDimension(), 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, realMatrix.getEntry(0, i2));
        }
    }

    public RealMatrix getColumnMatrix(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        RealMatrix realMatrix = this.createMatrix(n2, 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            realMatrix.setEntry(i2, 0, this.getEntry(i2, n));
        }
        return realMatrix;
    }

    public void setColumnMatrix(int n, RealMatrix realMatrix) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (realMatrix.getRowDimension() != n2 || realMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(realMatrix.getRowDimension(), realMatrix.getColumnDimension(), n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, realMatrix.getEntry(i2, 0));
        }
    }

    public RealVector getRowVector(int n) {
        return new ArrayRealVector(this.getRow(n), false);
    }

    public void setRowVector(int n, RealVector realVector) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (realVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(1, realVector.getDimension(), 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, realVector.getEntry(i2));
        }
    }

    public RealVector getColumnVector(int n) {
        return new ArrayRealVector(this.getColumn(n), false);
    }

    public void setColumnVector(int n, RealVector realVector) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (realVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(realVector.getDimension(), 1, n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, realVector.getEntry(i2));
        }
    }

    public double[] getRow(int n) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = this.getEntry(n, i2);
        }
        return dArray;
    }

    public void setRow(int n, double[] dArray) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, dArray.length, 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, dArray[i2]);
        }
    }

    public double[] getColumn(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = this.getEntry(i2, n);
        }
        return dArray;
    }

    public void setColumn(int n, double[] dArray) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(dArray.length, 1, n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, dArray[i2]);
        }
    }

    public void addToEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.setEntry(n, n2, this.getEntry(n, n2) + d2);
    }

    public void multiplyEntry(int n, int n2, double d2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.setEntry(n, n2, this.getEntry(n, n2) * d2);
    }

    public RealMatrix transpose() {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(n2, n);
        this.walkInOptimizedOrder(new AbstractRealMatrix$5(this, realMatrix));
        return realMatrix;
    }

    public boolean isSquare() {
        return ((RealLinearOperator)this).getColumnDimension() == ((RealLinearOperator)this).getRowDimension();
    }

    public abstract int getRowDimension();

    public abstract int getColumnDimension();

    public double getTrace() {
        int n;
        int n2 = ((RealLinearOperator)this).getRowDimension();
        if (n2 != (n = ((RealLinearOperator)this).getColumnDimension())) {
            throw new NonSquareMatrixException(n2, n);
        }
        double d2 = 0.0;
        n = 0;
        while (n < n2) {
            int n3 = n++;
            d2 += this.getEntry(n3, n3);
        }
        return d2;
    }

    public double[] operate(double[] dArray) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n2) {
            throw new DimensionMismatchException(dArray.length, n2);
        }
        double[] dArray2 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                d2 += this.getEntry(i2, i3) * dArray[i3];
            }
            dArray2[i2] = d2;
        }
        return dArray2;
    }

    public RealVector operate(RealVector realVector) {
        try {
            return new ArrayRealVector(this.operate(((ArrayRealVector)realVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = ((RealLinearOperator)this).getRowDimension();
            int n2 = ((RealLinearOperator)this).getColumnDimension();
            if (realVector.getDimension() != n2) {
                throw new DimensionMismatchException(realVector.getDimension(), n2);
            }
            double[] dArray = new double[n];
            for (int i2 = 0; i2 < n; ++i2) {
                double d2 = 0.0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    d2 += this.getEntry(i2, i3) * realVector.getEntry(i3);
                }
                dArray[i2] = d2;
            }
            return new ArrayRealVector(dArray, false);
        }
    }

    public double[] preMultiply(double[] dArray) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < n; ++i3) {
                d2 += this.getEntry(i3, i2) * dArray[i3];
            }
            dArray2[i2] = d2;
        }
        return dArray2;
    }

    public RealVector preMultiply(RealVector realVector) {
        try {
            return new ArrayRealVector(this.preMultiply(((ArrayRealVector)realVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = ((RealLinearOperator)this).getRowDimension();
            int n2 = ((RealLinearOperator)this).getColumnDimension();
            if (realVector.getDimension() != n) {
                throw new DimensionMismatchException(realVector.getDimension(), n);
            }
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2 = 0.0;
                for (int i3 = 0; i3 < n; ++i3) {
                    d2 += this.getEntry(i3, i2) * realVector.getEntry(i3);
                }
                dArray[i2] = d2;
            }
            return new ArrayRealVector(dArray, false);
        }
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d2 = this.getEntry(i2, i3);
                double d3 = realMatrixChangingVisitor.visit(i2, i3, d2);
                this.setEntry(i2, i3, d3);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                realMatrixPreservingVisitor.visit(i2, i3, this.getEntry(i2, i3));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                double d2 = this.getEntry(n, i2);
                double d3 = realMatrixChangingVisitor.visit(n, i2, d2);
                this.setEntry(n, i2, d3);
            }
            ++n;
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                realMatrixPreservingVisitor.visit(n, i2, this.getEntry(n, i2));
            }
            ++n;
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                double d2 = this.getEntry(i3, i2);
                double d3 = realMatrixChangingVisitor.visit(i3, i2, d2);
                this.setEntry(i3, i2, d3);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                realMatrixPreservingVisitor.visit(i3, i2, this.getEntry(i3, i2));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                double d2 = this.getEntry(i2, n3);
                double d3 = realMatrixChangingVisitor.visit(i2, n3, d2);
                this.setEntry(i2, n3, d3);
            }
            ++n3;
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(((RealLinearOperator)this).getRowDimension(), ((RealLinearOperator)this).getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                realMatrixPreservingVisitor.visit(i2, n3, this.getEntry(i2, n3));
            }
            ++n3;
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        return this.walkInRowOrder(realMatrixChangingVisitor);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        return this.walkInRowOrder(realMatrixPreservingVisitor);
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(realMatrixChangingVisitor, n, n2, n3, n4);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(realMatrixPreservingVisitor, n, n2, n3, n4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        stringBuilder.append(string);
        stringBuilder.append(DEFAULT_FORMAT.format(this));
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrix)) {
            return false;
        }
        object = (RealMatrix)object;
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        if (object.getColumnDimension() != n2 || object.getRowDimension() != n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.getEntry(i2, i3) == object.getEntry(i2, i3)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = ((RealLinearOperator)this).getRowDimension();
        int n2 = ((RealLinearOperator)this).getColumnDimension();
        int n3 = n + 217;
        n3 = n3 * 31 + n2;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 = n3 * 31 + (11 * (i2 + 1) + 17 * (i3 + 1)) * MathUtils.hash(this.getEntry(i2, i3));
            }
        }
        return n3;
    }

    public abstract RealMatrix createMatrix(int var1, int var2);

    public abstract RealMatrix copy();

    public abstract double getEntry(int var1, int var2);

    public abstract void setEntry(int var1, int var2, double var3);

    static {
        DEFAULT_FORMAT.getFormat().setMinimumFractionDigits(1);
    }
}

