/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractFieldMatrix$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixDimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldMatrix<T extends FieldElement<T>>
implements FieldMatrix<T> {
    private final Field<T> field;

    protected AbstractFieldMatrix() {
        this.field = null;
    }

    protected AbstractFieldMatrix(Field<T> field) {
        this.field = field;
    }

    protected AbstractFieldMatrix(Field<T> field, int n, int n2) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n2);
        }
        this.field = field;
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[][] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        if (TArray.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        if (TArray[0].length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        return TArray[0][0].getField();
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[] TArray) {
        if (TArray.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        return TArray[0].getField();
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[][] buildArray(Field<T> field, int n, int n2) {
        return (FieldElement[][])MathArrays.buildArray(field, n, n2);
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[] buildArray(Field<T> field, int n) {
        return (FieldElement[])MathArrays.buildArray(field, n);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public abstract FieldMatrix<T> createMatrix(int var1, int var2);

    @Override
    public abstract FieldMatrix<T> copy();

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> fieldMatrix) {
        this.checkAdditionCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrix2.setEntry(i2, i3, (FieldElement)this.getEntry(i2, i3).add(fieldMatrix.getEntry(i2, i3)));
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> fieldMatrix) {
        this.checkSubtractionCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrix2.setEntry(i2, i3, (FieldElement)this.getEntry(i2, i3).subtract(fieldMatrix.getEntry(i2, i3)));
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T t) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrix.setEntry(i2, i3, (FieldElement)this.getEntry(i2, i3).add(t));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T t) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrix.setEntry(i2, i3, (FieldElement)this.getEntry(i2, i3).multiply(t));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> fieldMatrix) {
        this.checkMultiplicationCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = fieldMatrix.getColumnDimension();
        int n3 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int i4 = 0; i4 < n3; ++i4) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(i2, i4).multiply(fieldMatrix.getEntry(i4, i3)));
                }
                fieldMatrix2.setEntry(i2, i3, fieldElement);
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> preMultiply(FieldMatrix<T> fieldMatrix) {
        return fieldMatrix.multiply(this);
    }

    @Override
    public FieldMatrix<T> power(int n) {
        int n2;
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (n == 0) {
            return MatrixUtils.createFieldIdentityMatrix(this.getField(), this.getRowDimension());
        }
        if (n == 1) {
            return this.copy();
        }
        char[] cArray = Integer.toBinaryString(--n).toCharArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '1') continue;
            n2 = cArray.length - i2 - 1;
            arrayList.add(n2);
        }
        ArrayList arrayList2 = new ArrayList(cArray.length);
        arrayList2.add(0, this.copy());
        for (n2 = 1; n2 < cArray.length; ++n2) {
            FieldMatrix fieldMatrix = (FieldMatrix)arrayList2.get(n2 - 1);
            FieldMatrix object = fieldMatrix.multiply(fieldMatrix);
            arrayList2.add(n2, object);
        }
        FieldMatrix<T> fieldMatrix = this.copy();
        for (Integer n3 : arrayList) {
            fieldMatrix = fieldMatrix.multiply((FieldMatrix)arrayList2.get(n3));
        }
        return fieldMatrix;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.field, this.getRowDimension(), this.getColumnDimension());
        for (int i2 = 0; i2 < fieldElementArray.length; ++i2) {
            FieldElement[] fieldElementArray2 = fieldElementArray[i2];
            for (int i3 = 0; i3 < fieldElementArray2.length; ++i3) {
                fieldElementArray2[i3] = this.getEntry(i2, i3);
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        FieldMatrix<T> fieldMatrix = this.createMatrix(n2 - n + 1, n4 - n3 + 1);
        for (int i2 = n; i2 <= n2; ++i2) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                fieldMatrix.setEntry(i2 - n, i3 - n3, this.getEntry(i2, i3));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int[] nArray, int[] nArray2) {
        this.checkSubMatrixIndex(nArray, nArray2);
        FieldMatrix<T> fieldMatrix = this.createMatrix(nArray.length, nArray2.length);
        AbstractFieldMatrix abstractFieldMatrix = this;
        fieldMatrix.walkInOptimizedOrder(new AbstractFieldMatrix$1(abstractFieldMatrix, (FieldElement)abstractFieldMatrix.field.getZero(), nArray, nArray2));
        return fieldMatrix;
    }

    @Override
    public void copySubMatrix(int n, int n2, int n3, int n4, T[][] TArray) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        int n5 = n2 + 1 - n;
        int n6 = n4 + 1 - n3;
        if (TArray.length < n5 || TArray[0].length < n6) {
            throw new MatrixDimensionMismatchException(TArray.length, TArray[0].length, n5, n6);
        }
        AbstractFieldMatrix abstractFieldMatrix = this;
        this.walkInOptimizedOrder(new AbstractFieldMatrix$2(abstractFieldMatrix, (FieldElement)abstractFieldMatrix.field.getZero(), (FieldElement[][])TArray), n, n2, n3, n4);
    }

    @Override
    public void copySubMatrix(int[] nArray, int[] nArray2, T[][] TArray) {
        this.checkSubMatrixIndex(nArray, nArray2);
        if (TArray.length < nArray.length || TArray[0].length < nArray2.length) {
            throw new MatrixDimensionMismatchException(TArray.length, TArray[0].length, nArray.length, nArray2.length);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            T[] TArray2 = TArray[i2];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                TArray2[i3] = this.getEntry(nArray[i2], nArray2[i3]);
            }
        }
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) {
        int n3;
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n4 = TArray.length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int n5 = TArray[0].length;
        if (n5 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (TArray[n3].length == n5) continue;
            throw new DimensionMismatchException(n5, TArray[n3].length);
        }
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.checkRowIndex(n4 + n - 1);
        this.checkColumnIndex(n5 + n2 - 1);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n5; ++i2) {
                this.setEntry(n + n3, n2 + i2, TArray[n3][i2]);
            }
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int n) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        FieldMatrix<T> fieldMatrix = this.createMatrix(1, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldMatrix.setEntry(0, i2, this.getEntry(n, i2));
        }
        return fieldMatrix;
    }

    @Override
    public void setRowMatrix(int n, FieldMatrix<T> fieldMatrix) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (fieldMatrix.getRowDimension() != 1 || fieldMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, fieldMatrix.getEntry(0, i2));
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int n) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        FieldMatrix<T> fieldMatrix = this.createMatrix(n2, 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldMatrix.setEntry(i2, 0, this.getEntry(i2, n));
        }
        return fieldMatrix;
    }

    @Override
    public void setColumnMatrix(int n, FieldMatrix<T> fieldMatrix) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (fieldMatrix.getRowDimension() != n2 || fieldMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, fieldMatrix.getEntry(i2, 0));
        }
    }

    @Override
    public FieldVector<T> getRowVector(int n) {
        return new ArrayFieldVector(this.field, this.getRow(n), false);
    }

    @Override
    public void setRowVector(int n, FieldVector<T> fieldVector) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (fieldVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(1, fieldVector.getDimension(), 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, fieldVector.getEntry(i2));
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int n) {
        return new ArrayFieldVector(this.field, this.getColumn(n), false);
    }

    @Override
    public void setColumnVector(int n, FieldVector<T> fieldVector) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (fieldVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(fieldVector.getDimension(), 1, n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, fieldVector.getEntry(i2));
        }
    }

    @Override
    public T[] getRow(int n) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldElementArray[i2] = this.getEntry(n, i2);
        }
        return fieldElementArray;
    }

    @Override
    public void setRow(int n, T[] TArray) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, TArray.length, 1, n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(n, i2, TArray[i2]);
        }
    }

    @Override
    public T[] getColumn(int n) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldElementArray[i2] = this.getEntry(i2, n);
        }
        return fieldElementArray;
    }

    @Override
    public void setColumn(int n, T[] TArray) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(TArray.length, 1, n2, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2, n, TArray[i2]);
        }
    }

    @Override
    public abstract T getEntry(int var1, int var2);

    @Override
    public abstract void setEntry(int var1, int var2, T var3);

    @Override
    public abstract void addToEntry(int var1, int var2, T var3);

    @Override
    public abstract void multiplyEntry(int var1, int var2, T var3);

    @Override
    public FieldMatrix<T> transpose() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<T> fieldMatrix = this.createMatrix(n2, n);
        AbstractFieldMatrix abstractFieldMatrix = this;
        this.walkInOptimizedOrder(new AbstractFieldMatrix$3(abstractFieldMatrix, (FieldElement)abstractFieldMatrix.field.getZero(), fieldMatrix));
        return fieldMatrix;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public T getTrace() {
        int n;
        int n2 = this.getRowDimension();
        if (n2 != (n = this.getColumnDimension())) {
            throw new NonSquareMatrixException(n2, n);
        }
        FieldElement fieldElement = (FieldElement)this.field.getZero();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            fieldElement = (FieldElement)fieldElement.add(this.getEntry(n4, n4));
        }
        return (T)fieldElement;
    }

    @Override
    public T[] operate(T[] TArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new DimensionMismatchException(TArray.length, n2);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n);
        for (int i2 = 0; i2 < n; ++i2) {
            FieldElement fieldElement = (FieldElement)this.field.getZero();
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldElement = (FieldElement)fieldElement.add(this.getEntry(i2, i3).multiply(TArray[i3]));
            }
            fieldElementArray[i2] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public FieldVector<T> operate(FieldVector<T> fieldVector) {
        try {
            return new ArrayFieldVector(this.field, this.operate(((ArrayFieldVector)fieldVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (fieldVector.getDimension() != n2) {
                throw new DimensionMismatchException(fieldVector.getDimension(), n2);
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n);
            for (int i2 = 0; i2 < n; ++i2) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int i3 = 0; i3 < n2; ++i3) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(i2, i3).multiply(fieldVector.getEntry(i3)));
                }
                fieldElementArray[i2] = fieldElement;
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public T[] preMultiply(T[] TArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n) {
            throw new DimensionMismatchException(TArray.length, n);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldElement fieldElement = (FieldElement)this.field.getZero();
            for (int i3 = 0; i3 < n; ++i3) {
                fieldElement = (FieldElement)fieldElement.add(this.getEntry(i3, i2).multiply(TArray[i3]));
            }
            fieldElementArray[i2] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public FieldVector<T> preMultiply(FieldVector<T> fieldVector) {
        try {
            return new ArrayFieldVector(this.field, this.preMultiply(((ArrayFieldVector)fieldVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (fieldVector.getDimension() != n) {
                throw new DimensionMismatchException(fieldVector.getDimension(), n);
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int i3 = 0; i3 < n; ++i3) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(i3, i2).multiply(fieldVector.getEntry(i3)));
                }
                fieldElementArray[i2] = fieldElement;
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                T t = this.getEntry(i2, i3);
                t = fieldMatrixChangingVisitor.visit(i2, i3, t);
                this.setEntry(i2, i3, t);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fieldMatrixPreservingVisitor.visit(i2, i3, this.getEntry(i2, i3));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                T t = this.getEntry(n, i2);
                t = fieldMatrixChangingVisitor.visit(n, i2, t);
                this.setEntry(n, i2, t);
            }
            ++n;
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        while (n <= n2) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                fieldMatrixPreservingVisitor.visit(n, i2, this.getEntry(n, i2));
            }
            ++n;
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                T t = this.getEntry(i3, i2);
                t = fieldMatrixChangingVisitor.visit(i3, i2, t);
                this.setEntry(i3, i2, t);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                fieldMatrixPreservingVisitor.visit(i3, i2, this.getEntry(i3, i2));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                T t = this.getEntry(i2, n3);
                t = fieldMatrixChangingVisitor.visit(i2, n3, t);
                this.setEntry(i2, n3, t);
            }
            ++n3;
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        while (n3 <= n4) {
            for (int i2 = n; i2 <= n2; ++i2) {
                fieldMatrixPreservingVisitor.visit(i2, n3, this.getEntry(i2, n3));
            }
            ++n3;
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        return this.walkInRowOrder(fieldMatrixChangingVisitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        return this.walkInRowOrder(fieldMatrixPreservingVisitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(fieldMatrixChangingVisitor, n, n2, n3, n4);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(fieldMatrixPreservingVisitor, n, n2, n3, n4);
    }

    public String toString() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        stringBuffer.append(string).append("{");
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{");
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i3 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.getEntry(i2, i3));
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldMatrix)) {
            return false;
        }
        object = (FieldMatrix)object;
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (object.getColumnDimension() != n2 || object.getRowDimension() != n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.getEntry(i2, i3).equals(object.getEntry(i2, i3))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        int n3 = n + 9999422;
        n3 = n3 * 31 + n2;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 = n3 * 31 + (11 * (i2 + 1) + 17 * (i3 + 1)) * this.getEntry(i2, i3).hashCode();
            }
        }
        return n3;
    }

    protected void checkRowIndex(int n) {
        if (n < 0 || n >= this.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)n, 0, this.getRowDimension() - 1);
        }
    }

    protected void checkColumnIndex(int n) {
        if (n < 0 || n >= this.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)n, 0, this.getColumnDimension() - 1);
        }
    }

    protected void checkSubMatrixIndex(int n, int n2, int n3, int n4) {
        this.checkRowIndex(n);
        this.checkRowIndex(n2);
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, true);
        }
        this.checkColumnIndex(n3);
        this.checkColumnIndex(n4);
        if (n4 < n3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)n4, n3, true);
        }
    }

    protected void checkSubMatrixIndex(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            throw new NullArgumentException();
        }
        if (nArray.length == 0 || nArray2.length == 0) {
            throw new NoDataException();
        }
        for (int n2 : nArray) {
            this.checkRowIndex(n2);
        }
        nArray = nArray2;
        int n = nArray2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2;
            n2 = nArray[i2];
            this.checkColumnIndex(n2);
        }
    }

    protected void checkAdditionCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getRowDimension() != fieldMatrix.getRowDimension() || this.getColumnDimension() != fieldMatrix.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkSubtractionCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getRowDimension() != fieldMatrix.getRowDimension() || this.getColumnDimension() != fieldMatrix.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkMultiplicationCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getColumnDimension() != fieldMatrix.getRowDimension()) {
            throw new DimensionMismatchException(fieldMatrix.getRowDimension(), this.getColumnDimension());
        }
    }
}

